/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.webtools.filesets;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.archives.webtools.Messages;
import org.jboss.ide.eclipse.archives.webtools.filesets.Fileset;
import org.jboss.ide.eclipse.archives.webtools.filesets.FilesetContentProvider;
import org.jboss.ide.eclipse.archives.webtools.filesets.FilesetDialog;
import org.jboss.ide.eclipse.as.core.server.IDeployableServer;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.JBossExtendedProperties;
import org.jboss.ide.eclipse.as.core.util.FileUtil;
import org.jboss.ide.eclipse.as.ui.JBossServerUIPlugin;

public class FilesetActionProvider
extends CommonActionProvider
implements IDoubleClickListener {
    private ICommonActionExtensionSite actionSite;
    private Action createFilter;
    private Action deleteFilter;
    private Action editFilter;
    private Action deleteFileAction;
    private Action editFileAction;
    private ITreeSelection treeSelection;
    private Object[] selected;

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        this.actionSite = aSite;
        ICommonViewerSite site = aSite.getViewSite();
        if (site instanceof ICommonViewerWorkbenchSite) {
            StructuredViewer v = aSite.getStructuredViewer();
            v.addDoubleClickListener((IDoubleClickListener)this);
        }
        this.createActions();
    }

    public void dispose() {
        ICommonViewerSite site = this.actionSite.getViewSite();
        if (site instanceof ICommonViewerWorkbenchSite) {
            StructuredViewer v = this.actionSite.getStructuredViewer();
            v.removeDoubleClickListener((IDoubleClickListener)this);
        }
        super.dispose();
    }

    public void fillContextMenu(IMenuManager menu) {
        ICommonViewerSite site = this.actionSite.getViewSite();
        if (site instanceof ICommonViewerWorkbenchSite) {
            this.setSelection();
            if (this.selected == null) {
                return;
            }
            if (this.selected.length == 1 && this.selected[0] instanceof FilesetContentProvider.ServerWrapper) {
                menu.add((IAction)this.createFilter);
            } else if (this.selected.length == 1 && this.selected[0] instanceof Fileset) {
                menu.add((IAction)this.deleteFilter);
                menu.add((IAction)this.editFilter);
            } else if (this.allPathWrappers(this.selected)) {
                this.editFileAction.setEnabled(this.canEdit(this.selected));
                this.deleteFileAction.setEnabled(this.canDelete(this.selected));
                menu.add((IAction)this.editFileAction);
                menu.add((IAction)this.deleteFileAction);
            }
        }
    }

    protected void setSelection() {
        ICommonViewerSite site = this.actionSite.getViewSite();
        if (site instanceof ICommonViewerWorkbenchSite) {
            ITreeSelection selection;
            ICommonViewerWorkbenchSite wsSite = (ICommonViewerWorkbenchSite)site;
            this.treeSelection = selection = (ITreeSelection)wsSite.getSelectionProvider().getSelection();
            this.selected = selection.toArray();
        }
    }

    protected boolean allPathWrappers(Object[] list) {
        boolean result = true;
        int i = 0;
        while (i < list.length) {
            result &= list[i] instanceof FilesetContentProvider.PathWrapper;
            ++i;
        }
        return result;
    }

    protected boolean canDelete(Object[] list) {
        boolean result = true;
        int i = 0;
        while (i < list.length) {
            result &= ((FilesetContentProvider.PathWrapper)list[i]).getPath().toFile().exists();
            ++i;
        }
        return result;
    }

    protected boolean canEdit(Object[] list) {
        int i = 0;
        while (i < list.length) {
            if (this.canEdit(((FilesetContentProvider.PathWrapper)list[i]).getPath().toFile())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean canEdit(File file) {
        IFile eclipseFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(file.getAbsolutePath()));
        IFileStore fileStore = EFS.getLocalFileSystem().fromLocalFile(file);
        boolean editable = false;
        if (eclipseFile != null) {
            FileEditorInput input = new FileEditorInput(eclipseFile);
            IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
            if (input != null && desc != null) {
                editable = true;
            }
        } else if (fileStore != null) {
            FileStoreEditorInput input = new FileStoreEditorInput(fileStore);
            IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
            if (input != null && desc != null) {
                editable = true;
            }
        }
        return editable;
    }

    protected File[] getSelectedFiles() {
        ArrayList<File> tmp = new ArrayList<File>();
        int i = 0;
        while (i < this.selected.length) {
            if (this.selected[i] instanceof FilesetContentProvider.PathWrapper) {
                tmp.add(((FilesetContentProvider.PathWrapper)this.selected[i]).getPath().toFile());
            }
            ++i;
        }
        return tmp.toArray(new File[tmp.size()]);
    }

    protected FilesetContentProvider.ServerWrapper getServerWrapper(Fileset fs) {
        Object wrapper;
        int count;
        TreePath[] paths = this.treeSelection.getPathsFor((Object)fs);
        if (paths.length == 1 && (count = paths[0].getSegmentCount()) > 1 && (wrapper = paths[0].getSegment(count - 2)) != null && wrapper instanceof FilesetContentProvider.ServerWrapper) {
            return (FilesetContentProvider.ServerWrapper)wrapper;
        }
        return null;
    }

    protected void createActions() {
        this.createFilter = new Action(){

            public void run() {
                FilesetDialog d;
                String defaultFolder;
                IServer iserver = null;
                if (!(FilesetActionProvider.this.selected[0] instanceof FilesetContentProvider.ServerWrapper)) {
                    return;
                }
                FilesetContentProvider.ServerWrapper wrapper = (FilesetContentProvider.ServerWrapper)FilesetActionProvider.this.selected[0];
                iserver = wrapper.server;
                IDeployableServer cfr_ignored_0 = (IDeployableServer)iserver.loadAdapter(IDeployableServer.class, (IProgressMonitor)new NullProgressMonitor());
                JBossExtendedProperties o = (JBossExtendedProperties)iserver.loadAdapter(JBossExtendedProperties.class, (IProgressMonitor)new NullProgressMonitor());
                String string = defaultFolder = o == null ? "" : o.getNewFilesetDefaultRootFolder();
                if (defaultFolder != null && (d = new FilesetDialog(new Shell(), defaultFolder, iserver)).open() == 0) {
                    Fileset fs = d.getFileset();
                    wrapper.addFileset(fs);
                    FilesetActionProvider.this.actionSite.getStructuredViewer().refresh((Object)wrapper);
                }
            }
        };
        this.createFilter.setText(Messages.FilesetsCreateFilter);
        this.deleteFilter = new Action(){

            public void run() {
                Fileset fs = (Fileset)FilesetActionProvider.this.selected[0];
                FilesetContentProvider.ServerWrapper wrapper = FilesetActionProvider.this.getServerWrapper(fs);
                if (wrapper != null) {
                    wrapper.removeFileset(fs);
                    FilesetActionProvider.this.actionSite.getStructuredViewer().refresh((Object)wrapper);
                }
            }
        };
        this.deleteFilter.setText(Messages.FilesetsDeleteFilter);
        this.editFilter = new Action(){

            public void run() {
                Fileset sel = (Fileset)FilesetActionProvider.this.selected[0];
                FilesetContentProvider.ServerWrapper wrapper = FilesetActionProvider.this.getServerWrapper(sel);
                FilesetDialog d = new FilesetDialog(new Shell(), sel);
                if (d.open() == 0) {
                    Fileset ret = d.getFileset();
                    sel.setName(ret.getName());
                    sel.setFolder(ret.getRawFolder());
                    sel.setIncludesPattern(ret.getIncludesPattern());
                    sel.setExcludesPattern(ret.getExcludesPattern());
                    wrapper.saveFilesets();
                    FilesetActionProvider.this.actionSite.getStructuredViewer().refresh((Object)wrapper);
                }
            }
        };
        this.editFilter.setText(Messages.FilesetsEditFilter);
        this.deleteFileAction = new Action(){

            public void run() {
                try {
                    Shell shell = Display.getCurrent().getActiveShell();
                    File[] files = FilesetActionProvider.this.getSelectedFiles();
                    MessageBox mb = new MessageBox(shell, 292);
                    mb.setText(Messages.DeleteFiles);
                    mb.setMessage(Messages.DeleteFilesMessage);
                    if (mb.open() == 32) {
                        int i = 0;
                        while (i < files.length) {
                            FileUtil.safeDelete((File)files[i]);
                            ++i;
                        }
                        FilesetActionProvider.this.refreshViewer();
                    }
                }
                catch (Exception exception) {}
            }
        };
        this.deleteFileAction.setText(Messages.FilesetsDeleteFile);
        this.editFileAction = new Action(){

            public void run() {
                File[] files = FilesetActionProvider.this.getSelectedFiles();
                IWorkbench wb = PlatformUI.getWorkbench();
                IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
                IWorkbenchPage page = win.getActivePage();
                int i = 0;
                while (i < files.length) {
                    try {
                        IEditorDescriptor desc;
                        FileEditorInput input;
                        IFile eclipseFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(files[i].getAbsolutePath()));
                        IFileStore fileStore = EFS.getLocalFileSystem().fromLocalFile(files[i]);
                        if (eclipseFile != null) {
                            input = new FileEditorInput(eclipseFile);
                            desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(files[i].getName());
                            if (desc != null) {
                                page.openEditor((IEditorInput)input, desc.getId());
                            }
                        } else if (fileStore != null) {
                            input = new FileStoreEditorInput(fileStore);
                            desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(files[i].getName());
                            if (desc != null) {
                                page.openEditor((IEditorInput)input, desc.getId());
                            }
                        }
                    }
                    catch (Exception e) {
                        Status status = new Status(4, "org.jboss.ide.eclipse.as.ui", Messages.FilesetsCannotOpenFile, (Throwable)e);
                        JBossServerUIPlugin.getDefault().getLog().log((IStatus)status);
                    }
                    ++i;
                }
            }
        };
        this.editFileAction.setText(Messages.FilesetsEditFile);
    }

    protected void refreshViewer() {
        this.actionSite.getStructuredViewer().refresh();
    }

    public void doubleClick(DoubleClickEvent event) {
        this.setSelection();
        this.editFileAction.run();
    }
}

