/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.internal.management.as7.tests;

import java.util.ArrayList;
import java.util.Collection;
import junit.framework.Assert;
import org.eclipse.core.runtime.Path;
import org.jboss.ide.eclipse.as.internal.management.as7.tests.utils.AS7ManagerTestUtils;
import org.jboss.ide.eclipse.as.internal.management.as7.tests.utils.ParameterUtils;
import org.jboss.ide.eclipse.as.management.core.IJBoss7ManagerService;
import org.jboss.ide.eclipse.as.management.core.JBoss7ManagerServiceProxy;
import org.jboss.ide.eclipse.as.management.core.JBoss7ManagerUtil;
import org.jboss.tools.as.test.core.internal.utils.MatrixUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.osgi.util.tracker.ServiceTracker;

@RunWith(value=Parameterized.class)
public class AS7ManagementServicePreReqTest
extends Assert {
    private String homeDir;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        ArrayList l = MatrixUtils.toMatrix((Object[][])new Object[][]{ParameterUtils.getAS7ServerHomes()});
        return l;
    }

    public AS7ManagementServicePreReqTest(String home) {
        this.homeDir = home;
    }

    @Test
    public void verifyCorrectService() {
        AS7ManagementServicePreReqTest.assertNotNull((Object)this.homeDir);
        AS7ManagementServicePreReqTest.assertTrue((String)(String.valueOf(this.homeDir) + " does not exist."), (boolean)new Path(this.homeDir).toFile().exists());
        String rtType = ParameterUtils.serverHomeToRuntimeType.get(this.homeDir);
        AS7ManagementServicePreReqTest.assertNotNull((String)("runtime type for homedir " + this.homeDir + " is null"), (Object)rtType);
        IJBoss7ManagerService service = AS7ManagerTestUtils.findService(rtType);
        AS7ManagementServicePreReqTest.assertNotNull((String)("Management Service for runtime type " + rtType + " not found."), (Object)service);
        IJBoss7ManagerService service2 = JBoss7ManagerUtil.getService((String)rtType);
        AS7ManagementServicePreReqTest.assertNotNull((String)("Management Service for runtime type " + rtType + " not found."), (Object)service2);
        AS7ManagementServicePreReqTest.assertTrue((boolean)(service instanceof JBoss7ManagerServiceProxy));
        AS7ManagementServicePreReqTest.assertTrue((boolean)(service instanceof ServiceTracker));
        Object o = ((ServiceTracker)service).getService();
        AS7ManagementServicePreReqTest.assertNotNull((Object)o);
    }
}

