/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.internal.management.as7.tests;

import java.net.UnknownHostException;
import org.jboss.ide.eclipse.as.internal.management.as7.tests.Activator;
import org.jboss.ide.eclipse.as.management.core.IJBoss7ManagerService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;

public class JBossManagementServiceTest {
    private static final String DS_BUNDLEID = "org.eclipse.equinox.ds";
    private static final String AS7MANAGER_PLUGINID = "org.jboss.ide.eclipse.as.management.as71";

    @Before
    public void setUp() throws UnknownHostException {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void serviceIsReachable() throws BundleException {
        this.ensureDSIsRunning();
        this.ensureServiceBundleIsRunning();
        BundleContext context = Activator.getContext();
        ServiceReference reference = context.getServiceReference(IJBoss7ManagerService.class);
        Assert.assertNotNull((Object)reference);
        IJBoss7ManagerService service = (IJBoss7ManagerService)context.getService(reference);
        Assert.assertNotNull((Object)service);
    }

    private void ensureServiceBundleIsRunning() throws BundleException {
        BundleContext context = Activator.getContext();
        Assert.assertNotNull((String)"bundle of this test is not active", (Object)context);
        Bundle bundle = this.getBundle(AS7MANAGER_PLUGINID);
        Assert.assertNotNull((String)"org.jboss.ide.eclipse.as.management.as71 not installed", (Object)bundle);
        this.startBundle(bundle);
    }

    private void ensureDSIsRunning() throws BundleException {
        BundleContext context = Activator.getContext();
        Assert.assertNotNull((String)"bundle of this test is not active", (Object)context);
        Bundle bundle = this.getBundle(DS_BUNDLEID);
        Assert.assertNotNull((String)("org.eclipse.equinox.ds not installed. You have to install the declarative services daemon so that " + IJBoss7ManagerService.class + " service is registered"), (Object)bundle);
        this.startBundle(bundle);
    }

    private void startBundle(Bundle bundle) throws BundleException {
        if (bundle.getState() != 32) {
            bundle.start();
        }
    }

    private Bundle getBundle(String id) {
        Bundle bundleFound = null;
        Bundle[] bundleArray = Activator.getContext().getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (id.equals(bundle.getSymbolicName())) {
                bundleFound = bundle;
                break;
            }
            ++n2;
        }
        return bundleFound;
    }
}

