/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.rse.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemModelChangeEvent;
import org.eclipse.rse.core.events.ISystemModelChangeListener;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.ui.wizards.newconnection.RSEMainNewConnectionWizard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IRuntime;
import org.jboss.ide.eclipse.as.core.server.IDeployableServer;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.ide.eclipse.as.rse.core.RSEFrameworkUtils;
import org.jboss.ide.eclipse.as.rse.ui.RSEBrowseBehavior;
import org.jboss.ide.eclipse.as.rse.ui.RSEUIMessages;
import org.jboss.ide.eclipse.as.ui.JBossServerUIPlugin;
import org.jboss.ide.eclipse.as.ui.UIUtil;
import org.jboss.ide.eclipse.as.ui.editor.IDeploymentTypeUI;
import org.jboss.ide.eclipse.as.ui.editor.ServerModeSectionComposite;

public abstract class RSEDeploymentPreferenceComposite
extends Composite
implements PropertyChangeListener {
    protected IDeploymentTypeUI.IServerModeUICallback callback;
    protected CustomSystemHostCombo combo;
    protected ModifyListener comboMListener;
    private boolean updatingFromModelChange = false;

    public RSEDeploymentPreferenceComposite(Composite parent, int style, IDeploymentTypeUI.IServerModeUICallback callback) {
        super(parent, style);
        this.callback = callback;
        this.setLayout((Layout)new FormLayout());
        Composite child = new Composite((Composite)this, 0);
        child.setLayoutData((Object)UIUtil.createFormData2((Object)0, (int)0, null, (int)0, (Object)0, (int)5, (Object)100, (int)0));
        child.setLayout((Layout)new GridLayout());
        String current = this.discoverCurrentHost(callback);
        this.combo = new CustomSystemHostCombo(child, 0, current, "files");
        this.comboMListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RSEDeploymentPreferenceComposite.this.rseHostChanged();
            }
        };
        this.combo.getCombo().addModifyListener(this.comboMListener);
        this.createRSEWidgets(child);
    }

    protected abstract void createRSEWidgets(Composite var1);

    protected IDeployableServer getServer() {
        return (IDeployableServer)this.callback.getServer().loadAdapter(IDeployableServer.class, (IProgressMonitor)new NullProgressMonitor());
    }

    protected String browseClicked3(Shell shell) {
        return RSEBrowseBehavior.browseClicked(this.getShell(), this.combo.getHost());
    }

    protected IJBossServerRuntime getRuntime() {
        IRuntime rt = this.callback.getRuntime();
        if (rt == null) {
            return null;
        }
        return (IJBossServerRuntime)rt.loadAdapter(IJBossServerRuntime.class, null);
    }

    protected void showMessageDialog(String title, IStatus s, Shell shell) {
        ErrorDialog d = new ErrorDialog(shell, title, null, s, 5);
        d.open();
    }

    protected String discoverCurrentHost(IDeploymentTypeUI.IServerModeUICallback callback) {
        String current = callback.getServer().getAttribute("org.jboss.ide.eclipse.as.rse.core.ServerHost", null);
        if (current == null) {
            String serverHost = callback.getServer().getHost().toLowerCase();
            IHost[] hosts = RSECorePlugin.getTheSystemRegistry().getHostsBySubSystemConfigurationCategory("files");
            int i = 0;
            while (i < hosts.length) {
                String name = hosts[i].getName();
                String hostName = hosts[i].getHostName();
                if (hostName.toLowerCase().equals(serverHost)) {
                    callback.getServer().setAttribute("org.jboss.ide.eclipse.as.rse.core.ServerHost", name);
                    return hosts[i].getName();
                }
                ++i;
            }
        }
        return current;
    }

    public void dispose() {
        super.dispose();
        this.callback.getServer().removePropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.updatingFromModelChange = true;
        this.propertyChangeBody(evt);
        this.updatingFromModelChange = false;
    }

    protected boolean isUpdatingFromModelChange() {
        return this.updatingFromModelChange;
    }

    protected void propertyChangeBody(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("org.jboss.ide.eclipse.as.rse.core.ServerHost")) {
            this.combo.setHostName(evt.getNewValue().toString());
        }
    }

    protected void updateTextIfChanges(Text control, String newValue) {
        if (!control.getText().equals(newValue)) {
            control.setText(newValue);
        }
    }

    protected void rseHostChanged() {
        String oldVal;
        String hostName;
        if (!(this.updatingFromModelChange || (hostName = this.combo.getHost() == null ? null : this.combo.getHost().getAliasName()).equals(oldVal = this.callback.getServer().getAttribute("org.jboss.ide.eclipse.as.rse.core.ServerHost", null)) || this.updatingFromModelChange)) {
            this.callback.execute((IUndoableOperation)new ServerModeSectionComposite.ChangeServerPropertyCommand(this.callback.getServer(), "org.jboss.ide.eclipse.as.rse.core.ServerHost", hostName, "localhost", RSEUIMessages.CHANGE_RSE_HOST));
            this.callback.execute((IUndoableOperation)new ServerModeSectionComposite.ChangeServerPropertyCommand(this.callback.getServer(), "hostname", this.combo.getHost().getHostName(), RSEUIMessages.CHANGE_HOSTNAME));
        }
    }

    public class CustomSystemHostCombo
    extends Composite
    implements ModifyListener,
    ISystemModelChangeListener {
        private String fileSubSystem;
        private Combo combo;
        private Button newHost;
        private IHost currentHost;
        private String currentHostName;
        private IHost[] hosts;
        private String[] hostsAsStrings;

        public CustomSystemHostCombo(Composite parent, int style, String initialHostName, String fileSubSystem) {
            super(parent, style);
            this.fileSubSystem = fileSubSystem;
            this.currentHostName = initialHostName;
            this.hosts = RSECorePlugin.getTheSystemRegistry().getHostsBySubSystemConfigurationCategory(fileSubSystem);
            this.currentHost = this.findHost(initialHostName);
            RSECorePlugin.getTheSystemRegistry().addSystemModelChangeListener((ISystemModelChangeListener)this);
            GridData data = new GridData();
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            data.widthHint = 200;
            data.verticalAlignment = 2;
            data.grabExcessVerticalSpace = false;
            this.setLayoutData(data);
            this.setLayout((Layout)new FormLayout());
            Label l = new Label((Composite)this, 0);
            l.setText("Host");
            this.newHost = new Button((Composite)this, 0);
            this.newHost.setText("New Host...");
            this.newHost.setLayoutData((Object)UIUtil.createFormData2((Object)0, (int)0, null, (int)0, null, (int)0, (Object)100, (int)-5));
            this.newHost.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    CustomSystemHostCombo.this.newHostClicked();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.combo = new Combo((Composite)this, 2056);
            l.setLayoutData((Object)UIUtil.createFormData2((Object)0, (int)5, null, (int)0, (Object)0, (int)0, null, (int)0));
            this.combo.setLayoutData((Object)UIUtil.createFormData2((Object)0, (int)0, null, (int)0, (Object)l, (int)5, (Object)this.newHost, (int)-5));
            this.refreshConnections();
            this.combo.addModifyListener((ModifyListener)this);
            Link openRSEView = new Link((Composite)this, 0);
            openRSEView.setText("<a>Open Remote System Explorer View...</a>");
            openRSEView.setLayoutData((Object)UIUtil.createFormData2((Object)this.combo, (int)5, null, (int)0, null, (int)0, (Object)100, (int)-5));
            openRSEView.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    IWorkbenchPage page;
                    String viewId = "org.eclipse.rse.ui.view.systemView";
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (window != null && (page = window.getActivePage()) != null) {
                        IViewPart part = page.findView(viewId);
                        if (part == null) {
                            try {
                                part = page.showView(viewId);
                            }
                            catch (PartInitException pie) {
                                Status status = new Status(4, "org.jboss.ide.eclipse.as.rse.ui", pie.getMessage(), (Throwable)pie);
                                JBossServerUIPlugin.getDefault().getLog().log((IStatus)status);
                            }
                        } else {
                            IViewPart view = (IViewPart)part.getAdapter(IViewPart.class);
                            if (view != null) {
                                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)view);
                                view.setFocus();
                            }
                        }
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }

        protected void newHostClicked() {
            RSEMainNewConnectionWizard newConnWizard = new RSEMainNewConnectionWizard();
            WizardDialog d = new WizardDialog(this.getShell(), (IWizard)newConnWizard);
            d.open();
        }

        public IHost findHost(String name) {
            return RSEFrameworkUtils.findHost((String)name, (IHost[])this.hosts);
        }

        public Combo getCombo() {
            return this.combo;
        }

        public IHost getHost() {
            return this.currentHost;
        }

        public String getHostName() {
            return this.currentHostName;
        }

        public void setHostName(String name) {
            this.currentHostName = name;
            this.currentHost = this.findHost(this.currentHostName);
            if (this.currentHost == null) {
                this.combo.clearSelection();
            } else {
                String[] items = this.combo.getItems();
                int i = 0;
                while (i < items.length) {
                    if (items[i].equals(this.currentHost.getAliasName())) {
                        this.combo.select(i);
                        return;
                    }
                    ++i;
                }
            }
        }

        public void refreshConnections() {
            this.hosts = RSECorePlugin.getTheSystemRegistry().getHostsBySubSystemConfigurationCategory(this.fileSubSystem);
            this.hostsAsStrings = new String[this.hosts.length];
            int currentHostIndex = -1;
            int i = 0;
            while (i < this.hosts.length) {
                this.hostsAsStrings[i] = this.hosts[i].getAliasName();
                if (currentHostIndex == -1 && this.currentHostName != null && this.hostsAsStrings[i].equals(this.currentHostName)) {
                    currentHostIndex = i;
                }
                ++i;
            }
            this.combo.setItems(this.hostsAsStrings);
            if (currentHostIndex != -1) {
                this.combo.select(currentHostIndex);
            } else {
                this.combo.clearSelection();
            }
        }

        public void modifyText(ModifyEvent e) {
            int index = this.combo.getSelectionIndex();
            if (index != -1) {
                String s = this.combo.getItem(index);
                int i = 0;
                while (i < this.hosts.length) {
                    if (this.hosts[i].getAliasName().equals(s)) {
                        this.currentHost = this.hosts[i];
                        this.currentHostName = this.currentHost.getAliasName();
                        return;
                    }
                    ++i;
                }
            }
        }

        public void systemModelResourceChanged(ISystemModelChangeEvent event) {
            if (this.combo.isDisposed()) {
                return;
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    List<String> before = Arrays.asList(CustomSystemHostCombo.this.combo.getItems());
                    CustomSystemHostCombo.this.combo.removeModifyListener(((CustomSystemHostCombo)CustomSystemHostCombo.this).RSEDeploymentPreferenceComposite.this.comboMListener);
                    CustomSystemHostCombo.this.refreshConnections();
                    CustomSystemHostCombo.this.combo.addModifyListener(((CustomSystemHostCombo)CustomSystemHostCombo.this).RSEDeploymentPreferenceComposite.this.comboMListener);
                    String[] after = CustomSystemHostCombo.this.combo.getItems();
                    int i = 0;
                    while (i < after.length) {
                        if (!before.contains(after[i])) {
                            CustomSystemHostCombo.this.combo.select(i);
                            return;
                        }
                        ++i;
                    }
                }
            });
        }

        public void dispose() {
            super.dispose();
            RSECorePlugin.getTheSystemRegistry().removeSystemModelChangeListener((ISystemModelChangeListener)this);
        }
    }
}

