/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.classpath;

import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.jmx.core.test.util.TestProjectProvider;

public class JEEClasspathContainerTest
extends TestCase {
    private static final int ORIGINAL_ENTRIES = 2;
    private TestProjectProvider provider;
    private IProject project;

    protected void setUp() throws Exception {
        this.provider = new TestProjectProvider("org.jboss.tools.as.test.core", null, "basicwebproject", true);
        this.project = this.provider.getProject();
        this.project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
    }

    protected void tearDown() throws Exception {
        this.provider.dispose();
    }

    public void testJEE13ClasspathContainer() {
        this.testGenericClasspathContainer("org.jboss.ide.eclipse.as.classpath.core.j2ee-1.3", 7);
    }

    public void testJEE14ClasspathContainer() {
        this.testGenericClasspathContainer("org.jboss.ide.eclipse.as.classpath.core.j2ee-1.4", 8);
    }

    public void testJEE50ClasspathContainer() {
        this.testGenericClasspathContainer("org.jboss.ide.eclipse.as.classpath.core.javaee-5.0", 3);
    }

    protected void testGenericClasspathContainer(String containerPath, int expectedEntries) {
        try {
            IJavaProject jproject = JavaCore.create((IProject)this.project);
            Path path = new Path(containerPath);
            this.verifyContainerEntries((IPath)path, jproject, expectedEntries);
            this.verifyRawClasspathCount(jproject, 2);
            this.verifyNotIncludedEntry(jproject, (IPath)path);
            int beforeRawCount = jproject.getRawClasspath().length;
            int beforeResolvedCount = jproject.getResolvedClasspath(true).length;
            this.addContainer(jproject, (IPath)path);
            JEEClasspathContainerTest.assertEquals((int)(beforeRawCount + 1), (int)jproject.getRawClasspath().length);
            JEEClasspathContainerTest.assertEquals((int)(beforeResolvedCount + expectedEntries), (int)jproject.getResolvedClasspath(true).length);
            beforeRawCount = jproject.getRawClasspath().length;
            beforeResolvedCount = jproject.getResolvedClasspath(true).length;
            this.removeContainer(jproject, (IPath)path);
            JEEClasspathContainerTest.assertEquals((int)(beforeRawCount - 1), (int)jproject.getRawClasspath().length);
            JEEClasspathContainerTest.assertEquals((int)(beforeResolvedCount - expectedEntries), (int)jproject.getResolvedClasspath(true).length);
        }
        catch (JavaModelException jme) {
            JEEClasspathContainerTest.fail((String)("Exception: " + jme.getMessage()));
        }
        catch (CoreException ce) {
            JEEClasspathContainerTest.fail((String)("Exception: " + ce.getMessage()));
        }
    }

    protected void verifyContainerEntries(IPath path, IJavaProject jproject, int expected) throws JavaModelException {
        IClasspathContainer cpc = JavaCore.getClasspathContainer((IPath)path, (IJavaProject)jproject);
        IClasspathEntry[] entries = cpc.getClasspathEntries();
        JEEClasspathContainerTest.assertEquals((String)"Received unexpected number of entries", (int)expected, (int)entries.length);
    }

    protected void verifyRawClasspathCount(IJavaProject jproject, int count) throws JavaModelException {
        IClasspathEntry[] projectEntry = jproject.getRawClasspath();
        JEEClasspathContainerTest.assertEquals((String)("Project should start with only " + count + " classpath entries"), (int)count, (int)projectEntry.length);
    }

    protected void verifyNotIncludedEntry(IJavaProject jproject, IPath path) throws JavaModelException {
        IClasspathEntry[] projectEntry = jproject.getRawClasspath();
        int i = 0;
        while (i < projectEntry.length) {
            if (projectEntry[i].getPath().toOSString().startsWith(path.toOSString())) {
                JEEClasspathContainerTest.assertFalse((String)"Project prematurely includes classpath", (boolean)true);
            }
            ++i;
        }
    }

    protected void addContainer(IJavaProject jproject, IPath path) throws JavaModelException {
        ArrayList<IClasspathEntry> tmp = new ArrayList<IClasspathEntry>();
        tmp.addAll(Arrays.asList(jproject.getRawClasspath()));
        tmp.add(JavaCore.newContainerEntry((IPath)path));
        jproject.setRawClasspath(tmp.toArray(new IClasspathEntry[tmp.size()]), null);
    }

    protected void removeContainer(IJavaProject jproject, IPath path) throws JavaModelException {
        ArrayList<IClasspathEntry> tmp = new ArrayList<IClasspathEntry>();
        tmp.addAll(Arrays.asList(jproject.getRawClasspath()));
        tmp.remove(JavaCore.newContainerEntry((IPath)path));
        jproject.setRawClasspath(tmp.toArray(new IClasspathEntry[tmp.size()]), null);
    }
}

