/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.parametized.server;

import java.util.ArrayList;
import java.util.Collection;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.validation.ValidationFramework;
import org.jboss.tools.as.test.core.ASMatrixTests;
import org.jboss.tools.as.test.core.internal.utils.ProjectRuntimeUtil;
import org.jboss.tools.as.test.core.internal.utils.ResourceUtils;
import org.jboss.tools.as.test.core.internal.utils.ServerCreationTestUtils;
import org.jboss.tools.as.test.core.internal.utils.wtp.CreateProjectOperationsUtility;
import org.jboss.tools.as.test.core.internal.utils.wtp.JavaEEFacetConstants;
import org.jboss.tools.as.test.core.internal.utils.wtp.OperationTestCase;
import org.jboss.tools.as.test.core.parametized.server.ServerParameterUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ProjectRuntimeClasspathTest
extends TestCase {
    private static final String PROJECT_ROOT_NAME = "basicwebproject";
    private static int count = 1;
    private IProject project;
    private IServer server;
    private String serverType;
    private String projectName;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return ServerParameterUtils.asCollection(ServerParameterUtils.getJBossServerTypeParamterers());
    }

    public ProjectRuntimeClasspathTest(String serverType) {
        this.serverType = serverType;
        this.projectName = PROJECT_ROOT_NAME + count;
        ++count;
    }

    @Before
    public void setUp() throws Exception {
        ValidationFramework.getDefault().suspendAllValidation(true);
        IDataModel dm = CreateProjectOperationsUtility.getWebDataModel(this.projectName, null, null, null, null, JavaEEFacetConstants.WEB_24, true);
        this.project = this.createSingleProject(dm, this.projectName);
        this.project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        this.server = ServerCreationTestUtils.createServerWithRuntime(this.serverType, String.valueOf(((Object)((Object)this)).getClass().getName()) + this.serverType);
    }

    protected IProject createSingleProject(IDataModel dm, String name) throws Exception {
        OperationTestCase.runAndVerify(dm);
        IProject p = ResourceUtils.findProject(name);
        if (!p.exists()) {
            ProjectRuntimeClasspathTest.fail();
        }
        return p;
    }

    @After
    public void tearDown() throws Exception {
        ASMatrixTests.cleanup();
        ValidationFramework.getDefault().suspendAllValidation(false);
    }

    @Test
    public void testProjectRuntime() {
        ProjectRuntimeClasspathTest.assertNotNull((Object)this.server);
        ProjectRuntimeClasspathTest.assertNotNull((Object)this.server.getRuntime());
        try {
            IJavaProject jp = JavaCore.create((IProject)this.project);
            this.verifyInitialClasspathEntries(jp);
            ProjectRuntimeUtil.setTargetRuntime(this.server.getRuntime(), this.project);
            this.verifyPostRuntimeCPE(jp);
            ProjectRuntimeUtil.clearRuntime(this.project);
            this.verifyInitialClasspathEntries(jp);
        }
        catch (JavaModelException jme) {
            jme.printStackTrace();
            ProjectRuntimeClasspathTest.fail((String)jme.getMessage());
        }
        catch (CoreException ce) {
            ce.printStackTrace();
            ProjectRuntimeClasspathTest.fail((String)ce.getMessage());
        }
    }

    @Test
    public void testJBIDE1657EquivilentEntries() {
        try {
            IJavaProject jp = JavaCore.create((IProject)this.project);
            IRuntime createdRuntime = this.server.getRuntime();
            ProjectRuntimeUtil.setTargetRuntime(createdRuntime, this.project);
            IClasspathEntry[] raw1 = jp.getRawClasspath();
            IClasspathEntry[] resolved1 = jp.getResolvedClasspath(false);
            IClasspathEntry[] raw2 = this.cloneAndReplace(raw1, createdRuntime.getName());
            jp.setRawClasspath(raw2, (IProgressMonitor)new NullProgressMonitor());
            IClasspathEntry[] resolved2 = jp.getResolvedClasspath(false);
            ProjectRuntimeClasspathTest.assertEquals((String)"New classpath container path should return the same classpath entries as the old. ", (int)resolved1.length, (int)resolved2.length);
            ProjectRuntimeClasspathTest.assertTrue((String)"Should be more than one classpath entry", (resolved1.length > 0 ? 1 : 0) != 0);
        }
        catch (CoreException ce) {
            ce.printStackTrace();
            ProjectRuntimeClasspathTest.fail((String)ce.getMessage());
        }
    }

    private IClasspathEntry[] cloneAndReplace(IClasspathEntry[] raw1, String rtName) {
        IClasspathEntry[] raw2 = new IClasspathEntry[raw1.length];
        int i = 0;
        while (i < raw1.length) {
            if (!raw1[i].getPath().segment(0).equals("org.eclipse.jst.server.core.container")) {
                raw2[i] = raw1[i];
            } else {
                Path containerPath = new Path("org.jboss.ide.eclipse.as.classpath.core.runtime.ProjectRuntimeInitializer");
                containerPath = containerPath.append(rtName);
                raw2[i] = JavaCore.newContainerEntry((IPath)containerPath);
            }
            ++i;
        }
        return raw2;
    }

    protected void verifyPostRuntimeCPE(IJavaProject jp) throws CoreException {
        IClasspathEntry[] entries = jp.getRawClasspath();
        String[] required = new String[]{"org.eclipse.jst.server.core.container", this.projectName, "org.eclipse.jst.j2ee.internal.web.container", "org.eclipse.jdt.launching.JRE_CONTAINER"};
        ProjectRuntimeClasspathTest.assertTrue((entries.length >= required.length ? 1 : 0) != 0);
        jp.getResolvedClasspath(false);
        this.verifyClasspathEntries(entries, required);
    }

    protected void verifyInitialClasspathEntries(IJavaProject jp) throws CoreException {
        IClasspathEntry[] entries = jp.getRawClasspath();
        jp.getResolvedClasspath(false);
        String[] required = new String[]{"org.eclipse.jst.j2ee.internal.web.container", this.projectName};
        this.verifyClasspathEntries(entries, required);
    }

    protected void verifyClasspathEntries(IClasspathEntry[] entries, String[] required) {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < required.length) {
            list.add(required[i]);
            ++i;
        }
        i = 0;
        while (i < entries.length) {
            if (list.contains(entries[i].getPath().segment(0))) {
                list.remove(entries[i].getPath().segment(0));
            }
            ++i;
        }
        if (list.size() > 0) {
            String tmp = "Required enties not found: ";
            int i2 = 0;
            while (i2 < list.size()) {
                tmp = String.valueOf(tmp) + (String)list.get(i2) + ", ";
                ++i2;
            }
            ProjectRuntimeClasspathTest.fail((String)tmp.substring(0, tmp.length() - 2));
        }
    }
}

