/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.parametized.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.as.classpath.core.runtime.CustomRuntimeClasspathModel;
import org.jboss.ide.eclipse.as.classpath.core.runtime.IRuntimePathProvider;
import org.jboss.tools.as.test.core.parametized.server.ServerParameterUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ServerTypeDefaultClasspathEntriesTest
extends Assert {
    private String serverType;

    public ServerTypeDefaultClasspathEntriesTest(String serverType) {
        this.serverType = serverType;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return ServerParameterUtils.asCollection(ServerParameterUtils.getJBossServerTypeParamterers());
    }

    @Test
    public void testDefaultClasspathEntriesAdded() {
        ServerTypeDefaultClasspathEntriesTest.assertNotNull((Object)this.serverType);
        IServerType type = ServerCore.findServerType((String)this.serverType);
        if (type == null) {
            ServerTypeDefaultClasspathEntriesTest.fail((String)("Server type " + type + " not found in the build"));
        }
        if (type.getRuntimeType() == null) {
            ServerTypeDefaultClasspathEntriesTest.fail((String)("Server type " + this.serverType + " does not have an associated runtime"));
        }
        IRuntimeType rtType = type.getRuntimeType();
        IRuntimePathProvider[] providers = CustomRuntimeClasspathModel.getInstance().getDefaultEntries(rtType);
        ServerTypeDefaultClasspathEntriesTest.assertNotNull((String)"Null returned for default classpath entries", (Object)providers);
        ServerTypeDefaultClasspathEntriesTest.assertFalse((String)"0 classpath entr yproviders returned", (providers.length == 0 ? 1 : 0) != 0);
        ArrayList<IPath> paths = new ArrayList<IPath>();
        int i = 0;
        while (i < providers.length) {
            paths.addAll(Arrays.asList(providers[i].getAbsolutePaths()));
            ++i;
        }
        ServerTypeDefaultClasspathEntriesTest.assertFalse((String)"0 classpath entries returned", (paths.size() == 0 ? 1 : 0) != 0);
    }
}

