/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.parametized.server.publishing;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.common.componentcore.internal.operation.AddReferenceDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerUtil;
import org.jboss.tools.as.test.core.internal.utils.ResourceUtils;
import org.jboss.tools.as.test.core.internal.utils.wtp.CreateProjectOperationsUtility;
import org.jboss.tools.as.test.core.internal.utils.wtp.JavaEEFacetConstants;
import org.jboss.tools.as.test.core.parametized.server.publishing.DeploymentAssemblyArchivePathVarTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DeploymentAssemblyArchivePathVarNestedWarTest
extends DeploymentAssemblyArchivePathVarTest {
    private static String PROJECT_PREFIX = "qEar";
    private static String PROJECT_NESTED_PREFIX = "qWar";
    private static int PROJECT_ID = 1;
    protected String MY_NESTED_PROJECT_NAME;

    @Parameterized.Parameters
    public static Collection<Object[]> params() {
        return DeploymentAssemblyArchivePathVarNestedWarTest.componentJarData();
    }

    public DeploymentAssemblyArchivePathVarNestedWarTest(String serverType, String zip, String deployLoc, String perMod, String refName, String refFolder) {
        super(serverType, zip, deployLoc, perMod, refName, refFolder);
    }

    @Override
    protected void createProjects() throws Exception {
        this.setProjectName();
        IProject p = this.projectCreation();
        this.addReferences(ResourceUtils.findProject(this.MY_NESTED_PROJECT_NAME));
        this.addModuleToServer(p);
    }

    @Override
    protected void setProjectName() {
        this.MY_PROJECT_NAME = String.valueOf(PROJECT_PREFIX) + ++PROJECT_ID;
        this.MY_NESTED_PROJECT_NAME = String.valueOf(PROJECT_NESTED_PREFIX) + PROJECT_ID;
    }

    @Override
    protected IProject projectCreation() throws Exception {
        IDataModel dm = CreateProjectOperationsUtility.getEARDataModel(this.MY_PROJECT_NAME, "earContent", null, null, JavaEEFacetConstants.EAR_5, false);
        IDataModel dm2 = CreateProjectOperationsUtility.getWebDataModel(this.MY_NESTED_PROJECT_NAME, this.MY_PROJECT_NAME, null, "webContent", null, JavaEEFacetConstants.WEB_25, true);
        IProject ep = this.createSingleProject(dm, this.MY_PROJECT_NAME);
        this.createSingleProject(dm2, this.MY_NESTED_PROJECT_NAME);
        return ep;
    }

    @Override
    protected void verifyFileFoundInModule(String folder, String name, int expectedFileCount) throws Exception {
        IModule secondModule = ServerUtil.getModule((IProject)ResourceUtils.findProject(this.MY_NESTED_PROJECT_NAME));
        this.verifyFileFoundInModule(folder, name, expectedFileCount, secondModule);
    }

    @Override
    @Test
    public void testVariableReference() throws Exception {
        this.verifyFileFoundInModule(this.jarFolder, this.jarName, this.getExpectedFileCount());
        this.server.publish(1, (IProgressMonitor)new NullProgressMonitor());
        IPath earPath = this.getLocalPublishMethodDeployRoot();
        ArrayList<IPath> toFind = new ArrayList<IPath>();
        toFind.add(earPath.append(String.valueOf(this.MY_NESTED_PROJECT_NAME) + ".war").append(this.jarFolder).append(this.jarName));
        this.verifyList(earPath, toFind, true);
    }

    @Override
    protected IDataModelProvider getDefaultAddReferenceProvider() {
        return new AddReferenceDataModelProvider();
    }

    @Override
    protected int getExpectedFileCount() {
        return 3;
    }
}

