/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.parametized.server.publishing.defect;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.jboss.tools.as.test.core.ASMatrixTests;
import org.jboss.tools.as.test.core.internal.utils.IOUtil;
import org.jboss.tools.as.test.core.internal.utils.MatrixUtils;
import org.jboss.tools.as.test.core.internal.utils.MockModule;
import org.jboss.tools.as.test.core.internal.utils.MockModuleUtil;
import org.jboss.tools.as.test.core.internal.utils.ServerParameterUtils;
import org.jboss.tools.as.test.core.parametized.server.publishing.AbstractPublishingTest;
import org.jboss.tools.as.test.core.subsystems.impl.CustomPublishController;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class PublishRemovalMarkerDefectTest
extends AbstractPublishingTest {
    private IModule[] module;

    @Parameterized.Parameters
    public static Collection<Object[]> params() {
        String[] servers = new String[]{"org.jboss.ide.eclipse.as.71"};
        String[] zipOption = ServerParameterUtils.getServerZipOptions();
        String[] defaultDeployLoc = ServerParameterUtils.getDefaultDeployOptions();
        String[] perModOverrides = ServerParameterUtils.getPerModuleOverrideOptions();
        Object[][] allOptions = new Object[][]{servers, zipOption, defaultDeployLoc, perModOverrides};
        return MatrixUtils.toMatrix(allOptions);
    }

    public PublishRemovalMarkerDefectTest(String serverType, String zip, String deployLoc, String perMod) {
        super(serverType, zip, deployLoc, perMod);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp(false);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    protected void createProjects() throws Exception {
        this.module = this.createSimpleMockWebModule();
        this.addModuleToServer(this.module[0]);
    }

    @Test
    public void testPublish() throws Exception {
        CustomPublishController controller = new CustomPublishController();
        controller.initialize((IServerAttributes)this.server, null, null);
        controller.publishStart((IProgressMonitor)new NullProgressMonitor());
        controller.publishServer(1, (IProgressMonitor)new NullProgressMonitor());
        int result = controller.publishModule(1, 1, this.module, (IProgressMonitor)new NullProgressMonitor());
        controller.publishFinish((IProgressMonitor)new NullProgressMonitor());
        PublishRemovalMarkerDefectTest.assertEquals((int)result, (int)1);
        IPath depPath = controller.getDeployPathController().getDeployDirectory(this.module);
        IPath depFolder = depPath.removeLastSegments(1);
        String name = depPath.lastSegment();
        String nameDoDeployMarker = String.valueOf(name) + ".dodeploy";
        String nameDeployedMarker = String.valueOf(name) + ".deployed";
        String s = depPath.toOSString();
        PublishRemovalMarkerDefectTest.assertTrue((boolean)new Path(s).toFile().exists());
        PublishRemovalMarkerDefectTest.assertEquals((boolean)this.testIsZip(), (boolean)new Path(s).toFile().isFile());
        this.verifyListRelativePath((IPath)new Path(s), Arrays.asList(this.getLeafPaths()), true);
        PublishRemovalMarkerDefectTest.assertTrue((boolean)depFolder.append(nameDoDeployMarker).toFile().exists());
        depFolder.append(nameDoDeployMarker).toFile().delete();
        depFolder.append(nameDeployedMarker).toFile().createNewFile();
        controller.publishStart((IProgressMonitor)new NullProgressMonitor());
        controller.publishServer(1, (IProgressMonitor)new NullProgressMonitor());
        result = controller.publishModule(1, 3, this.module, null);
        controller.publishFinish((IProgressMonitor)new NullProgressMonitor());
        PublishRemovalMarkerDefectTest.assertFalse((boolean)depFolder.append(nameDeployedMarker).toFile().exists());
    }

    private boolean testIsZip() {
        return this.param_zip.equals("zipped");
    }

    private IPath setUnderlyingVersion(int v) throws Exception {
        IPath underlying = ASMatrixTests.getDefault().getStateLocation().append("underlying.txt");
        underlying.toFile().getParentFile().mkdirs();
        IOUtil.setContents(underlying.toFile(), "version" + v);
        return underlying;
    }

    private IPath[] getLeafPaths() {
        IPath[] leafs = new IPath[]{new Path("w"), new Path("x"), new Path("y"), new Path("z"), new Path("a/a1"), new Path("a/a2"), new Path("a/q1"), new Path("a/q2"), new Path("b/b1"), new Path("b/b2"), new Path("b/b3"), new Path("b/b4"), new Path("c/y1"), new Path("c/y2.png"), new Path("c/y3.jpg"), new Path("c/y4.pdf"), new Path("d/F/f1.jar"), new Path("d/F/f2.txt"), new Path("d/F/f3.txt"), new Path("d/F/f4.txt")};
        return leafs;
    }

    private MockModule[] createSimpleMockWebModule() throws Exception {
        IPath underlying = this.setUnderlyingVersion(1);
        MockModule m = MockModuleUtil.createMockWebModule();
        IPath[] leafs = this.getLeafPaths();
        IModuleResource[] all = MockModuleUtil.createMockResources(leafs, new IPath[0], underlying.toFile());
        m.setMembers(all);
        m.setExists(true);
        return new MockModule[]{m};
    }

    protected void verifyListRelativePath(IPath root, List<IPath> list, boolean exists) {
        ArrayList<IPath> list2 = new ArrayList<IPath>();
        Iterator<IPath> i = list.iterator();
        while (i.hasNext()) {
            list2.add(root.append(i.next()));
        }
        super.verifyList(root, list2, exists);
    }
}

