/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.parametized.server.publishing.defect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerUtil;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ServerProfileModel;
import org.jboss.tools.as.test.core.internal.utils.ResourceUtils;
import org.jboss.tools.as.test.core.internal.utils.classpath.WorkspaceTestUtil;
import org.jboss.tools.as.test.core.internal.utils.wtp.CreateProjectOperationsUtility;
import org.jboss.tools.as.test.core.internal.utils.wtp.JavaEEFacetConstants;
import org.jboss.tools.as.test.core.internal.utils.wtp.OperationTestCase;
import org.jboss.tools.as.test.core.parametized.server.publishing.AbstractPublishingTest;
import org.jboss.tools.test.util.JobUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RepublishDefectTest
extends AbstractPublishingTest {
    public static int count = 1;
    private int myCount = count++;
    private static boolean preTestAutoBuild;

    @Parameterized.Parameters
    public static Collection<Object[]> params() {
        return RepublishDefectTest.minimalData();
    }

    public RepublishDefectTest(String serverType, String zip, String deployLoc, String perMod) {
        super(serverType, zip, deployLoc, perMod);
    }

    @BeforeClass
    public static void beforeClassSetup() {
        preTestAutoBuild = WorkspaceTestUtil.isAutoBuildEnabled();
    }

    @AfterClass
    public static void afterClassTeardown() {
        WorkspaceTestUtil.setAutoBuildEnabled(preTestAutoBuild);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        WorkspaceTestUtil.setAutoBuildEnabled(false);
        JobUtils.waitForIdle();
        ResourcesPlugin.getWorkspace().build(10, (IProgressMonitor)new NullProgressMonitor());
        JobUtils.waitForIdle();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        WorkspaceTestUtil.setAutoBuildEnabled(true);
        super.tearDown();
    }

    @Override
    protected void createProjects() throws Exception {
        IDataModel dm = CreateProjectOperationsUtility.getEARDataModel(this.ap("ear"), "thatContent", null, null, JavaEEFacetConstants.EAR_5, true);
        OperationTestCase.runAndVerify(dm);
        IDataModel dyn1Model = CreateProjectOperationsUtility.getWebDataModel(this.ap("d1v"), this.ap("ear"), null, null, null, JavaEEFacetConstants.WEB_23, true);
        OperationTestCase.runAndVerify(dyn1Model);
        IDataModel dyn2Model = CreateProjectOperationsUtility.getWebDataModel(this.ap("d2v"), this.ap("ear"), null, null, null, JavaEEFacetConstants.WEB_23, true);
        OperationTestCase.runAndVerify(dyn2Model);
        this.addModuleToServer(ServerUtil.getModule((IProject)this.findProject(this.ap("ear"))));
    }

    private String ap(String original) {
        return String.valueOf(original) + this.myCount;
    }

    @Override
    protected void completeSetUp() {
        ServerProfileModel.setProfile((IServerWorkingCopy)this.wc, (String)"local");
    }

    private void addOrRemoveModuleWithPublish(IModule[] module, boolean add) throws CoreException {
        IServerWorkingCopy wc = this.server.createWorkingCopy();
        if (add) {
            wc.modifyModules(module, new IModule[0], (IProgressMonitor)new NullProgressMonitor());
        } else {
            wc.modifyModules(new IModule[0], module, (IProgressMonitor)new NullProgressMonitor());
        }
        this.server = wc.save(true, (IProgressMonitor)new NullProgressMonitor());
        JobUtils.waitForIdle();
        this.server.publish(1, (IProgressMonitor)new NullProgressMonitor());
        JobUtils.waitForIdle();
    }

    @Test
    public void testJBIDE6184_Odd_Republish_Error() throws Exception {
        IModule[] ear = this.getModule(this.findProject(this.ap("ear")));
        this.addOrRemoveModuleWithPublish(ear, true);
        IPath earPath = this.getLocalPublishMethodDeployRoot();
        System.out.println(earPath);
        this.JBIDE6184EarHasDynProjs(earPath, true);
        this.addOrRemoveModuleWithPublish(ear, false);
        RepublishDefectTest.assertFalse((boolean)earPath.toFile().exists());
        ResourceUtils.deleteProject(this.ap("d1v"));
        ResourcesPlugin.getWorkspace().build(10, (IProgressMonitor)new NullProgressMonitor());
        JobUtils.waitForIdle();
        this.addOrRemoveModuleWithPublish(ear, true);
        this.JBIDE6184EarHasDynProjs(earPath, false);
        IDataModel dyn1Model = CreateProjectOperationsUtility.getWebDataModel(this.ap("d1v"), this.ap("ear"), null, null, null, JavaEEFacetConstants.WEB_23, true);
        OperationTestCase.runAndVerify(dyn1Model);
        JobUtils.waitForIdle();
        ResourcesPlugin.getWorkspace().build(10, (IProgressMonitor)new NullProgressMonitor());
        JobUtils.waitForIdle();
        this.server.publish(1, (IProgressMonitor)new NullProgressMonitor());
        this.JBIDE6184EarHasDynProjs(earPath, true);
    }

    protected void JBIDE6184EarHasDynProjs(IPath earPath, boolean d1vPresent) {
        ArrayList<IPath> mustBePresent = new ArrayList<IPath>();
        ArrayList<IPath> mustBeMissing = new ArrayList<IPath>();
        mustBePresent.add(earPath);
        mustBePresent.add(earPath.append("META-INF"));
        mustBePresent.add(earPath.append("META-INF").append("application.xml"));
        ArrayList<IPath> tmp = d1vPresent ? mustBePresent : mustBeMissing;
        String d1WarName = String.valueOf(this.ap("d1v")) + ".war";
        tmp.add(earPath.append(d1WarName));
        tmp.add(earPath.append(d1WarName).append("WEB-INF"));
        tmp.add(earPath.append(d1WarName).append("META-INF"));
        tmp.add(earPath.append(d1WarName).append("META-INF").append("MANIFEST.MF"));
        tmp.add(earPath.append(d1WarName).append("WEB-INF").append("web.xml"));
        String d2WarName = String.valueOf(this.ap("d2v")) + ".war";
        mustBePresent.add(earPath.append(d2WarName));
        mustBePresent.add(earPath.append(d2WarName).append("WEB-INF"));
        mustBePresent.add(earPath.append(d2WarName).append("META-INF"));
        mustBePresent.add(earPath.append(d2WarName).append("META-INF").append("MANIFEST.MF"));
        mustBePresent.add(earPath.append(d2WarName).append("WEB-INF").append("web.xml"));
        this.verifyList(earPath, mustBePresent, true);
        this.verifyList(earPath, mustBeMissing, false);
    }

    protected void verifyListRelativePath(IPath root, List<IPath> list, boolean exists) {
        ArrayList<IPath> list2 = new ArrayList<IPath>();
        Iterator<IPath> i = list.iterator();
        while (i.hasNext()) {
            list2.add(root.append(i.next()));
        }
        super.verifyList(root, list2, exists);
    }
}

