/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.polling;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.internal.Server;
import org.jboss.ide.eclipse.as.core.ExtensionManager;
import org.jboss.ide.eclipse.as.core.server.IPollResultListener;
import org.jboss.ide.eclipse.as.core.server.IProvideCredentials;
import org.jboss.ide.eclipse.as.core.server.IServerProvider;
import org.jboss.ide.eclipse.as.core.server.IServerStatePoller;
import org.jboss.ide.eclipse.as.core.server.internal.PollThread;
import org.jboss.ide.eclipse.as.core.util.PollThreadUtils;
import org.jboss.tools.as.test.core.ASMatrixTests;
import org.jboss.tools.as.test.core.internal.utils.ServerCreationTestUtils;
import org.jboss.tools.as.test.core.polling.AbstractTestInternalPoller;
import org.jboss.tools.as.test.core.polling.PollerFailureHandler;
import org.jboss.tools.as.test.core.polling.TestInternalPoller;
import org.jboss.tools.test.util.JobUtils;
import org.junit.After;
import org.junit.Test;

public class PollThreadTest
extends TestCase {
    @After
    public void cleanup() throws Exception {
        ASMatrixTests.cleanup();
    }

    @Test
    public void testPollersFound() {
        PollThreadTest.assertNotNull((Object)PollThreadUtils.getPoller((String)"org.jboss.ide.eclipse.as.core.runtime.server.WebPoller"));
        PollThreadTest.assertNotNull((Object)PollThreadUtils.getPoller((String)"org.jboss.ide.eclipse.as.core.runtime.server.processTerminatedPoller"));
        PollThreadTest.assertNotNull((Object)PollThreadUtils.getPoller((String)"org.jboss.ide.eclipse.as.core.runtime.server.JMXPoller"));
        PollThreadTest.assertNotNull((Object)PollThreadUtils.getPoller((String)"org.jboss.ide.eclipse.as.core.server.JBoss7ManagerServicePoller"));
    }

    private IServer createServer(String addendum) throws CoreException {
        return ServerCreationTestUtils.createServerWithRuntime("org.jboss.ide.eclipse.as.32", "org.jboss.ide.eclipse.as.32" + addendum);
    }

    @Test
    public void testPollerStringAttributes() throws CoreException {
        IServer s = this.createServer("a");
        IServerWorkingCopy wc = s.createWorkingCopy();
        wc.setAttribute("org.jboss.ide.eclipse.as.core.server.attributes.startupPollerKey", "startupPoller");
        wc.setAttribute("org.jboss.ide.eclipse.as.core.server.attributes.shutdownPollerKey", "shutdownPoller");
        s = wc.save(true, null);
        JobUtils.waitForIdle();
        String startupPoller = PollThreadUtils.getPollerId((boolean)true, (IServer)s);
        String shutdownPoller = PollThreadUtils.getPollerId((boolean)false, (IServer)s);
        PollThreadTest.assertEquals((String)"startupPoller", (String)startupPoller);
        PollThreadTest.assertEquals((String)"shutdownPoller", (String)shutdownPoller);
    }

    @Test
    public void testPollerResolution() throws CoreException {
        IServer s = this.createServer("b");
        IServerWorkingCopy wc = s.createWorkingCopy();
        wc.setAttribute("org.jboss.ide.eclipse.as.core.server.attributes.startupPollerKey", "org.jboss.tools.as.test.core.poller.TestInternalPoller");
        wc.setAttribute("org.jboss.ide.eclipse.as.core.server.attributes.shutdownPollerKey", "org.jboss.tools.as.test.core.poller.TestInternalPoller");
        s = wc.save(true, null);
        JobUtils.waitForIdle();
        String startupPoller = PollThreadUtils.getPollerId((boolean)true, (IServer)s);
        String shutdownPoller = PollThreadUtils.getPollerId((boolean)false, (IServer)s);
        PollThreadTest.assertEquals((String)"org.jboss.tools.as.test.core.poller.TestInternalPoller", (String)startupPoller);
        PollThreadTest.assertEquals((String)"org.jboss.tools.as.test.core.poller.TestInternalPoller", (String)shutdownPoller);
        IServerStatePoller testPoller = PollThreadUtils.getPoller((String)"org.jboss.tools.as.test.core.poller.TestInternalPoller");
        PollThreadTest.assertNotNull((Object)testPoller);
        PollThreadTest.assertEquals(testPoller.getClass(), TestInternalPoller.class);
    }

    private List<String> asList(String[] a) {
        return Arrays.asList(a);
    }

    @Test
    public void testInternalRequiresMoreInfoHandlerResolved() throws Exception {
        IServer s = this.createServer("c");
        ServerProvider pro = new ServerProvider(s);
        String[] atts = new String[]{"a", "b"};
        IProvideCredentials provider = ExtensionManager.getDefault().getFirstCredentialProvider((IServerProvider)pro, this.asList(atts));
        PollThreadTest.assertNotNull((Object)provider);
        PollThreadTest.assertFalse((boolean)(provider instanceof PollerFailureHandler));
        atts = new String[]{"a", "b", "c"};
        provider = ExtensionManager.getDefault().getFirstCredentialProvider((IServerProvider)pro, this.asList(atts));
        PollThreadTest.assertNotNull((Object)provider);
        PollThreadTest.assertTrue((boolean)(provider instanceof PollerFailureHandler));
        atts = new String[]{"a", "b", "c", "d"};
        provider = ExtensionManager.getDefault().getFirstCredentialProvider((IServerProvider)pro, this.asList(atts));
        PollThreadTest.assertNull((Object)provider);
    }

    @Test
    public void testSynchronousResults() throws Exception {
        IServer s = this.createServer("d");
        AbstractTestInternalPoller currentlyUp = new AbstractTestInternalPoller(){

            @Override
            public IStatus getCurrentStateSynchronous(IServer server) {
                return Status.OK_STATUS;
            }
        };
        IStatus retStat = PollThreadUtils.isServerStarted((IServer)s, (IServerStatePoller)currentlyUp);
        PollThreadTest.assertTrue((boolean)retStat.isOK());
        AbstractTestInternalPoller currentlyDown = new AbstractTestInternalPoller(){

            @Override
            public IStatus getCurrentStateSynchronous(IServer server) {
                return new Status(4, "org.jboss.tools.as.test.core", "failure");
            }
        };
        retStat = PollThreadUtils.isServerStarted((IServer)s, (IServerStatePoller)currentlyDown);
        PollThreadTest.assertFalse((boolean)retStat.isOK());
    }

    @Test
    public void testCancelReceivedDuringStartupPoll() throws Exception {
        IServer s = this.createServer("d");
        ((Server)s).setServerState(1);
        final int[] canceledHow = new int[]{-1};
        final boolean[] cleanedUp = new boolean[1];
        AbstractTestInternalPoller doNothingForever = new AbstractTestInternalPoller(){

            @Override
            public void cancel(int type) {
                canceledHow[0] = type;
            }

            @Override
            public void cleanup() {
                cleanedUp[0] = true;
            }
        };
        PollerListener listener = new PollerListener();
        PollThread pt = new PollThread(true, (IServerStatePoller)doNothingForever, (IPollResultListener)listener, s);
        pt.start();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {}
        PollThreadTest.assertFalse((boolean)listener.anythingAsserted);
        PollThreadTest.assertNull((Object)listener.assertedWhat);
        PollThreadUtils.cancelPolling((String)"Some Message", (PollThread)pt);
        PollThreadTest.assertEquals((int)canceledHow[0], (int)0);
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {}
        PollThreadTest.assertFalse((boolean)listener.anythingAsserted);
        PollThreadTest.assertEquals(null, (Object)listener.assertedWhat);
        PollThreadTest.assertTrue((boolean)cleanedUp[0]);
    }

    @Test
    public void testCancelReceivedDuringShutdownPoll() throws Exception {
        IServer s = this.createServer("e");
        ((Server)s).setServerState(3);
        final int[] canceledHow = new int[]{-1};
        final boolean[] cleanedUp = new boolean[1];
        AbstractTestInternalPoller doNothingForever = new AbstractTestInternalPoller(){

            @Override
            public boolean getState() throws IServerStatePoller.PollingException, IServerStatePoller.RequiresInfoException {
                return true;
            }

            @Override
            public void cancel(int type) {
                canceledHow[0] = type;
            }

            @Override
            public void cleanup() {
                cleanedUp[0] = true;
            }
        };
        PollerListener listener = new PollerListener();
        PollThread pt = new PollThread(false, (IServerStatePoller)doNothingForever, (IPollResultListener)listener, s);
        pt.start();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {}
        PollThreadTest.assertFalse((boolean)listener.anythingAsserted);
        PollThreadTest.assertNull((Object)listener.assertedWhat);
        PollThreadUtils.cancelPolling((String)"Some Message", (PollThread)pt);
        PollThreadTest.assertEquals((int)canceledHow[0], (int)0);
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {}
        PollThreadTest.assertFalse((boolean)listener.anythingAsserted);
        PollThreadTest.assertEquals(null, (Object)listener.assertedWhat);
        PollThreadTest.assertTrue((boolean)cleanedUp[0]);
    }

    @Test
    public void testPollerFailureCancelsThread() throws Exception {
        IServer s = this.createServer("g");
        ((Server)s).setServerState(1);
        final int[] canceledHow = new int[]{-1};
        final boolean[] cleanedUp = new boolean[1];
        AbstractTestInternalPoller failPoller = new AbstractTestInternalPoller(){

            @Override
            public boolean isComplete() throws IServerStatePoller.PollingException, IServerStatePoller.RequiresInfoException {
                throw new IServerStatePoller.PollingException("Automatic failure");
            }

            @Override
            public void cancel(int type) {
                canceledHow[0] = type;
            }

            @Override
            public void cleanup() {
                cleanedUp[0] = true;
            }
        };
        PollerListener listener = new PollerListener();
        PollThread pt = new PollThread(true, (IServerStatePoller)failPoller, (IPollResultListener)listener, s);
        pt.start();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {}
        PollThreadTest.assertTrue((boolean)listener.anythingAsserted);
        PollThreadTest.assertTrue((boolean)listener.assertedWhat[0]);
        PollThreadTest.assertFalse((boolean)listener.assertedWhat[1]);
        PollThreadTest.assertTrue((boolean)cleanedUp[0]);
        PollThreadTest.assertEquals((int)canceledHow[0], (int)0);
        PollThreadTest.assertFalse((boolean)pt.isAlive());
    }

    private static class PollerListener
    implements IPollResultListener {
        private boolean anythingAsserted = false;
        private boolean[] assertedWhat = null;

        private PollerListener() {
        }

        public void stateAsserted(boolean expectedState, boolean currentState) {
            this.anythingAsserted = true;
            this.assertedWhat = new boolean[]{expectedState, currentState};
        }

        public void stateNotAsserted(boolean expectedState, boolean currentState) {
            this.anythingAsserted = true;
            this.assertedWhat = new boolean[]{expectedState, currentState};
        }
    }

    private static class ServerProvider
    implements IServerProvider {
        private IServer server;

        public ServerProvider(IServer server) {
            this.server = server;
        }

        public IServer getServer() {
            return this.server;
        }
    }
}

