/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.runtime;

import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.RuntimeWorkingCopy;
import org.jboss.ide.eclipse.as.core.server.internal.v7.LocalJBoss7ServerRuntime;
import org.jboss.tools.as.test.core.internal.utils.ServerCreationTestUtils;
import org.junit.After;
import org.junit.Test;

public class AS7RuntimeTest
extends TestCase {
    private String serverType = "org.jboss.ide.eclipse.as.71";

    @After
    public void tearDown() throws Exception {
        ServerCreationTestUtils.deleteAllServersAndRuntimes();
    }

    @Test
    public void testBaseDir() throws CoreException {
        IServer server = ServerCreationTestUtils.createMockServerWithRuntime(this.serverType, String.valueOf(((Object)((Object)this)).getClass().getName()) + this.serverType);
        IRuntime rt = server.getRuntime();
        LocalJBoss7ServerRuntime jb7rt = (LocalJBoss7ServerRuntime)rt.loadAdapter(LocalJBoss7ServerRuntime.class, null);
        IPath loc = rt.getLocation();
        String baseDir = jb7rt.getBaseDirectory();
        String assumedBaseDir = loc.append("standalone").toFile().getAbsolutePath();
        AS7RuntimeTest.assertEquals((String)baseDir, (String)assumedBaseDir);
        IRuntimeWorkingCopy wc = rt.createWorkingCopy();
        ((RuntimeWorkingCopy)wc).setAttribute("org.jboss.ide.eclipse.as.core.server.internal.v7.BASE_DIRECTORY", "standalone2");
        rt = wc.save(false, null);
        baseDir = jb7rt.getBaseDirectory();
        assumedBaseDir = loc.append("standalone2").toFile().getAbsolutePath();
        AS7RuntimeTest.assertEquals((String)baseDir, (String)assumedBaseDir);
        wc = rt.createWorkingCopy();
        ((RuntimeWorkingCopy)wc).setAttribute("org.jboss.ide.eclipse.as.core.server.internal.v7.BASE_DIRECTORY", "/home/user/tmp/standalone");
        rt = wc.save(false, null);
        baseDir = jb7rt.getBaseDirectory();
        assumedBaseDir = new Path("/home/user/tmp/standalone").toFile().getAbsolutePath();
        AS7RuntimeTest.assertEquals((String)baseDir, (String)assumedBaseDir);
    }
}

