/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.subsystems;

import java.util.ArrayList;
import java.util.Collection;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.jboss.ide.eclipse.as.core.util.JBossServerBehaviorUtils;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ISubsystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ServerProfileModel;
import org.jboss.tools.as.test.core.internal.utils.MatrixUtils;
import org.jboss.tools.as.test.core.internal.utils.ServerCreationTestUtils;
import org.jboss.tools.as.test.core.internal.utils.ServerParameterUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AllSubsystemResolutionTest
extends TestCase {
    private String serverType;
    private String mode;
    private String system;
    private IServer server;

    private static String[] getSubsystemsForAllServers() {
        String[] subsystems = new String[]{"launch", "shutdown", "modules", "publish", "filesystem", "module.restart.behavior", "serverDetails", "deploymentOptions", "moduleDeployPath", "browseBehavior", "exploreBehavior", "deploymentPage"};
        return subsystems;
    }

    private static String[] getSubsystemsForJBossServers() {
        String[] subsystems = new String[]{"launchTabProvider", "server.ports"};
        return subsystems;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        String[] allServers = ServerParameterUtils.getAllJBossServerTypeParameters();
        String[] jbossServers = ServerParameterUtils.getJBossServerTypeParameters();
        String[] stringArray = new String[3];
        stringArray[0] = "local";
        stringArray[1] = "rse";
        String[] modes = stringArray;
        String[] subsystems = AllSubsystemResolutionTest.getSubsystemsForAllServers();
        ArrayList<Object[]> ret = MatrixUtils.toMatrix(new Object[][]{allServers, modes, subsystems});
        ret.addAll(MatrixUtils.toMatrix(new Object[][]{jbossServers, modes, AllSubsystemResolutionTest.getSubsystemsForJBossServers()}));
        String[] as7Servers = new String[]{"org.jboss.ide.eclipse.as.70", "org.jboss.ide.eclipse.as.71", "org.jboss.ide.eclipse.as.wildfly.80", "org.jboss.ide.eclipse.as.eap.60", "org.jboss.ide.eclipse.as.eap.61"};
        String[] stringArray2 = new String[5];
        stringArray2[0] = "local";
        stringArray2[1] = "rse";
        stringArray2[3] = "local.mgmt";
        stringArray2[4] = "rse.mgmt";
        String[] as7Modes = stringArray2;
        ret.addAll(MatrixUtils.toMatrix(new Object[][]{as7Servers, as7Modes, AllSubsystemResolutionTest.getSubsystemsForJBossServers()}));
        return ret;
    }

    public AllSubsystemResolutionTest(String serverType, String mode, String system) {
        this.serverType = serverType;
        this.mode = mode;
        this.system = system;
    }

    @Before
    public void setUp() throws Exception {
        this.server = ServerCreationTestUtils.createMockServerWithRuntime(this.serverType, String.valueOf(((Object)((Object)this)).getClass().getName()) + this.serverType);
        IServerWorkingCopy wc = this.server.createWorkingCopy();
        ServerProfileModel.setProfile((IServerWorkingCopy)wc, (String)this.mode);
        this.server = wc.save(false, (IProgressMonitor)new NullProgressMonitor());
    }

    @After
    public void tearDown() throws Exception {
        ServerCreationTestUtils.deleteAllServersAndRuntimes();
    }

    @Test
    public void testResolution() throws Exception {
        IControllableServerBehavior beh = JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)this.server);
        AllSubsystemResolutionTest.assertNotNull((Object)beh);
        try {
            ISubsystemController controller = beh.getController(this.system);
            AllSubsystemResolutionTest.assertNotNull((Object)controller);
        }
        catch (CoreException ce) {
            String msg = String.valueOf(this.serverType) + " : " + this.mode + " : " + this.system + "  ::  " + ce.getMessage();
            System.out.println(msg);
            AllSubsystemResolutionTest.fail((String)msg);
        }
    }
}

