/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.subsystems;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.jboss.ide.eclipse.as.rse.core.subsystems.RSEFilesystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ServerProfileModel;
import org.jboss.tools.as.test.core.ASMatrixTests;
import org.jboss.tools.as.test.core.internal.utils.IOUtil;
import org.jboss.tools.as.test.core.internal.utils.ServerCreationTestUtils;
import org.jboss.tools.as.test.core.internal.utils.ServerParameterUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RSEFilesystemSubsystemTest
extends TestCase {
    private String serverType;
    private IServer server;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return ServerParameterUtils.asCollection(new Object[]{"org.jboss.ide.eclipse.as.systemCopyServer"});
    }

    public RSEFilesystemSubsystemTest(String serverType) {
        this.serverType = serverType;
    }

    @Before
    public void setUp() throws Exception {
        try {
            this.server = ServerCreationTestUtils.createServerWithRuntime(this.serverType, String.valueOf(((Object)((Object)this)).getClass().getName()) + this.serverType);
            IServerWorkingCopy wc = this.server.createWorkingCopy();
            ServerProfileModel.setProfile((IServerWorkingCopy)wc, (String)"rse");
            this.server = wc.save(true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException ce) {
            ce.printStackTrace();
            throw ce;
        }
    }

    @After
    public void tearDown() throws Exception {
        ASMatrixTests.cleanup();
    }

    @Test
    public void testCopyFile() throws Exception {
        IPath tmpfile = this.getStateLocationPath("tmpfile1.txt");
        IPath destination = this.getStateLocationPath("dest/copiedFile.txt");
        IOUtil.setContents(tmpfile.toFile(), "hello");
        TestRSEFilesystemController controller = new TestRSEFilesystemController();
        controller.initialize((IServerAttributes)this.server, null, this.createEnvironmentTempFolder1());
        controller.copyFile(tmpfile.toFile(), destination, (IProgressMonitor)new NullProgressMonitor());
        String copiedContents = IOUtil.getContents(destination.toFile());
        RSEFilesystemSubsystemTest.assertEquals((String)copiedContents, (String)"hello");
    }

    @Test
    public void testDeleteResource() throws Exception {
        IPath tmpfile = this.getStateLocationPath("tmpfile2.txt");
        IOUtil.setContents(tmpfile.toFile(), "hello");
        TestRSEFilesystemController controller = new TestRSEFilesystemController();
        controller.initialize((IServerAttributes)this.server, null, this.createEnvironmentTempFolder1());
        controller.deleteResource(tmpfile, (IProgressMonitor)new NullProgressMonitor());
        RSEFilesystemSubsystemTest.assertFalse((boolean)tmpfile.toFile().exists());
    }

    @Test
    public void testDeleteEmptyFolder() throws Exception {
        IPath tmpFolder = this.getStateLocationPath("tmpFolder");
        tmpFolder.toFile().mkdirs();
        TestRSEFilesystemController controller = new TestRSEFilesystemController();
        controller.initialize((IServerAttributes)this.server, null, this.createEnvironmentTempFolder1());
        controller.deleteResource(tmpFolder, (IProgressMonitor)new NullProgressMonitor());
        RSEFilesystemSubsystemTest.assertFalse((boolean)tmpFolder.toFile().exists());
    }

    @Test
    public void testDeleteFolderWithContents() throws Exception {
        IPath tmpFolder = this.getStateLocationPath("tmpFolder");
        tmpFolder.toFile().mkdirs();
        IPath file1 = tmpFolder.append("Blah.txt");
        IOUtil.setContents(file1.toFile(), "hello");
        TestRSEFilesystemController controller = new TestRSEFilesystemController();
        controller.initialize((IServerAttributes)this.server, null, this.createEnvironmentTempFolder1());
        controller.deleteResource(tmpFolder, (IProgressMonitor)new NullProgressMonitor());
        RSEFilesystemSubsystemTest.assertFalse((boolean)tmpFolder.toFile().exists());
        RSEFilesystemSubsystemTest.assertFalse((boolean)file1.toFile().exists());
    }

    @Test
    public void testDeleteFolderWithInnerFolderWithContents() throws Exception {
        IPath tmpFolder = this.getStateLocationPath("tmpFolder");
        tmpFolder.toFile().mkdirs();
        IPath innerFolder = tmpFolder.append("inner");
        innerFolder.toFile().mkdirs();
        IPath file1 = innerFolder.append("Blah.txt");
        IOUtil.setContents(file1.toFile(), "hello");
        TestRSEFilesystemController controller = new TestRSEFilesystemController();
        controller.initialize((IServerAttributes)this.server, null, this.createEnvironmentTempFolder1());
        controller.deleteResource(tmpFolder, (IProgressMonitor)new NullProgressMonitor());
        RSEFilesystemSubsystemTest.assertFalse((boolean)tmpFolder.toFile().exists());
        RSEFilesystemSubsystemTest.assertFalse((boolean)innerFolder.toFile().exists());
        RSEFilesystemSubsystemTest.assertFalse((boolean)file1.toFile().exists());
    }

    @Test
    public void testIsFile() throws Exception {
        IPath tmpfile = this.getStateLocationPath("tmpfile3.txt");
        TestRSEFilesystemController controller = new TestRSEFilesystemController();
        controller.initialize((IServerAttributes)this.server, null, this.createEnvironmentTempFolder1());
        RSEFilesystemSubsystemTest.assertFalse((boolean)controller.isFile(tmpfile, (IProgressMonitor)new NullProgressMonitor()));
        IOUtil.setContents(tmpfile.toFile(), "hello");
        RSEFilesystemSubsystemTest.assertTrue((boolean)controller.isFile(tmpfile, (IProgressMonitor)new NullProgressMonitor()));
    }

    @Test
    public void testMakeDirectoryIfRequired() throws Exception {
        TestRSEFilesystemController controller = new TestRSEFilesystemController();
        controller.initialize((IServerAttributes)this.server, null, this.createEnvironmentTempFolder1());
        IPath tmpfile = this.getStateLocationPath("someFolder");
        RSEFilesystemSubsystemTest.assertFalse((boolean)tmpfile.toFile().exists());
        controller.makeDirectoryIfRequired(tmpfile, (IProgressMonitor)new NullProgressMonitor());
        RSEFilesystemSubsystemTest.assertTrue((boolean)tmpfile.toFile().exists());
    }

    @Test
    public void testMakeInnerDirectoryIfRequired() throws Exception {
        TestRSEFilesystemController controller = new TestRSEFilesystemController();
        controller.initialize((IServerAttributes)this.server, null, this.createEnvironmentTempFolder1());
        IPath tmpFolder = this.getStateLocationPath("someFolder");
        IPath innerFolder = tmpFolder.append("inner");
        RSEFilesystemSubsystemTest.assertFalse((boolean)tmpFolder.toFile().exists());
        RSEFilesystemSubsystemTest.assertFalse((boolean)innerFolder.toFile().exists());
        controller.makeDirectoryIfRequired(innerFolder, (IProgressMonitor)new NullProgressMonitor());
        RSEFilesystemSubsystemTest.assertTrue((boolean)tmpFolder.toFile().exists());
        RSEFilesystemSubsystemTest.assertTrue((boolean)innerFolder.toFile().exists());
    }

    @Test
    public void testMakeDirectoryIfRequiredDeep() throws Exception {
        TestRSEFilesystemController controller = new TestRSEFilesystemController();
        controller.initialize((IServerAttributes)this.server, null, this.createEnvironmentTempFolder1());
        IPath tmpfile = this.getStateLocationPath("someFolder/inner/three");
        RSEFilesystemSubsystemTest.assertFalse((boolean)tmpfile.toFile().exists());
        controller.makeDirectoryIfRequired(tmpfile, (IProgressMonitor)new NullProgressMonitor());
        RSEFilesystemSubsystemTest.assertTrue((boolean)tmpfile.toFile().exists());
    }

    @Test
    public void testTouchResource() throws Exception {
        IPath tmpfile = this.getStateLocationPath("tmpfile5.txt");
        TestRSEFilesystemController controller = new TestRSEFilesystemController();
        controller.initialize((IServerAttributes)this.server, null, this.createEnvironmentTempFolder1());
        RSEFilesystemSubsystemTest.assertFalse((boolean)tmpfile.toFile().exists());
        controller.touchResource(tmpfile, (IProgressMonitor)new NullProgressMonitor());
        RSEFilesystemSubsystemTest.assertTrue((boolean)tmpfile.toFile().exists());
    }

    private Map<String, Object> createEnvironmentTempFolder1() {
        HashMap<String, Object> env = new HashMap<String, Object>();
        IPath loc = this.getStateLocationPath("tmpdir1");
        loc.toFile().mkdirs();
        env.put("ISubsystemController.TemporaryDeployFolder", loc);
        return env;
    }

    private IPath getStateLocationPath(String path) {
        return ASMatrixTests.getDefault().getStateLocation().append(path);
    }

    public class TestRSEFilesystemController
    extends RSEFilesystemController {
    }
}

