/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.subsystems;

import java.util.Collection;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.jboss.ide.eclipse.as.core.util.JBossServerBehaviorUtils;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ISubsystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ServerProfileModel;
import org.jboss.tools.as.core.server.controllable.subsystems.internal.XPathsPortsController;
import org.jboss.tools.as.test.core.internal.utils.MatrixUtils;
import org.jboss.tools.as.test.core.internal.utils.ServerCreationTestUtils;
import org.jboss.tools.as.test.core.internal.utils.ServerParameterUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class XPathPortDiscoveryResolutionTest
extends TestCase {
    private String serverType;
    private String mode;
    private IServer server;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        String[] servers = ServerParameterUtils.getJBossServerTypeParameters();
        String[] stringArray = new String[3];
        stringArray[0] = "local";
        stringArray[1] = "rse";
        String[] modes = stringArray;
        return MatrixUtils.toMatrix(new Object[][]{servers, modes});
    }

    public XPathPortDiscoveryResolutionTest(String serverType, String mode) {
        this.serverType = serverType;
        this.mode = mode;
    }

    @Before
    public void setUp() throws Exception {
        this.server = ServerCreationTestUtils.createMockServerWithRuntime(this.serverType, String.valueOf(((Object)((Object)this)).getClass().getName()) + this.serverType);
        IServerWorkingCopy wc = this.server.createWorkingCopy();
        ServerProfileModel.setProfile((IServerWorkingCopy)wc, (String)this.mode);
        this.server = wc.save(false, (IProgressMonitor)new NullProgressMonitor());
    }

    @After
    public void tearDown() throws Exception {
        ServerCreationTestUtils.deleteAllServersAndRuntimes();
    }

    @Test
    public void testResolution() throws Exception {
        IControllableServerBehavior beh = JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)this.server);
        XPathPortDiscoveryResolutionTest.assertNotNull((Object)beh);
        ISubsystemController controller = beh.getController("server.ports");
        XPathPortDiscoveryResolutionTest.assertNotNull((Object)controller);
        XPathPortDiscoveryResolutionTest.assertTrue((boolean)(controller instanceof XPathsPortsController));
    }
}

