/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.wtp.runtimes.tomcat.tests;

import java.io.File;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.tools.runtime.core.RuntimeCoreActivator;
import org.jboss.tools.runtime.core.model.IRuntimeDetector;
import org.jboss.tools.runtime.core.util.RuntimeInitializerUtil;
import org.jboss.tools.wtp.runtimes.tomcat.tests.AbstractTomcatDetectionTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TomcatDetectionTest
extends AbstractTomcatDetectionTest {
    private IRuntimeDetector tomcatDetector;

    @Override
    @Before
    public void setUp() throws CoreException {
        super.setUp();
        this.tomcatDetector = RuntimeCoreActivator.getDefault().findRuntimeDetector("org.jboss.tools.wtp.runtimes.tomcat.TomcatRuntimeDetector");
        Assert.assertNotNull((String)"Tomcat detector org.jboss.tools.wtp.runtimes.tomcat.TomcatRuntimeDetector not found", (Object)this.tomcatDetector);
    }

    @Override
    @After
    public void tearDown() throws CoreException {
        super.tearDown();
        this.tomcatDetector = null;
    }

    @Test
    public void testTomcatDetection() {
        RuntimeInitializerUtil.initializeRuntimesFromFolder((File)new File(REQUIREMENTS_DIR), (IProgressMonitor)new NullProgressMonitor());
        Object[] runtimes = ServerCore.getRuntimes();
        HashMap<String, IRuntime> runtimeMap = new HashMap<String, IRuntime>();
        Object[] objectArray = runtimes;
        int n = runtimes.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntime iRuntime = objectArray[n2];
            runtimeMap.put(iRuntime.getName(), iRuntime);
            ++n2;
        }
        Assert.assertNotNull(runtimeMap.get(String.valueOf(TOMCAT_6) + " Runtime"));
        Assert.assertNotNull(runtimeMap.get(String.valueOf(TOMCAT_7) + " Runtime"));
        Assert.assertNotNull(runtimeMap.get(String.valueOf(TOMCAT_8) + " Runtime"));
        Assert.assertEquals((String)(String.valueOf(UNEXPECTED_RUNTIME_COUNT_ERROR) + ": " + this.toString(runtimes)), (long)3L, (long)runtimes.length);
        IServer[] servers = ServerCore.getServers();
        HashMap<String, IServer> serverMap = new HashMap<String, IServer>();
        IServer[] iServerArray = servers;
        int n3 = servers.length;
        int n4 = 0;
        while (n4 < n3) {
            IServer iServer = iServerArray[n4];
            serverMap.put(iServer.getName(), iServer);
            ++n4;
        }
        Assert.assertNotNull(serverMap.get(TOMCAT_6));
        Assert.assertNotNull(serverMap.get(TOMCAT_7));
        Assert.assertNotNull(serverMap.get(TOMCAT_8));
        Assert.assertEquals((long)3L, (long)servers.length);
    }
}

