/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.bean;

import java.io.File;
import org.jboss.ide.eclipse.as.core.server.bean.JBossServerType;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBeanLoader;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBeanType;

public class ServerBean {
    public static final String EMPTY = "";
    private String location = "";
    private ServerBeanType type = ServerBeanType.UNKNOWN;
    private String name = "";
    private String version = "";
    private String fullVersion = "";

    public ServerBean(String location, String name, ServerBeanType type, String fullVersion) {
        this.location = location;
        this.name = name;
        this.type = type;
        this.fullVersion = fullVersion;
        this.version = ServerBeanLoader.getMajorMinorVersion(fullVersion);
    }

    public ServerBean(ServerBean bean) {
        this(bean.getLocation(), bean.getName(), bean.getBeanType(), bean.getVersion());
    }

    public String getServerAdapterTypeId() {
        return this.getBeanType().getServerAdapterTypeId(this.version);
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    @Deprecated
    public JBossServerType getType() {
        return this.type instanceof JBossServerType ? (JBossServerType)this.type : JBossServerType.UNKNOWN;
    }

    public ServerBeanType getBeanType() {
        return this.type;
    }

    public String getUnderlyingTypeId() {
        return this.getBeanType().getUnderlyingTypeId(new File(this.location));
    }

    public void setType(ServerBeanType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getFullVersion() {
        return this.fullVersion;
    }

    public String toString() {
        return String.valueOf(this.name) + "," + this.type + "," + this.version + "," + this.location;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return this.toString().equals(obj.toString());
    }
}

