/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.bean;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.jboss.ide.eclipse.as.core.server.bean.AbstractCondition;
import org.jboss.ide.eclipse.as.core.server.bean.JBossServerType;

public class ServerBeanTypeAS7GateIn
extends JBossServerType {
    private static final String AS7_GATE_IN_SYSTEM_JAR_FOLDER = "/gatein/modules/org/gatein/main/";
    private static final String GATEIN_35_PROPERTY_FILE = "gatein/extensions/gatein-wsrp-integration.ear/extension-war.war/META-INF/maven/org.gatein.integration/extension-war/pom.properties";
    private static final String VERSION_PROP = "version";
    private static final String JBAS7_RELEASE_VERSION = "JBossAS-Release-Version";

    protected ServerBeanTypeAS7GateIn() {
        super("GateIn", "GateIn Application Server", ServerBeanTypeAS7GateIn.asPath("modules", "org", "jboss", "as", "server", "main"), new String[]{"3.3", "3.4", "3.5", "3.6"}, new AS7GateInServerTypeCondition());
    }

    public static class AS7GateInServerTypeCondition
    extends AbstractCondition {
        @Override
        public boolean isServerRoot(File location) {
            String mainFolder = JBossServerType.AS7.systemJarPath;
            boolean isAS7 = ServerBeanTypeAS7GateIn.scanFolderJarsForManifestProp(location, mainFolder, ServerBeanTypeAS7GateIn.JBAS7_RELEASE_VERSION, "7.");
            return isAS7 && this.getFullVersion(location, null) != null;
        }

        @Override
        public String getFullVersion(File location, File systemJarFile) {
            File f2;
            File f = new File(location, ServerBeanTypeAS7GateIn.AS7_GATE_IN_SYSTEM_JAR_FOLDER);
            if (f.exists()) {
                File[] children = f.listFiles();
                int i = 0;
                while (i < children.length) {
                    if (children[i].getName().endsWith(".jar")) {
                        String value = ServerBeanTypeAS7GateIn.getJarProperty(children[i], "Specification-Version");
                        return value;
                    }
                    ++i;
                }
            }
            if ((f2 = new File(location, ServerBeanTypeAS7GateIn.GATEIN_35_PROPERTY_FILE)).exists()) {
                try {
                    Properties p = new Properties();
                    p.load(new FileInputStream(f2));
                    return p.getProperty(ServerBeanTypeAS7GateIn.VERSION_PROP);
                }
                catch (IOException iOException) {}
            }
            return null;
        }

        @Override
        public String getServerTypeId(String version) {
            return "org.jboss.ide.eclipse.as.71";
        }
    }
}

