/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.util;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;

public class JavaUtils {
    public static boolean supportsServerMode(IVMInstall install) {
        String version;
        install.getInstallLocation();
        String string = version = install instanceof IVMInstall2 ? ((IVMInstall2)install).getJavaVersion() : null;
        if (version == null || Platform.getOS().equals("macosx")) {
            return true;
        }
        File jdkLibFolder = null;
        File jreLibFolder = null;
        if (Platform.getOS().equals("win32")) {
            jdkLibFolder = JavaUtils.getWindowsServerLibFolder(version, install, true);
            jreLibFolder = JavaUtils.getWindowsServerLibFolder(version, install, false);
        } else {
            jdkLibFolder = JavaUtils.getLinuxServerLibFolder(version, install, true);
            jreLibFolder = JavaUtils.getLinuxServerLibFolder(version, install, false);
        }
        if (jdkLibFolder != null && jdkLibFolder.exists() && jdkLibFolder.isDirectory() && jdkLibFolder.list().length > 0) {
            return true;
        }
        return jreLibFolder != null && jreLibFolder.exists() && jreLibFolder.isDirectory() && jreLibFolder.list().length > 0;
    }

    private static File getLinuxServerLibFolder(String version, IVMInstall install, boolean jdk) {
        File serverFolder = null;
        Path locPath = new Path(install.getInstallLocation().getAbsolutePath());
        if (jdk) {
            locPath = locPath.append("jre");
        }
        serverFolder = JavaUtils.findServerFolder(locPath.append("lib"));
        return serverFolder;
    }

    private static File findServerFolder(IPath parent) {
        File f = parent.toFile();
        if (!f.exists()) {
            return null;
        }
        File[] children = f.listFiles();
        int i = 0;
        while (i < children.length) {
            if (children[i].isDirectory()) {
                String[] second = children[i].list();
                int j = 0;
                while (j < second.length) {
                    if (second[j].toLowerCase().equals("server")) {
                        return new File(children[i], second[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    public static boolean isJDK(IVMInstall install) {
        Path locPath = new Path(install.getInstallLocation().getAbsolutePath());
        if (locPath.append("bin").append("javac").toFile().exists()) {
            return true;
        }
        if (locPath.append("bin").append("javac.exe").toFile().exists()) {
            return true;
        }
        return locPath.append("bin").toFile().exists() && locPath.append("jre").append("bin").toFile().exists();
    }

    private static File getWindowsServerLibFolder(String version, IVMInstall install, boolean jdk) {
        Path locPath = new Path(install.getInstallLocation().getAbsolutePath());
        if (jdk) {
            locPath = locPath.append("jre");
        }
        return locPath.append("bin").append("server").toFile();
    }
}

