/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.core.server.behavior;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ISubsystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.SubsystemModel;

public abstract class AbstractSubsystemController
implements ISubsystemController {
    static final String REQUIRED_PROPERTIES_ENV_KEY = ".RESERVED_requiredProperties";
    private SubsystemModel.Subsystem subsystem = null;
    private IServerAttributes server;
    private Map<String, Object> environment = null;

    protected IServer getServer() {
        if (this.server instanceof IServerWorkingCopy) {
            return ((IServerWorkingCopy)this.server).getOriginal();
        }
        if (this.server instanceof IServer) {
            return (IServer)this.server;
        }
        return null;
    }

    protected IControllableServerBehavior getControllableBehavior() {
        ServerBehaviourDelegate del;
        if (this.server != null && (del = (ServerBehaviourDelegate)this.server.loadAdapter(ServerBehaviourDelegate.class, null)) instanceof ControllableServerBehavior) {
            return (IControllableServerBehavior)del;
        }
        return null;
    }

    protected Map<String, Object> getEnvironment() {
        return this.environment;
    }

    protected ISubsystemController findDependencyFromBehavior(String system) throws CoreException {
        return this.getControllableBehavior() == null ? null : this.getControllableBehavior().getController(system);
    }

    protected ISubsystemController findDependency(String system) throws CoreException {
        return this.findDependency(system, this.server.getServerType().getId());
    }

    protected ISubsystemController findDependency(String system, String serverType) throws CoreException {
        return this.findDependency(system, serverType, this.environment);
    }

    protected ISubsystemController findDependency(String system, String serverType, Map<String, Object> environment) throws CoreException {
        String defaultSubsystem = null;
        if (this.subsystem != null) {
            Map<String, String> reqs = this.subsystem.getRequiredSubsystems();
            defaultSubsystem = reqs.get(system);
        }
        return SubsystemModel.getInstance().createSubsystemController(this.server, serverType, system, null, defaultSubsystem, environment);
    }

    @Override
    public void initialize(IServerAttributes server, SubsystemModel.Subsystem type, Map<String, Object> environment) {
        this.server = server;
        if (type != null) {
            this.subsystem = type;
        }
        if (this.environment == null || environment != null) {
            this.environment = environment == null ? new HashMap() : environment;
        }
    }

    @Override
    public String getSubsystemMappedId() {
        if (this.subsystem != null) {
            return this.subsystem.getMappedId();
        }
        return null;
    }

    @Override
    public String getSystemId() {
        if (this.subsystem != null) {
            return this.subsystem.getSystemId();
        }
        return null;
    }

    @Override
    public String getSubsystemName() {
        if (this.subsystem != null) {
            return this.subsystem.getSubsystemName();
        }
        return null;
    }

    @Override
    public IStatus validate() {
        if (this.subsystem != null) {
            if (this.subsystem.isValid()) {
                return Status.OK_STATUS;
            }
            return this.subsystem.getValidationError();
        }
        return Status.OK_STATUS;
    }

    protected IServerAttributes getServerOrWC() {
        return this.server;
    }

    protected IServerWorkingCopy getWorkingCopy() {
        if (this.server instanceof IServerWorkingCopy) {
            return (IServerWorkingCopy)this.server;
        }
        return null;
    }
}

