/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.core.server.publish;

import de.schlichtherle.io.ArchiveDetector;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.jboss.ide.eclipse.archives.core.util.internal.TrueZipUtil;
import org.jboss.ide.eclipse.as.core.server.IModulePathFilter;
import org.jboss.ide.eclipse.as.core.server.IModulePathFilterProvider;
import org.jboss.ide.eclipse.as.core.util.FileUtil;
import org.jboss.ide.eclipse.as.core.util.ModuleResourceUtil;
import org.jboss.ide.eclipse.as.core.util.ProgressMonitorUtil;
import org.jboss.ide.eclipse.as.wtp.core.Messages;
import org.jboss.ide.eclipse.as.wtp.core.util.ServerModelUtilities;

public class LocalZippedModulePublishRunner
extends ModuleResourceUtil {
    private IServer server;
    private IModule[] module;
    private IPath destinationArchive;
    private IModulePathFilterProvider filterProvider;

    public LocalZippedModulePublishRunner(IServer server, IModule module, IPath destinationArchive, IModulePathFilterProvider filterProvider) {
        this(server, new IModule[]{module}, destinationArchive, filterProvider);
    }

    public LocalZippedModulePublishRunner(IServer server, IModule[] module, IPath destinationArchive, IModulePathFilterProvider filterProvider) {
        this.server = server;
        this.module = module;
        this.destinationArchive = destinationArchive;
        this.filterProvider = filterProvider;
    }

    public IStatus fullPublishModule(IProgressMonitor monitor) throws CoreException {
        IStatus[] status = this.fullPublish(monitor);
        TrueZipUtil.umount();
        IStatus finalStatus = this.createModuleStatus(this.module, status);
        return finalStatus;
    }

    public IStatus incrementalPublishModule(IProgressMonitor monitor) throws CoreException {
        File destFile = this.destinationArchive.toFile();
        if (!destFile.exists() || destFile.isDirectory()) {
            return this.fullPublishModule(monitor);
        }
        String name = "Compressing " + this.lastModule().getName();
        monitor.beginTask(name, 1000);
        monitor.setTaskName(name);
        IModule[] moduleAsArray = this.module;
        ArrayList<IStatus> results = new ArrayList<IStatus>();
        int changeCount = LocalZippedModulePublishRunner.countChanges(this.getDeltaForModule(this.module));
        if (changeCount > 0) {
            IProgressMonitor changeMonitor = ProgressMonitorUtil.submon(monitor, 300);
            changeMonitor.beginTask("Copying changed resources", changeCount * 100);
            results.addAll(Arrays.asList(this.publishChanges(moduleAsArray, changeMonitor)));
            changeMonitor.done();
        }
        List<IModule[]> removed = this.getRemovedChildModules();
        IModule[] children = this.getChildModules(moduleAsArray);
        if (children != null) {
            results.addAll(Arrays.asList(this.handleChildrenDeltas(moduleAsArray, children, ProgressMonitorUtil.submon(monitor, 600))));
        }
        IProgressMonitor removedMonitor = ProgressMonitorUtil.submon(monitor, 100);
        removedMonitor.beginTask("Deleting removed modules", removed.size() * 100);
        Iterator<IModule[]> i = removed.iterator();
        while (i.hasNext() && !monitor.isCanceled()) {
            results.addAll(Arrays.asList(this.removeModule(i.next())));
            removedMonitor.worked(100);
        }
        IStatus[] operationStatus = results.toArray(new IStatus[results.size()]);
        removedMonitor.done();
        TrueZipUtil.umount();
        IStatus finalStatus = this.createModuleStatus(moduleAsArray, operationStatus);
        monitor.done();
        return finalStatus;
    }

    protected IModule[] getChildModules(IModule[] parent) {
        return this.server.getChildModules(parent, (IProgressMonitor)new NullProgressMonitor());
    }

    private IStatus[] removeModule(IModule[] module) {
        IPath moduleAbsoluteDestination = module.length == 1 ? this.destinationArchive : this.destinationArchive.append(this.getRootModuleRelativePath(module));
        boolean success = TrueZipUtil.deleteAll((IPath)moduleAbsoluteDestination);
        if (!success) {
            this.generateDeleteFailedStatus(moduleAbsoluteDestination.toFile());
        }
        return new IStatus[]{Status.OK_STATUS};
    }

    private IStatus[] fullPublish(IProgressMonitor monitor) {
        FileUtil.safeDelete(this.destinationArchive.toFile(), null);
        TrueZipUtil.umount();
        return this.fullPublish(this.module, null, ProgressMonitorUtil.getMonitorFor(monitor));
    }

    private IStatus[] fullPublish(IModule[] module, File parent, IProgressMonitor monitor) {
        monitor.beginTask("Packaging Module: " + module[module.length - 1].getName(), 2000);
        ArrayList<IStatus> results = new ArrayList<IStatus>();
        IPath moduleAbsoluteDestination = module.length == 1 ? this.destinationArchive : this.destinationArchive.append(this.getRootModuleRelativePath(module));
        de.schlichtherle.io.File moduleRoot = null;
        try {
            if (parent == null) {
                moduleRoot = TrueZipUtil.getFile((IPath)moduleAbsoluteDestination, (ArchiveDetector)TrueZipUtil.getJarArchiveDetector());
                if (moduleRoot.exists()) {
                    TrueZipUtil.deleteAll((de.schlichtherle.io.File)moduleRoot);
                }
                TrueZipUtil.createArchive((IPath)moduleAbsoluteDestination);
                moduleRoot = TrueZipUtil.getFile((IPath)moduleAbsoluteDestination, (ArchiveDetector)TrueZipUtil.getJarArchiveDetector());
            } else {
                Path parentPath = new Path(parent.getAbsolutePath());
                IPath addition = moduleAbsoluteDestination.removeFirstSegments(parentPath.segmentCount());
                TrueZipUtil.createArchive((File)parent, (IPath)addition);
                moduleRoot = TrueZipUtil.getRelativeArchiveFile((File)parent, (IPath)addition);
            }
            monitor.worked(100);
            IModuleResource[] resources = LocalZippedModulePublishRunner.getResources(module);
            IModulePathFilter filter = this.filterProvider == null ? null : this.filterProvider.getFilter(this.server, module);
            IModuleResource[] resources2 = filter == null ? resources : filter.getFilteredMembers();
            int totalCount = LocalZippedModulePublishRunner.countMembers(resources2, true);
            IProgressMonitor copyMonitor = ProgressMonitorUtil.submon(monitor, 900);
            copyMonitor.beginTask("Copying Resources", totalCount * 100);
            IStatus[] copyResults = this.copy(moduleRoot, resources2, copyMonitor);
            results.addAll(Arrays.asList(copyResults));
            copyMonitor.done();
            TrueZipUtil.umount();
            IModule[] children = this.getChildModules(module);
            if (children != null) {
                this.publishChildren(module, results, children, (File)moduleRoot, ProgressMonitorUtil.submon(monitor, 1000));
            }
            TrueZipUtil.umount();
        }
        catch (CoreException ce) {
            results.add(this.generateCoreExceptionStatus(ce));
        }
        monitor.done();
        return results.toArray(new IStatus[results.size()]);
    }

    private IStatus[] fullBinaryPublish(IModule[] parent, IModule last, IProgressMonitor monitor) {
        ArrayList<IStatus> results = new ArrayList<IStatus>();
        try {
            IPath tail = this.getRootModuleRelativePath(LocalZippedModulePublishRunner.combine(parent, last));
            IPath tailLocation = tail.removeLastSegments(1);
            de.schlichtherle.io.File root = TrueZipUtil.getFile((IPath)this.destinationArchive.append(tailLocation), (ArchiveDetector)TrueZipUtil.getJarArchiveDetector());
            IModuleResource[] resources = LocalZippedModulePublishRunner.getResources(last, (IProgressMonitor)new NullProgressMonitor());
            int total = LocalZippedModulePublishRunner.countMembers(resources, true);
            monitor.beginTask("Copying Resources", total * 100);
            results.addAll(Arrays.asList(this.copy(root, resources, monitor)));
            monitor.done();
            TrueZipUtil.umount();
            return results.toArray(new IStatus[results.size()]);
        }
        catch (CoreException ce) {
            results.add(this.generateCoreExceptionStatus(ce));
            return results.toArray(new IStatus[results.size()]);
        }
    }

    private void publishChildren(IModule[] module, ArrayList<IStatus> results, IModule[] children, File parentModule, IProgressMonitor monitor) {
        if (children == null) {
            return;
        }
        monitor.beginTask("Assembling child modules", children.length * 100);
        int i = 0;
        while (i < children.length && !monitor.isCanceled()) {
            if (ServerModelUtilities.isBinaryModule(children[i])) {
                results.addAll(Arrays.asList(this.fullBinaryPublish(module, children[i], ProgressMonitorUtil.submon(monitor, 100))));
            } else {
                results.addAll(Arrays.asList(this.fullPublish(LocalZippedModulePublishRunner.combine(module, children[i]), parentModule, ProgressMonitorUtil.submon(monitor, 100))));
            }
            ++i;
        }
    }

    private IStatus createModuleStatus(IModule[] module, IStatus[] operationStatus) {
        Status finalStatus;
        if (operationStatus.length > 0) {
            MultiStatus ms = new MultiStatus("org.jboss.ide.eclipse.as.wtp.core", 1644298244, "Publish Failed for module " + module[0].getName(), null);
            int i = 0;
            while (i < operationStatus.length) {
                ms.add(operationStatus[i]);
                ++i;
            }
            finalStatus = ms;
        } else {
            finalStatus = new Status(0, "org.jboss.ide.eclipse.as.wtp.core", 0x2020001, NLS.bind((String)Messages.ModulePublished, (Object)module[0].getName()), null);
        }
        return finalStatus;
    }

    private List<IModule[]> getRemovedChildModules() {
        ArrayList<IModule[]> working = new ArrayList<IModule[]>();
        working.addAll(this.getRemovedModules());
        Iterator i = working.iterator();
        while (i.hasNext()) {
            IModule[] removedArray = (IModule[])i.next();
            if (removedArray.length != 1 && removedArray[0].getId().equals(this.lastModule().getId())) continue;
            i.remove();
        }
        return working;
    }

    private IStatus[] handleChildrenDeltas(IModule[] module, IModule[] children, IProgressMonitor monitor) {
        monitor.beginTask("Handling Child Modules", children.length * 100);
        ArrayList<IStatus> results = new ArrayList<IStatus>();
        int i = 0;
        while (i < children.length) {
            IModule[] combinedChild = LocalZippedModulePublishRunner.combine(module, children[i]);
            if (!this.hasBeenPublished(combinedChild)) {
                results.addAll(Arrays.asList(this.fullPublish(combinedChild, null, ProgressMonitorUtil.submon(monitor, 100))));
            } else if (this.isRemoved(combinedChild)) {
                results.addAll(Arrays.asList(this.removeModule(combinedChild)));
                monitor.worked(100);
            } else {
                results.addAll(Arrays.asList(this.publishChanges(combinedChild, ProgressMonitorUtil.submon(monitor, 25))));
                IModule[] children2 = this.getChildModules(combinedChild);
                if (children2 != null) {
                    results.addAll(Arrays.asList(this.handleChildrenDeltas(module, children2, ProgressMonitorUtil.submon(monitor, 75))));
                }
            }
            ++i;
        }
        monitor.done();
        return results.toArray(new IStatus[results.size()]);
    }

    private boolean isRemoved(IModule[] child) {
        List<IModule[]> removed = this.getRemovedModules();
        for (IModule[] next : removed) {
            if (next.length != child.length) continue;
            int j = 0;
            while (j < next.length) {
                if (!next[j].getId().equals(child[j].getId())) {
                    // empty if block
                }
                ++j;
            }
            return true;
        }
        return false;
    }

    private IStatus[] publishChanges(IModule[] module, IProgressMonitor monitor) {
        IPath path = this.destinationArchive.append(this.getRootModuleRelativePath(module));
        de.schlichtherle.io.File root = TrueZipUtil.getFile((IPath)path, (ArchiveDetector)TrueZipUtil.getJarArchiveDetector());
        IModuleResourceDelta[] deltas = this.getDeltaForModule(module);
        IModulePathFilter filter = this.filterProvider == null ? null : this.filterProvider.getFilter(this.server, module);
        return this.publishChanges(deltas, root, filter, monitor);
    }

    private IPath getRootModuleRelativePath(IModule[] module) {
        int start = this.module.length - 1;
        IModule[] toCheck = new IModule[module.length - start];
        int i = 0;
        while (i < module.length - start) {
            toCheck[i] = module[start + i];
            ++i;
        }
        IPath ret = ServerModelUtilities.getRootModuleRelativePath((IServerAttributes)this.server, toCheck);
        return ret;
    }

    private IStatus[] publishChanges(IModuleResourceDelta[] deltas, de.schlichtherle.io.File root, IModulePathFilter filter, IProgressMonitor monitor) {
        ArrayList<IStatus> results = new ArrayList<IStatus>();
        if (deltas == null || deltas.length == 0) {
            return new IStatus[0];
        }
        int i = 0;
        while (i < deltas.length) {
            int dKind = deltas[i].getKind();
            IModuleResource resource = deltas[i].getModuleResource();
            if (dKind == 1) {
                if (filter == null || filter.shouldInclude(resource)) {
                    results.addAll(Arrays.asList(this.copy(root, new IModuleResource[]{resource}, monitor)));
                }
            } else if (dKind == 2) {
                if (filter == null || filter.shouldInclude(resource)) {
                    if (resource instanceof IModuleFile) {
                        results.addAll(Arrays.asList(this.copy(root, new IModuleResource[]{resource}, monitor)));
                    }
                    results.addAll(Arrays.asList(this.publishChanges(deltas[i].getAffectedChildren(), root, filter, monitor)));
                }
            } else if (dKind == 3) {
                de.schlichtherle.io.File f = this.getDestinationJar(root, resource.getModuleRelativePath().append(resource.getName()));
                boolean b = f.deleteAll();
                if (!b) {
                    results.add(this.generateDeleteFailedStatus((File)f));
                }
            } else if (dKind == 0) {
                results.addAll(Arrays.asList(this.publishChanges(deltas[i].getAffectedChildren(), root, filter, monitor)));
            }
            ++i;
        }
        return results.toArray(new IStatus[results.size()]);
    }

    private IStatus[] copy(de.schlichtherle.io.File root, IModuleResource[] children, IProgressMonitor monitor) {
        ArrayList<IStatus> results = new ArrayList<IStatus>();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof IModuleFile) {
                de.schlichtherle.io.File destination;
                boolean b;
                IModuleFile mf = (IModuleFile)children[i];
                File source = LocalZippedModulePublishRunner.getFile(mf);
                if (source != null && !(b = new de.schlichtherle.io.File(source, (ArchiveDetector)ArchiveDetector.NULL).archiveCopyAllTo((File)(destination = this.getDestinationJar(root, mf.getModuleRelativePath().append(mf.getName())))))) {
                    results.add(this.generateCopyFailStatus(source, (File)destination));
                }
                monitor.worked(100);
            } else if (children[i] instanceof IModuleFolder) {
                de.schlichtherle.io.File destination = this.getDestinationJar(root, children[i].getModuleRelativePath().append(children[i].getName()));
                destination.mkdirs();
                IModuleFolder mf = (IModuleFolder)children[i];
                results.addAll(Arrays.asList(this.copy(root, mf.members(), monitor)));
            }
            ++i;
        }
        return results.toArray(new IStatus[results.size()]);
    }

    private IStatus generateDeleteFailedStatus(File file) {
        return new Status(4, "org.jboss.ide.eclipse.as.wtp.core", "Could not delete file " + file);
    }

    private IStatus generateCoreExceptionStatus(CoreException ce) {
        return new Status(4, "org.jboss.ide.eclipse.as.wtp.core", ce.getMessage(), (Throwable)ce);
    }

    private IStatus generateCopyFailStatus(File source, File destination) {
        return new Status(4, "org.jboss.ide.eclipse.as.wtp.core", "Copy of " + source + " to " + destination + " has failed");
    }

    private de.schlichtherle.io.File getDestinationJar(de.schlichtherle.io.File root, IPath relative) {
        while (relative.segmentCount() > 0) {
            root = relative.segmentCount() == 1 ? new de.schlichtherle.io.File((File)root, relative.segment(0), (ArchiveDetector)TrueZipUtil.JarArchiveDetector.ALL) : new de.schlichtherle.io.File((File)root, relative.segment(0), (ArchiveDetector)ArchiveDetector.NULL);
            relative = relative.removeFirstSegments(1);
        }
        return root;
    }

    private de.schlichtherle.io.File getFileInArchive(de.schlichtherle.io.File root, IPath relative) {
        return TrueZipUtil.getFileInArchive((de.schlichtherle.io.File)root, (IPath)relative);
    }

    protected IModuleResourceDelta[] getDeltaForModule(IModule[] module) {
        IModuleResourceDelta[] deltas = ((Server)this.server).getPublishedResourceDelta(module);
        return deltas;
    }

    protected List<IModule[]> getRemovedModules() {
        List l = ((Server)this.server).getAllModules();
        int size = l.size();
        ((Server)this.server).getServerPublishInfo().addRemovedModules(l);
        if (l.size() > size) {
            List<IModule[]> l2 = l.subList(size, l.size() - 1);
            return l2;
        }
        return new ArrayList<IModule[]>();
    }

    protected boolean hasBeenPublished(IModule[] mod) {
        return ((Server)this.server).getServerPublishInfo().hasModulePublishInfo(mod);
    }

    public int childPublishTypeRequired() {
        return this.childPublishTypeRequired(this.module);
    }

    private IModule lastModule() {
        return this.module == null ? null : (this.module.length == 0 ? null : this.module[this.module.length - 1]);
    }

    protected int childPublishTypeRequired(IModule[] mod) {
        IModule[] children = this.getChildModules(mod);
        boolean atLeastIncremental = false;
        int i = 0;
        while (i < children.length) {
            IModuleResourceDelta[] delta;
            IModule[] combinedChild = LocalZippedModulePublishRunner.combine(mod, children[i]);
            if (!this.hasBeenPublished(combinedChild)) {
                return 2;
            }
            if (this.isRemoved(combinedChild)) {
                return 2;
            }
            int childrenRequire = this.childPublishTypeRequired(combinedChild);
            if (childrenRequire == 2) {
                return childrenRequire;
            }
            if (childrenRequire == 1) {
                atLeastIncremental = true;
            }
            if ((delta = this.getDeltaForModule(combinedChild)).length > 0) {
                atLeastIncremental = true;
            }
            ++i;
        }
        if (atLeastIncremental) {
            return 1;
        }
        return 0;
    }
}

