/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.core.vcf;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class ComponentUtils {
    private static HashMap<String, String> facetToExtension = null;

    static {
        facetToExtension = new HashMap();
        facetToExtension.put("jst.web", ".war");
        facetToExtension.put("jst.ejb", ".jar");
        facetToExtension.put("wst.web", ".war");
        facetToExtension.put("jst.appclient", ".jar");
        facetToExtension.put("jst.connector", ".rar");
        facetToExtension.put("jst.ear", ".ear");
    }

    public static void addMapping(String facet, String extension) {
        facetToExtension.put(facet, extension);
    }

    public static String getDefaultProjectExtension(IVirtualComponent component) {
        IFacetedProject fp;
        if (!component.isBinary() && (fp = ComponentUtils.getFacetedProject(component.getProject())) != null) {
            Iterator<String> i = facetToExtension.keySet().iterator();
            String facet = null;
            while (i.hasNext()) {
                facet = i.next();
                if (!ComponentUtils.isProjectOfType(fp, facet)) continue;
                return facetToExtension.get(facet);
            }
        }
        return ".jar";
    }

    private static IFacetedProject getFacetedProject(IProject project) {
        IFacetedProject facetedProject = null;
        if (project != null && project.isAccessible()) {
            try {
                facetedProject = ProjectFacetsManager.create((IProject)project);
            }
            catch (CoreException coreException) {}
        }
        return facetedProject;
    }

    private static boolean isProjectOfType(IFacetedProject facetedProject, String typeID) {
        if (facetedProject != null && ProjectFacetsManager.isProjectFacetDefined((String)typeID)) {
            IProjectFacet projectFacet = ProjectFacetsManager.getProjectFacet((String)typeID);
            return projectFacet != null && facetedProject.hasProjectFacet(projectFacet);
        }
        return false;
    }
}

