/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.editor.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.internal.command.ServerCommand;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.publishers.PublishUtil;
import org.jboss.ide.eclipse.as.core.server.IDeployableServer;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.ide.eclipse.as.core.server.IServerModeDetails;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.ServerExtendedProperties;
import org.jboss.ide.eclipse.as.core.util.JBossServerBehaviorUtils;
import org.jboss.ide.eclipse.as.core.util.ServerAttributeHelper;
import org.jboss.ide.eclipse.as.core.util.ServerUtil;
import org.jboss.ide.eclipse.as.ui.JBossServerUIPlugin;
import org.jboss.ide.eclipse.as.ui.Messages;
import org.jboss.ide.eclipse.as.ui.editor.DeploymentPage;
import org.jboss.ide.eclipse.as.ui.editor.internal.StandardDeploymentPageController;
import org.jboss.ide.eclipse.as.ui.subsystems.IBrowseBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ServerProfileModel;
import org.jboss.tools.as.core.server.controllable.systems.IDeploymentOptionsController;

public class JBossDeploymentOptionsComposite
extends Composite
implements PropertyChangeListener {
    protected static final String MAIN = "local";
    private StandardDeploymentPageController controller;
    private Text deployText;
    private Text tempDeployText;
    private Button metadataRadio;
    private Button serverRadio;
    private Button customRadio;
    private Button currentRadioSelection;
    private Button deployButton;
    private Button tempDeployButton;
    private ModifyListener deployListener;
    private ModifyListener tempDeployListener;
    private SelectionListener radioListener;
    private SelectionListener zipListener;
    private Button zipDeployWTPProjects;
    private String lastCustomDeploy;
    private String lastCustomTemp;
    private ArrayList<Control> enableDisableWidgets = new ArrayList();
    private IServerWorkingCopy lastWC;

    public JBossDeploymentOptionsComposite(Composite parent, StandardDeploymentPageController page) {
        super(parent, 0);
        this.controller = page;
        this.setLayout((Layout)new GridLayout(1, true));
        this.createDefaultComposite(this);
    }

    protected String openBrowseDialog(String original) {
        IControllableServerBehavior csb = JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)this.lastWC);
        IBrowseBehavior beh = null;
        if (csb != null) {
            try {
                beh = (IBrowseBehavior)csb.getController("browseBehavior");
                return beh.openBrowseDialog((IServerAttributes)this.controller.getPage().getServer(), original);
            }
            catch (CoreException ce) {
                JBossServerUIPlugin.log(ce.getStatus());
            }
        }
        return null;
    }

    public DeploymentPage getPage() {
        return this.controller.getPage();
    }

    protected ServerAttributeHelper getHelper() {
        return this.getPage().getHelper();
    }

    public Button getServerRadio() {
        return this.serverRadio;
    }

    public Button getCustomRadio() {
        return this.customRadio;
    }

    public Button getMetadataRadio() {
        return this.metadataRadio;
    }

    public Button getSelectedRadio() {
        return this.currentRadioSelection;
    }

    protected boolean shouldCreateMetadataRadio() {
        return true;
    }

    protected boolean shouldCreateCustomRadio() {
        return true;
    }

    protected boolean shouldCreateServerRadio() {
        return true;
    }

    protected boolean shouldEnableMetadataRadio() {
        if (!this.shouldCreateMetadataRadio()) {
            return false;
        }
        String mode = ServerProfileModel.getProfile((IServerAttributes)this.getPage().getServer());
        if (!MAIN.equals(mode)) {
            return false;
        }
        IServer s = this.getPage().getServer().getOriginal();
        ServerExtendedProperties props = (ServerExtendedProperties)s.loadAdapter(ServerExtendedProperties.class, null);
        if (props == null) {
            return true;
        }
        return props.getMultipleDeployFolderSupport() != 1;
    }

    protected boolean showTempDeployText() {
        return true;
    }

    protected boolean showDeployText() {
        return true;
    }

    protected Section createSection(FormToolkit toolkit, Composite parent) {
        Section section = toolkit.createSection(parent, 322);
        section.setText(Messages.swf_DeployEditorHeading);
        section.setToolTipText(Messages.swf_DeploymentDescription);
        section.setLayoutData((Object)new GridData(784));
        return section;
    }

    protected Control createDescriptionLabel(FormToolkit toolkit, Composite composite) {
        Label descriptionLabel = toolkit.createLabel(composite, Messages.swf_DeploymentDescriptionLabel);
        descriptionLabel.setToolTipText(Messages.swf_DeploymentDescription);
        return descriptionLabel;
    }

    protected Composite createDefaultComposite(Composite parent) {
        this.lastWC = this.getPage().getServer();
        this.lastWC.addPropertyChangeListener((PropertyChangeListener)this);
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Section section = this.createSection(toolkit, parent);
        Composite composite = toolkit.createComposite((Composite)section);
        composite.setLayout((Layout)new FormLayout());
        this.createDefaultCompositeContents(toolkit, composite);
        toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
        this.getPage().getSaveStatus();
        this.updateWidgets();
        return section;
    }

    protected void createDefaultCompositeContents(FormToolkit toolkit, Composite composite) {
        Control top = this.createDescriptionLabel(toolkit, composite);
        if (top != null) {
            FormData fd1 = new FormData();
            fd1.left = new FormAttachment(0, 5);
            fd1.top = new FormAttachment(0, 5);
            top.setLayoutData((Object)fd1);
        }
        if (this.getShowRadios()) {
            Composite inner = this.addRadios(toolkit, composite);
            FormData radios = new FormData();
            radios.top = new FormAttachment(top, 5);
            radios.left = new FormAttachment(0, 5);
            radios.right = new FormAttachment(100, -5);
            inner.setLayoutData((Object)radios);
            top = inner;
        }
        if (this.showDeployText()) {
            top = this.addDeployText(toolkit, composite, top);
        }
        if (this.showTempDeployText()) {
            top = this.addTempDeployText(toolkit, composite, top);
        }
        if (this.showZipWidgets()) {
            this.addZipWidgets(toolkit, composite, top);
        }
    }

    protected boolean showZipWidgets() {
        return true;
    }

    protected Control addZipWidgets(FormToolkit toolkit, Composite composite, Control top) {
        this.zipDeployWTPProjects = toolkit.createButton(composite, Messages.EditorZipDeployments, 32);
        boolean zippedPublisherAvailable = this.isZippedPublisherAvailable();
        boolean value = this.getServer().zipsWTPDeployments();
        this.zipDeployWTPProjects.setEnabled(zippedPublisherAvailable);
        this.zipDeployWTPProjects.setSelection(zippedPublisherAvailable && value);
        FormData zipButtonData = new FormData();
        zipButtonData.right = new FormAttachment(100, -5);
        zipButtonData.left = new FormAttachment(0, 5);
        zipButtonData.top = new FormAttachment(top, 5);
        this.zipDeployWTPProjects.setLayoutData((Object)zipButtonData);
        this.zipListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JBossDeploymentOptionsComposite.this.getPage().execute((IUndoableOperation)new SetZipCommand());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this.zipDeployWTPProjects.addSelectionListener(this.zipListener);
        return this.zipDeployWTPProjects;
    }

    protected Composite addRadios(FormToolkit toolkit, Composite parent) {
        this.radioListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                JBossDeploymentOptionsComposite.this.radioSelected(e.getSource());
            }
        };
        Composite inner = toolkit.createComposite(parent);
        inner.setLayout((Layout)new GridLayout(1, false));
        if (this.shouldCreateMetadataRadio()) {
            this.metadataRadio = toolkit.createButton(inner, Messages.EditorUseWorkspaceMetadata, 16);
            this.metadataRadio.addSelectionListener(this.radioListener);
            this.metadataRadio.setEnabled(this.shouldEnableMetadataRadio());
            this.enableDisableWidgets.add((Control)this.metadataRadio);
        }
        if (this.shouldCreateServerRadio()) {
            this.serverRadio = toolkit.createButton(inner, Messages.EditorUseServersDeployFolder, 16);
            this.serverRadio.addSelectionListener(this.radioListener);
            this.enableDisableWidgets.add((Control)this.serverRadio);
        }
        if (this.shouldCreateCustomRadio()) {
            this.customRadio = toolkit.createButton(inner, Messages.EditorUseCustomDeployFolder, 16);
            this.customRadio.addSelectionListener(this.radioListener);
            this.enableDisableWidgets.add((Control)this.customRadio);
        }
        return inner;
    }

    @Deprecated
    protected Control addTempAndDeployTexts(FormToolkit toolkit, Composite parent, Control top) {
        Control top2 = this.addDeployText(toolkit, parent, top);
        return this.addTempDeployText(toolkit, parent, top2);
    }

    protected Control addTempDeployText(FormToolkit toolkit, Composite parent, Control top) {
        Label tempDeployLabel = toolkit.createLabel(parent, Messages.swf_TempDeployDirectory);
        tempDeployLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.tempDeployText = toolkit.createText(parent, this.getTempDeployDir(), 2048);
        this.enableDisableWidgets.add((Control)this.tempDeployText);
        this.tempDeployListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JBossDeploymentOptionsComposite.this.getPage().execute((IUndoableOperation)new SetTempDeployDirCommand());
            }
        };
        this.tempDeployText.addModifyListener(this.tempDeployListener);
        this.tempDeployButton = toolkit.createButton(parent, Messages.browse, 8);
        this.enableDisableWidgets.add((Control)this.tempDeployButton);
        this.tempDeployButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String x = JBossDeploymentOptionsComposite.this.openBrowseDialog(JBossDeploymentOptionsComposite.this.tempDeployText.getText());
                if (x != null) {
                    JBossDeploymentOptionsComposite.this.tempDeployText.setText(JBossDeploymentOptionsComposite.this.makeRelative(x));
                }
            }
        });
        FormData tempLabelData = new FormData();
        tempLabelData.left = new FormAttachment(0, 5);
        tempLabelData.right = new FormAttachment(top, -5);
        tempLabelData.top = new FormAttachment(top, 5);
        tempDeployLabel.setLayoutData((Object)tempLabelData);
        FormData tempTextData = new FormData();
        tempTextData.left = new FormAttachment((Control)this.tempDeployButton, -305);
        tempTextData.top = new FormAttachment(top, 5);
        tempTextData.right = new FormAttachment((Control)this.tempDeployButton, -5);
        this.tempDeployText.setLayoutData((Object)tempTextData);
        FormData tempButtonData = new FormData();
        tempButtonData.right = new FormAttachment(100, -5);
        tempButtonData.left = new FormAttachment(100, -100);
        tempButtonData.top = new FormAttachment(top, 5);
        this.tempDeployButton.setLayoutData((Object)tempButtonData);
        return this.tempDeployText;
    }

    protected Control addDeployText(FormToolkit toolkit, Composite parent, Control top) {
        Label label = toolkit.createLabel(parent, Messages.swf_DeployDirectory);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.deployText = toolkit.createText(parent, this.getDeployDir(), 2048);
        this.enableDisableWidgets.add((Control)this.deployText);
        this.deployListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JBossDeploymentOptionsComposite.this.getPage().execute((IUndoableOperation)new SetDeployDirCommand());
            }
        };
        this.deployText.addModifyListener(this.deployListener);
        this.deployButton = toolkit.createButton(parent, Messages.browse, 8);
        this.enableDisableWidgets.add((Control)this.deployButton);
        this.deployButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String x = JBossDeploymentOptionsComposite.this.openBrowseDialog(JBossDeploymentOptionsComposite.this.deployText.getText());
                if (x != null) {
                    JBossDeploymentOptionsComposite.this.deployText.setText(JBossDeploymentOptionsComposite.this.makeRelative(x));
                }
            }
        });
        FormData labelData = new FormData();
        labelData.left = new FormAttachment(0, 5);
        labelData.right = new FormAttachment((Control)this.deployText, -5);
        labelData.top = new FormAttachment(top, 5);
        label.setLayoutData((Object)labelData);
        FormData textData = new FormData();
        textData.left = new FormAttachment((Control)this.deployButton, -305);
        textData.top = new FormAttachment(top, 5);
        textData.right = new FormAttachment((Control)this.deployButton, -5);
        this.deployText.setLayoutData((Object)textData);
        FormData buttonData = new FormData();
        buttonData.right = new FormAttachment(100, -5);
        buttonData.left = new FormAttachment(100, -100);
        buttonData.top = new FormAttachment(top, 2);
        this.deployButton.setLayoutData((Object)buttonData);
        return this.deployText;
    }

    protected boolean getShowRadios() {
        return true;
    }

    private void updateWidgets() {
        if (this.getShowRadios()) {
            if (this.shouldCreateMetadataRadio()) {
                this.metadataRadio.setSelection(this.getDeployType().equals("metadata"));
            }
            if (this.shouldCreateServerRadio()) {
                this.serverRadio.setSelection(this.getDeployType().equals("server"));
            }
            if (this.shouldCreateCustomRadio()) {
                this.customRadio.setSelection(this.getDeployType().equals("custom"));
            }
            Button button = this.metadataRadio != null && this.metadataRadio.getSelection() ? this.metadataRadio : (this.currentRadioSelection = this.serverRadio != null && this.serverRadio.getSelection() ? this.serverRadio : this.customRadio);
        }
        if (this.showDeployText() || this.showTempDeployText()) {
            try {
                IControllableServerBehavior beh = JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)this.getPage().getServer());
                IDeploymentOptionsController deployOpts = (IDeploymentOptionsController)beh.getWorkingCopyController("deploymentOptions", this.getHelper().getWorkingCopy());
                if (this.showDeployText()) {
                    String newDir = deployOpts.getDeploymentsRootFolder(false);
                    this.deployText.removeModifyListener(this.deployListener);
                    if (!this.deployText.getText().equals(newDir)) {
                        this.deployText.setText(newDir);
                    }
                    this.deployText.addModifyListener(this.deployListener);
                    this.deployText.setEnabled(this.shouldEnableControl((Control)this.deployText));
                    this.deployButton.setEnabled(this.shouldEnableControl((Control)this.deployButton));
                }
                if (this.showTempDeployText()) {
                    String newTemp = deployOpts.getDeploymentsTemporaryFolder(false);
                    this.tempDeployText.removeModifyListener(this.tempDeployListener);
                    if (!this.tempDeployText.getText().equals(newTemp)) {
                        this.tempDeployText.setText(newTemp);
                    }
                    this.tempDeployText.addModifyListener(this.tempDeployListener);
                    this.tempDeployText.setEnabled(this.shouldEnableControl((Control)this.tempDeployText));
                    this.tempDeployButton.setEnabled(this.shouldEnableControl((Control)this.tempDeployButton));
                }
            }
            catch (CoreException ce) {
                JBossServerUIPlugin.log(ce.getStatus());
            }
        }
    }

    public void radioSelected(Object c) {
        if (c == this.currentRadioSelection) {
            return;
        }
        this.getPage().execute((IUndoableOperation)new RadioClickedCommand((Button)c, this.currentRadioSelection));
        this.currentRadioSelection = (Button)c;
    }

    protected boolean isZippedPublisherAvailable() {
        return true;
    }

    private String getDeployType() {
        return this.getServer().getDeployLocationType();
    }

    private String getDeployDir() {
        if (this.getPage().getServer().getRuntime() == null) {
            return "";
        }
        return JBossDeploymentOptionsComposite.makeRelative(this.getServer().getDeployFolder(), this.getPage().getServer().getRuntime());
    }

    private String getTempDeployDir() {
        if (this.getPage().getServer().getRuntime() == null) {
            return "";
        }
        return JBossDeploymentOptionsComposite.makeRelative(this.getServer().getTempDeployFolder(), this.getPage().getServer().getRuntime());
    }

    private IDeployableServer getServer() {
        return (IDeployableServer)this.getPage().getServer().loadAdapter(IDeployableServer.class, (IProgressMonitor)new NullProgressMonitor());
    }

    public void updateListeners() {
        if (this.lastWC != null) {
            this.lastWC.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.lastWC = this.getPage().getServer();
        if (this.lastWC != null) {
            this.lastWC.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.getShowRadios() && ServerProfileModel.isProfileKey((String)evt.getPropertyName()) && this.shouldCreateMetadataRadio()) {
            this.metadataRadio.setEnabled(this.shouldEnableMetadataRadio());
            if (!this.metadataRadio.isEnabled() && this.metadataRadio.getSelection()) {
                this.getPage().execute((IUndoableOperation)new RadioClickedCommand(this.serverRadio, this.currentRadioSelection));
            }
        }
        this.updateWidgets();
    }

    public static String getDefaultOutputName(IModule module) {
        String suffix;
        String lastSegment = new Path(module.getName()).lastSegment();
        String ret = lastSegment.endsWith(suffix = PublishUtil.getSuffix((String)module.getModuleType().getId())) ? lastSegment : String.valueOf(lastSegment) + suffix;
        return ret;
    }

    public void setEnabled(boolean enabled) {
        for (Control c : this.enableDisableWidgets) {
            if (!this.shouldEnableControl(c)) continue;
            c.setEnabled(enabled);
        }
    }

    protected boolean shouldEnableControl(Control c) {
        if (c == null || c.isDisposed()) {
            return false;
        }
        if (c == this.deployText || c == this.tempDeployText || c == this.deployButton || c == this.tempDeployButton) {
            return this.getDeployType().equals("custom");
        }
        if (c == this.metadataRadio) {
            return this.shouldEnableMetadataRadio();
        }
        return true;
    }

    protected char getSeparatorCharacter(IServer server) {
        try {
            IDeploymentOptionsController cont = (IDeploymentOptionsController)JBossServerBehaviorUtils.getController((IServerAttributes)server, (String)"deploymentOptions", IDeploymentOptionsController.class);
            return cont == null ? File.separatorChar : cont.getPathSeparatorCharacter();
        }
        catch (CoreException coreException) {
            return File.separatorChar;
        }
    }

    private String makeRelative(String path) {
        char sep = this.getSeparatorCharacter(this.getPage().getServer().getOriginal());
        if (sep != File.separatorChar) {
            return path;
        }
        return JBossDeploymentOptionsComposite.makeRelative(path, this.getPage().getServer().getRuntime());
    }

    private static String makeRelative(String path, IRuntime runtime) {
        return ServerUtil.makeRelative((IRuntime)runtime, (IPath)new Path(path)).toOSString();
    }

    public IStatus[] validate() {
        return new IStatus[0];
    }

    public class RadioClickedCommand
    extends ServerCommand {
        private Button newSelection;
        private Button oldSelection;
        private String oldDir;
        private String newDir;
        private String oldTemp;
        private String newTemp;
        private String id;

        public RadioClickedCommand(Button clicked, Button previous) {
            super(JBossDeploymentOptionsComposite.this.getPage().getServer(), Messages.EditorSetRadioClicked);
            this.newSelection = clicked;
            this.oldSelection = previous;
            this.id = this.server.getId();
        }

        public void execute() {
            this.oldDir = JBossDeploymentOptionsComposite.this.deployText == null ? null : JBossDeploymentOptionsComposite.this.deployText.getText();
            String string = this.oldTemp = JBossDeploymentOptionsComposite.this.tempDeployText == null ? null : JBossDeploymentOptionsComposite.this.tempDeployText.getText();
            String newType = this.newSelection == JBossDeploymentOptionsComposite.this.customRadio ? "custom" : (this.newSelection == JBossDeploymentOptionsComposite.this.serverRadio ? "server" : "metadata");
            this.discoverNewFolders();
            ServerAttributeHelper helper = JBossDeploymentOptionsComposite.this.getHelper();
            helper.setAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectory", this.newDir);
            helper.setAttribute("org.jboss.ide.eclipse.as.core.server.tempDeployDirectory", this.newTemp);
            helper.setAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectoryType", newType);
            JBossDeploymentOptionsComposite.this.updateWidgets();
            JBossDeploymentOptionsComposite.this.getPage().getSaveStatus();
        }

        protected void handleMetadataRadioSelected() {
            this.newDir = JBossServerCorePlugin.getServerStateLocation((String)this.id).append("deploy").makeAbsolute().toString();
            this.newTemp = JBossServerCorePlugin.getServerStateLocation((String)this.id).append("tempDeploy").makeAbsolute().toString();
            new File(this.newDir).mkdirs();
            new File(this.newTemp).mkdirs();
        }

        protected void handleServerRadioSelected() {
            if (this.server.getRuntime() != null && this.server.getRuntime().loadAdapter(IJBossServerRuntime.class, null) != null) {
                this.newDir = this.getServerRadioNewDeployDir();
                this.newTemp = this.getServerRadioNewTempDeployDir();
                String mode = ServerProfileModel.getProfile((IServerAttributes)JBossDeploymentOptionsComposite.this.getPage().getServer());
                if (JBossDeploymentOptionsComposite.MAIN.equals(mode)) {
                    new File(this.newTemp).mkdirs();
                }
            }
        }

        protected String getServerRadioNewDeployDir() {
            IServerModeDetails det = (IServerModeDetails)Platform.getAdapterManager().getAdapter((Object)this.server, IServerModeDetails.class);
            if (det == null) {
                return "";
            }
            String s = det.getProperty("PROP_SERVER_DEPLOYMENTS_FOLDER_RELATIVE");
            return s;
        }

        protected String getServerRadioNewTempDeployDir() {
            IServerModeDetails det = (IServerModeDetails)Platform.getAdapterManager().getAdapter((Object)this.server, IServerModeDetails.class);
            if (det == null) {
                return "";
            }
            String s = det.getProperty("PROP_SERVER_TMP_DEPLOYMENTS_FOLDER_RELATIVE");
            return s;
        }

        protected void discoverNewFolders() {
            if (this.newSelection == JBossDeploymentOptionsComposite.this.metadataRadio) {
                this.handleMetadataRadioSelected();
            } else if (this.newSelection == JBossDeploymentOptionsComposite.this.serverRadio) {
                this.handleServerRadioSelected();
            } else {
                this.newDir = JBossDeploymentOptionsComposite.this.lastCustomDeploy;
                this.newTemp = JBossDeploymentOptionsComposite.this.lastCustomTemp;
            }
            this.newDir = this.newDir == null ? this.oldDir : this.newDir;
            this.newTemp = this.newTemp == null ? this.oldTemp : this.newTemp;
        }

        public void undo() {
            String oldType = this.oldSelection == JBossDeploymentOptionsComposite.this.customRadio ? "custom" : (this.oldSelection == JBossDeploymentOptionsComposite.this.serverRadio ? "server" : "metadata");
            JBossDeploymentOptionsComposite.this.getHelper().setAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectory", this.oldDir);
            JBossDeploymentOptionsComposite.this.getHelper().setAttribute("org.jboss.ide.eclipse.as.core.server.tempDeployDirectory", this.oldTemp);
            JBossDeploymentOptionsComposite.this.getHelper().setAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectoryType", oldType);
            JBossDeploymentOptionsComposite.this.updateWidgets();
            JBossDeploymentOptionsComposite.this.getPage().getSaveStatus();
        }
    }

    public class SetDeployDirCommand
    extends ServerCommand {
        private String oldDir;
        private String newDir;
        private Text text;
        private ModifyListener listener;

        public SetDeployDirCommand() {
            super(JBossDeploymentOptionsComposite.this.getPage().getServer(), Messages.EditorSetDeployLabel);
            this.text = JBossDeploymentOptionsComposite.this.deployText;
            this.newDir = JBossDeploymentOptionsComposite.this.deployText.getText();
            this.listener = JBossDeploymentOptionsComposite.this.deployListener;
            this.oldDir = JBossDeploymentOptionsComposite.this.getHelper().getAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectory", "");
        }

        public void execute() {
            JBossDeploymentOptionsComposite.this.getHelper().setAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectory", this.newDir);
            JBossDeploymentOptionsComposite.this.lastCustomDeploy = this.newDir;
            JBossDeploymentOptionsComposite.this.updateWidgets();
            JBossDeploymentOptionsComposite.this.getPage().getSaveStatus();
        }

        public void undo() {
            JBossDeploymentOptionsComposite.this.getHelper().setAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectory", this.oldDir);
            JBossDeploymentOptionsComposite.this.updateWidgets();
            JBossDeploymentOptionsComposite.this.getPage().getSaveStatus();
        }
    }

    public class SetTempDeployDirCommand
    extends ServerCommand {
        private String oldDir;
        private String newDir;
        private Text text;
        private ModifyListener listener;

        public SetTempDeployDirCommand() {
            super(JBossDeploymentOptionsComposite.this.getPage().getServer(), Messages.EditorSetTempDeployLabel);
            this.text = JBossDeploymentOptionsComposite.this.tempDeployText;
            this.newDir = JBossDeploymentOptionsComposite.this.tempDeployText.getText();
            this.listener = JBossDeploymentOptionsComposite.this.tempDeployListener;
            this.oldDir = JBossDeploymentOptionsComposite.this.getHelper().getAttribute("org.jboss.ide.eclipse.as.core.server.tempDeployDirectory", "");
        }

        public void execute() {
            JBossDeploymentOptionsComposite.this.getHelper().setAttribute("org.jboss.ide.eclipse.as.core.server.tempDeployDirectory", this.newDir);
            JBossDeploymentOptionsComposite.this.lastCustomTemp = this.newDir;
            JBossDeploymentOptionsComposite.this.updateWidgets();
            JBossDeploymentOptionsComposite.this.getPage().getSaveStatus();
        }

        public void undo() {
            JBossDeploymentOptionsComposite.this.getHelper().setAttribute("org.jboss.ide.eclipse.as.core.server.tempDeployDirectory", this.oldDir);
            JBossDeploymentOptionsComposite.this.updateWidgets();
            JBossDeploymentOptionsComposite.this.getPage().getSaveStatus();
        }
    }

    public class SetZipCommand
    extends ServerCommand {
        boolean oldVal;
        boolean newVal;

        public SetZipCommand() {
            super(JBossDeploymentOptionsComposite.this.getPage().getServer(), Messages.EditorZipDeployments);
            this.oldVal = JBossDeploymentOptionsComposite.this.getHelper().getAttribute("org.jboss.ide.eclipse.as.core.server.zipDeploymentsPreference", false);
            this.newVal = JBossDeploymentOptionsComposite.this.zipDeployWTPProjects.getSelection();
        }

        public void execute() {
            JBossDeploymentOptionsComposite.this.getHelper().setAttribute("org.jboss.ide.eclipse.as.core.server.zipDeploymentsPreference", this.newVal);
            JBossDeploymentOptionsComposite.this.getPage().getSaveStatus();
        }

        public void undo() {
            JBossDeploymentOptionsComposite.this.zipDeployWTPProjects.removeSelectionListener(JBossDeploymentOptionsComposite.this.zipListener);
            JBossDeploymentOptionsComposite.this.zipDeployWTPProjects.setSelection(this.oldVal);
            JBossDeploymentOptionsComposite.this.getHelper().setAttribute("org.jboss.ide.eclipse.as.core.server.zipDeploymentsPreference", this.oldVal);
            JBossDeploymentOptionsComposite.this.zipDeployWTPProjects.addSelectionListener(JBossDeploymentOptionsComposite.this.zipListener);
            JBossDeploymentOptionsComposite.this.getPage().getSaveStatus();
        }
    }
}

