/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.views.as7.management.content;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.wst.server.core.IServer;
import org.jboss.dmr.ModelNode;
import org.jboss.ide.eclipse.as.core.server.v7.management.AS7ManagementDetails;
import org.jboss.ide.eclipse.as.management.core.IAS7ManagementDetails;
import org.jboss.ide.eclipse.as.management.core.IJBoss7ManagerService;
import org.jboss.ide.eclipse.as.management.core.JBoss7ManagerUtil;
import org.jboss.ide.eclipse.as.ui.views.as7.management.content.AttributesContainer;
import org.jboss.ide.eclipse.as.ui.views.as7.management.content.ContainerNode;
import org.jboss.ide.eclipse.as.ui.views.as7.management.content.IAttributesContainer;
import org.jboss.ide.eclipse.as.ui.views.as7.management.content.IContainerNode;
import org.jboss.ide.eclipse.as.ui.views.as7.management.content.IContentNode;
import org.jboss.ide.eclipse.as.ui.views.as7.management.content.IResourceNode;
import org.jboss.ide.eclipse.as.ui.views.as7.management.content.ITypeNode;
import org.jboss.ide.eclipse.as.ui.views.as7.management.content.TypeNode;

public class ResourceNode
extends ContainerNode<ITypeNode>
implements IResourceNode {
    private ArrayList<IContentNode<? extends IContainerNode<?>>> children;

    protected ResourceNode(ITypeNode parent, String name) {
        super(parent, name);
    }

    protected ResourceNode(IServer server, String name) {
        super(server, name);
    }

    @Override
    public String getAddress() {
        if (this.getParent() == null) {
            return "";
        }
        return String.valueOf(this.getParent().getAddress()) + "/" + ((ITypeNode)this.getContainer()).getName() + "=" + this.getName();
    }

    @Override
    protected List<IContentNode<? extends IContainerNode<?>>> delegateGetChildren() {
        return this.children;
    }

    @Override
    protected void delegateClearChildren() {
        if (this.children != null) {
            for (IContentNode<IContainerNode<?>> child : this.children) {
                child.dispose();
            }
            this.children.clear();
            this.children = null;
        }
    }

    @Override
    protected void delegateLoad() throws Exception {
        IContentNode<? extends IContainerNode<?>> child;
        String resultJSON = (String)JBoss7ManagerUtil.executeWithService((JBoss7ManagerUtil.IServiceAware)new JBoss7ManagerUtil.IServiceAware<String>(){

            public String execute(IJBoss7ManagerService service) throws Exception {
                return service.execute((IAS7ManagementDetails)new AS7ManagementDetails(ResourceNode.this.getServer()), ResourceNode.this.createResourceDescriptionRequest());
            }
        }, (IServer)this.getServer());
        ModelNode result = ModelNode.fromJSONString((String)resultJSON);
        this.children = new ArrayList();
        if (result.hasDefined("attributes")) {
            this.populateAttributes(result.get("attributes").asObject());
        }
        if (result.hasDefined("children")) {
            this.populateTypes(result.get("children").asObject());
        }
        if (this.children.size() == 1 && (child = this.children.get(0)) instanceof IAttributesContainer) {
            IAttributesContainer attributesContainer = (IAttributesContainer)child;
            this.children.clear();
            attributesContainer.load();
            this.children.addAll(attributesContainer.getChildren());
        }
    }

    private String createResourceDescriptionRequest() {
        ModelNode request = new ModelNode();
        request.get("operation").set("read-resource-description");
        request.get("address").set(ResourceNode.getManagementAddress(this));
        return request.toJSONString(true);
    }

    private void populateAttributes(ModelNode result) {
        Set keys = result.keys();
        if (keys.size() > 0) {
            this.children.add(new AttributesContainer(this, new ArrayList<String>(keys)));
        }
    }

    private void populateTypes(ModelNode result) {
        Set keys = result.keys();
        this.children.ensureCapacity(this.children.size() + keys.size());
        for (String key : keys) {
            this.children.add(new TypeNode(this, key));
        }
    }
}

