/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.views.as7.management.content;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.server.core.IServer;
import org.jboss.dmr.ModelNode;
import org.jboss.ide.eclipse.as.core.server.v7.management.AS7ManagementDetails;
import org.jboss.ide.eclipse.as.management.core.IAS7ManagementDetails;
import org.jboss.ide.eclipse.as.management.core.IJBoss7ManagerService;
import org.jboss.ide.eclipse.as.management.core.JBoss7ManagerUtil;
import org.jboss.ide.eclipse.as.ui.views.as7.management.content.ContainerNode;
import org.jboss.ide.eclipse.as.ui.views.as7.management.content.IResourceNode;
import org.jboss.ide.eclipse.as.ui.views.as7.management.content.ITypeNode;
import org.jboss.ide.eclipse.as.ui.views.as7.management.content.ResourceNode;

public class TypeNode
extends ContainerNode<IResourceNode>
implements ITypeNode {
    private List<IResourceNode> resources;

    protected TypeNode(IResourceNode container, String name) {
        super(container, name);
    }

    @Override
    protected List<IResourceNode> delegateGetChildren() {
        return this.resources;
    }

    @Override
    protected void delegateClearChildren() {
        if (this.resources != null) {
            for (IResourceNode resource : this.resources) {
                resource.dispose();
            }
            this.resources.clear();
            this.resources = null;
        }
    }

    @Override
    protected void delegateLoad() throws Exception {
        String resultJSON = (String)JBoss7ManagerUtil.executeWithService((JBoss7ManagerUtil.IServiceAware)new JBoss7ManagerUtil.IServiceAware<String>(){

            public String execute(IJBoss7ManagerService service) throws Exception {
                return service.execute((IAS7ManagementDetails)new AS7ManagementDetails(TypeNode.this.getServer()), TypeNode.this.createResourceNamesRequest());
            }
        }, (IServer)this.getServer());
        ModelNode result = ModelNode.fromJSONString((String)resultJSON);
        List childResources = result.asList();
        this.resources = new ArrayList<IResourceNode>(childResources.size());
        for (ModelNode child : childResources) {
            this.resources.add(new ResourceNode(this, child.asString()));
        }
    }

    private String createResourceNamesRequest() {
        ModelNode request = new ModelNode();
        request.get("operation").set("read-children-names");
        request.get("child-type").set(this.getName());
        request.get("address").set(TypeNode.getManagementAddress(this.getParent()));
        return request.toJSONString(true);
    }
}

