/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.views.server.extensions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.internal.view.servers.AbstractServerAction;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.ide.eclipse.as.ui.JBossServerUIPlugin;
import org.jboss.ide.eclipse.as.ui.Messages;
import org.jboss.ide.eclipse.as.ui.launch.JBTWebLaunchableClient;
import org.jboss.ide.eclipse.as.ui.views.server.extensions.CommonActionProviderUtils;

public abstract class AbstractOpenBrowserServerAction
extends CommonActionProvider {
    private ICommonActionExtensionSite actionSite;
    private OpenBrowserAction openURLAction;

    protected abstract String getActionText();

    protected abstract boolean accepts(IServer var1);

    protected abstract String getURL(IServer var1) throws CoreException;

    protected boolean shouldAddAction() {
        ICommonViewerSite site = this.actionSite.getViewSite();
        IStructuredSelection selection = null;
        if (site instanceof ICommonViewerWorkbenchSite) {
            ICommonViewerWorkbenchSite wsSite = (ICommonViewerWorkbenchSite)site;
            selection = (IStructuredSelection)wsSite.getSelectionProvider().getSelection();
        }
        return this.shouldAddForSelection(selection);
    }

    protected boolean shouldAddForSelection(IStructuredSelection sel) {
        IServer server = this.getSingleServer(sel);
        return server != null && ServerConverter.getJBossServer((IServer)server) != null;
    }

    protected IServer getSingleServer(IStructuredSelection sel) {
        if (sel.size() == 1 && sel.getFirstElement() instanceof IServer) {
            return (IServer)sel.getFirstElement();
        }
        return null;
    }

    public void init(ICommonActionExtensionSite site) {
        super.init(site);
        this.actionSite = site;
        this.createActions(site);
    }

    protected void createActions(ICommonActionExtensionSite site) {
        ICommonViewerWorkbenchSite commonViewerWorkbenchSite = CommonActionProviderUtils.getCommonViewerWorkbenchSite(site);
        if (commonViewerWorkbenchSite != null) {
            this.openURLAction = new OpenBrowserAction(commonViewerWorkbenchSite.getSelectionProvider());
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        if (this.shouldAddAction()) {
            CommonActionProviderUtils.addToShowInQuickSubMenu((IAction)this.openURLAction, menu, this.actionSite);
        }
    }

    private class OpenBrowserAction
    extends AbstractServerAction {
        public OpenBrowserAction(ISelectionProvider sp) {
            super(sp, AbstractOpenBrowserServerAction.this.getActionText());
            this.selectionChanged(this.getStructuredSelection());
        }

        public boolean accept(IServer server) {
            return AbstractOpenBrowserServerAction.this.accepts(server);
        }

        public void perform(IServer server) {
            try {
                String consoleUrl = AbstractOpenBrowserServerAction.this.getURL(server);
                JBTWebLaunchableClient.checkedCreateInternalBrowser(consoleUrl, server.getName(), "org.jboss.ide.eclipse.as.ui", JBossServerUIPlugin.getDefault().getLog());
            }
            catch (CoreException e) {
                Status status = new Status(4, "org.jboss.ide.eclipse.as.ui", e.getMessage(), (Throwable)e);
                JBossServerUIPlugin.log((IStatus)status);
                ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.ShowInAction_Error_Title, (String)NLS.bind((String)Messages.ShowInAction_Error, (Object)AbstractOpenBrowserServerAction.this.getActionText()), (IStatus)status);
            }
        }
    }
}

