/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.views.server.extensions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.IServerModule;
import org.jboss.ide.eclipse.as.core.Messages;
import org.jboss.ide.eclipse.as.core.extensions.events.ServerLogger;
import org.jboss.ide.eclipse.as.ui.JBossServerUISharedImages;

public class ModulePublishDecorator
implements ILightweightLabelDecorator {
    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void decorate(Object element, IDecoration decoration) {
        if (this.recentPublishFailed(element)) {
            ImageDescriptor id = JBossServerUISharedImages.getImageDescriptor("errorMarker");
            decoration.addOverlay(id, 2);
        }
    }

    protected boolean recentPublishFailed(Object element) {
        if (element instanceof IServerModule) {
            IServer s = ((IServerModule)element).getServer();
            IModule[] m = ((IServerModule)element).getModule();
            String name = m[m.length - 1].getName();
            if (s == null) {
                return false;
            }
            IStatus[] all = ServerLogger.getDefault().getLog(s);
            int i = all.length - 1;
            while (i >= 0) {
                String success = NLS.bind((String)Messages.ModulePublished, (Object)name);
                if (all[i].getMessage().equals(success)) {
                    return false;
                }
                String fail = NLS.bind((String)Messages.FullPublishFail, (Object)name);
                if (all[i].getMessage().equals(fail)) {
                    return true;
                }
                --i;
            }
        }
        return false;
    }
}

