/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.views.server.extensions;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerType;
import org.jboss.ide.eclipse.as.core.server.IJBossServer;
import org.jboss.ide.eclipse.as.core.server.internal.ExtendedServerPropertiesAdapterFactory;
import org.jboss.ide.eclipse.as.core.server.internal.JBossServer;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.ServerExtendedProperties;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.ide.eclipse.as.core.util.ServerUtil;
import org.jboss.ide.eclipse.as.ui.Messages;
import org.jboss.ide.eclipse.as.ui.views.server.extensions.AbstractOpenBrowserServerAction;

public class ShowInJMXConsoleActionProvider
extends AbstractOpenBrowserServerAction {
    private static final String CONSOLE_URL_PATTERN = "http://{0}:{1}/jmx-console";

    @Override
    protected String getActionText() {
        return Messages.ShowInJMXConsole_Action_Text;
    }

    @Override
    protected boolean shouldAddForSelection(IStructuredSelection sel) {
        IJBossServer jbs;
        IServer server = this.getSingleServer(sel);
        if (server != null && (jbs = ServerConverter.getJBossServer((IServer)server)) != null) {
            ServerExtendedProperties sep = ExtendedServerPropertiesAdapterFactory.getServerExtendedProperties((IServerAttributes)server);
            return ServerUtil.isJBossServerType((IServerType)server.getServerType()) && sep != null && sep.getFileStructure() == 1;
        }
        return false;
    }

    @Override
    protected boolean accepts(IServer server) {
        return server.getServerState() == 2;
    }

    @Override
    protected String getURL(IServer server) throws CoreException {
        JBossServer jbossServer = (JBossServer)ServerUtil.checkedGetServerAdapter((IServerAttributes)server, JBossServer.class);
        String host = jbossServer.getHost();
        int webPort = jbossServer.getJBossWebPort();
        String consoleUrl = MessageFormat.format((String)CONSOLE_URL_PATTERN, (Object[])new Object[]{host, String.valueOf(webPort)});
        return consoleUrl;
    }
}

