/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.wizards;

import java.io.File;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jboss.ide.eclipse.as.ui.Messages;
import org.jboss.ide.eclipse.as.ui.UIUtil;

public class CopyConfigurationDialog
extends TitleAreaDialog {
    private String origHome;
    private String origDest;
    private String origConfig;
    private String newDest;
    private String newConfig;
    private Text destText;

    protected CopyConfigurationDialog(Shell parentShell, String home, String dir, String config) {
        super(new Shell(parentShell));
        this.origHome = home;
        this.origDest = dir;
        this.origConfig = config;
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        Composite main = new Composite(c, 0);
        main.setLayoutData((Object)new GridData(1808));
        main.setLayout((Layout)new FormLayout());
        this.setCleanMessage();
        Label nameLabel = new Label(main, 0);
        nameLabel.setText(Messages.wf_NameLabel);
        final Text nameText = new Text(main, 2048);
        Label destLabel = new Label(main, 0);
        destLabel.setText(Messages.rwf_DestinationLabel);
        this.destText = new Text(main, 2048);
        Button browse = new Button(main, 8);
        browse.setText(Messages.browse);
        Point nameSize = new GC((Drawable)nameLabel).textExtent(nameLabel.getText());
        Point destSize = new GC((Drawable)destLabel).textExtent(destLabel.getText());
        Label wider = nameSize.x > destSize.x ? nameLabel : destLabel;
        nameText.setLayoutData((Object)UIUtil.createFormData2((Object)0, (int)13, null, (int)0, (Object)wider, (int)5, (Object)100, (int)-5));
        nameLabel.setLayoutData((Object)UIUtil.createFormData2((Object)0, (int)15, null, (int)0, (Object)0, (int)5, null, (int)0));
        this.destText.setLayoutData((Object)UIUtil.createFormData2((Object)nameText, (int)5, null, (int)0, (Object)wider, (int)5, (Object)browse, (int)-5));
        destLabel.setLayoutData((Object)UIUtil.createFormData2((Object)nameText, (int)7, null, (int)0, (Object)0, (int)5, null, (int)0));
        browse.setLayoutData((Object)UIUtil.createFormData2((Object)nameText, (int)5, null, (int)0, null, (int)0, (Object)100, (int)-5));
        nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CopyConfigurationDialog.this.newConfig = nameText.getText();
                CopyConfigurationDialog.this.validate();
            }
        });
        this.destText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CopyConfigurationDialog.this.newDest = CopyConfigurationDialog.this.destText.getText();
                CopyConfigurationDialog.this.validate();
            }
        });
        browse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                File directory;
                File file;
                Path p = new Path(CopyConfigurationDialog.this.newDest);
                if (!p.isAbsolute()) {
                    p = new Path(CopyConfigurationDialog.this.origHome).append(CopyConfigurationDialog.this.newDest);
                }
                if (!(file = p.toFile()).exists()) {
                    file = null;
                }
                if ((directory = CopyConfigurationDialog.getDirectory(file, CopyConfigurationDialog.this.getShell())) != null) {
                    Path newP = new Path(directory.getAbsolutePath());
                    Object result = newP.toOSString().startsWith(new Path(CopyConfigurationDialog.this.origHome).toOSString()) ? newP.removeFirstSegments(new Path(CopyConfigurationDialog.this.origHome).segmentCount()) : newP;
                    CopyConfigurationDialog.this.destText.setText(result.toString());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.destText.setText(this.origDest);
        nameText.setText(this.findNewest(String.valueOf(this.origConfig) + "_copy"));
        return c;
    }

    protected static File getDirectory(File startingDirectory, Shell shell) {
        String dir;
        DirectoryDialog fileDialog = new DirectoryDialog(shell, 4096);
        if (startingDirectory != null) {
            fileDialog.setFilterPath(startingDirectory.getPath());
        }
        if ((dir = fileDialog.open()) != null && (dir = dir.trim()).length() > 0) {
            return new File(dir);
        }
        return null;
    }

    public void validate() {
        boolean valid = false;
        Path p = null;
        if (this.newDest != null && this.newConfig != null) {
            p = new Path(this.newDest);
            if (!p.isAbsolute()) {
                p = new Path(this.origHome).append(this.newDest);
            }
            if (!p.append(this.newConfig).toFile().exists()) {
                valid = true;
            }
        }
        if (!valid) {
            if (this.newDest == null || this.newConfig == null) {
                this.setMessage(Messages.JBossRuntimeWizardFragment_AllFieldsRequired, 3);
            } else {
                this.setMessage(String.valueOf(Messages.JBossRuntimeWizardFragment_OutputFolderExists) + p.append(this.newConfig).toString(), 3);
            }
        } else {
            this.setCleanMessage();
        }
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(valid);
        }
    }

    protected void setCleanMessage() {
        this.setMessage(NLS.bind((String)Messages.rwf_CopyConfigLabel, (Object)this.origConfig, (Object)this.origDest));
    }

    protected String findNewest(String suggested) {
        Path p = new Path(this.origDest);
        if (!p.isAbsolute()) {
            p = new Path(this.origHome).append(this.origDest);
        }
        if (p.append(suggested).toFile().exists()) {
            int i = 1;
            while (p.append(String.valueOf(suggested) + i).toFile().exists()) {
                ++i;
            }
            return String.valueOf(suggested) + i;
        }
        return suggested;
    }

    protected Point getInitialSize() {
        return new Point(500, super.getInitialSize().y);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.JBossRuntimeWizardFragment_CopyAConfigShellText);
    }

    public String getNewDest() {
        return this.newDest;
    }

    public String getNewConfig() {
        return this.newConfig;
    }
}

