/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.wizards;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;
import org.jboss.ide.eclipse.as.ui.JBossServerUISharedImages;
import org.jboss.ide.eclipse.as.ui.Messages;

public class StrippedServerWizardFragment
extends WizardFragment {
    private IWizardHandle handle;
    private Label deployLabel;
    private Label tmpDeployLabel;
    private Text deployText;
    private Text tmpDeployText;
    private Button browse;
    private Button tmpBrowse;
    private String deployLoc;
    private String tmpDeployLoc;

    public Composite createComposite(Composite parent, IWizardHandle handle) {
        this.handle = handle;
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new FormLayout());
        this.deployLabel = new Label(main, 0);
        this.deployText = new Text(main, 2048);
        this.browse = new Button(main, 8);
        this.deployLabel.setText(Messages.swf_DeployDirectory);
        this.browse.setText(Messages.browse);
        this.tmpDeployLabel = new Label(main, 0);
        this.tmpDeployText = new Text(main, 2048);
        this.tmpBrowse = new Button(main, 8);
        this.tmpDeployLabel.setText(Messages.swf_TempDeployDirectory);
        this.tmpBrowse.setText(Messages.browse);
        FormData lData = new FormData();
        lData.top = new FormAttachment(0, 5);
        lData.left = new FormAttachment(0, 5);
        this.deployLabel.setLayoutData((Object)lData);
        FormData tData = new FormData();
        tData.top = new FormAttachment(0, 5);
        tData.left = new FormAttachment((Control)this.deployLabel, 5);
        tData.right = new FormAttachment((Control)this.browse, -5);
        this.deployText.setLayoutData((Object)tData);
        FormData bData = new FormData();
        bData.right = new FormAttachment(100, -5);
        bData.top = new FormAttachment(0, 5);
        this.browse.setLayoutData((Object)bData);
        lData = new FormData();
        lData.top = new FormAttachment((Control)this.deployText, 5);
        lData.left = new FormAttachment(0, 5);
        this.tmpDeployLabel.setLayoutData((Object)lData);
        tData = new FormData();
        tData.top = new FormAttachment((Control)this.deployText, 5);
        tData.left = new FormAttachment((Control)this.tmpDeployLabel, 5);
        tData.right = new FormAttachment((Control)this.tmpBrowse, -5);
        this.tmpDeployText.setLayoutData((Object)tData);
        bData = new FormData();
        bData.right = new FormAttachment(100, -5);
        bData.top = new FormAttachment((Control)this.deployText, 5);
        this.tmpBrowse.setLayoutData((Object)bData);
        ModifyListener ml = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StrippedServerWizardFragment.this.textChanged();
            }
        };
        this.browse.addSelectionListener((SelectionListener)new MySelectionListener(this.deployText));
        this.tmpBrowse.addSelectionListener((SelectionListener)new MySelectionListener(this.tmpDeployText));
        this.tmpDeployText.addModifyListener(ml);
        this.deployText.addModifyListener(ml);
        handle.setImageDescriptor(JBossServerUISharedImages.getImageDescriptor("jbossLogo"));
        return main;
    }

    protected void textChanged() {
        IStatus status = this.checkErrors();
        if (status.isOK()) {
            this.deployLoc = this.deployText.getText();
            this.tmpDeployLoc = this.tmpDeployText.getText();
            this.handle.setMessage("", 0);
            this.handle.update();
        } else {
            this.handle.setMessage(status.getMessage(), 2);
        }
    }

    protected IStatus checkErrors() {
        block17: {
            if (this.handle == null) {
                return Status.CANCEL_STATUS;
            }
            File f = new File(this.deployText.getText());
            if (!f.exists() || !f.isDirectory()) {
                return new Status(2, "org.jboss.ide.eclipse.as.ui", 0, Messages.StrippedServerWizardFragment_DeployFolderDoesNotExistStatusMessage, null);
            }
            f = new File(this.tmpDeployText.getText());
            if (!f.exists() || !f.isDirectory()) {
                return new Status(2, "org.jboss.ide.eclipse.as.ui", 0, Messages.StrippedServerWizardFragment_TemporaryDeployFolderDoesNotExistStatusMessage, null);
            }
            File dep1 = null;
            File tmp1 = null;
            boolean success = false;
            try {
                try {
                    tmp1 = File.createTempFile("org.jboss.ide.eclipse.as.ui", ".txt", new File(this.tmpDeployText.getText()));
                    dep1 = new Path(this.deployText.getText()).append("org.jboss.ide.eclipse.as.ui.txt").toFile();
                    success = tmp1.renameTo(dep1);
                }
                catch (IOException iOException) {
                    if (tmp1 != null && tmp1.exists()) {
                        tmp1.delete();
                    }
                    if (dep1 != null && dep1.exists()) {
                        dep1.delete();
                    }
                    if (!success) {
                        return new Status(4, "org.jboss.ide.eclipse.as.ui", 0, "Unable to rename files from your temporary folder to your deploy folder. Please verify both are on the same filesystem.", null);
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (tmp1 != null && tmp1.exists()) {
                    tmp1.delete();
                }
                if (dep1 != null && dep1.exists()) {
                    dep1.delete();
                }
                if (!success) {
                    return new Status(4, "org.jboss.ide.eclipse.as.ui", 0, "Unable to rename files from your temporary folder to your deploy folder. Please verify both are on the same filesystem.", null);
                }
                throw throwable;
            }
            if (tmp1 != null && tmp1.exists()) {
                tmp1.delete();
            }
            if (dep1 != null && dep1.exists()) {
                dep1.delete();
            }
            if (!success) {
                return new Status(4, "org.jboss.ide.eclipse.as.ui", 0, "Unable to rename files from your temporary folder to your deploy folder. Please verify both are on the same filesystem.", null);
            }
        }
        return new Status(0, "org.jboss.ide.eclipse.as.ui", 0, "", null);
    }

    private boolean isEditingServer() {
        Object o = this.getTaskModel().getObject("editing_server");
        return o != null && Boolean.TRUE.equals(o);
    }

    public void enter() {
        if (this.isEditingServer()) {
            this.handle.setTitle(Messages.sswf_Title_Edit);
        } else {
            this.handle.setTitle(Messages.sswf_Title);
        }
        IServer s = (IServer)this.getTaskModel().getObject("server");
        IServerWorkingCopy swc = s instanceof IServerWorkingCopy ? (IServerWorkingCopy)s : s.createWorkingCopy();
        String currentdeploy = swc.getAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectory", "");
        if (!currentdeploy.equals("")) {
            this.deployText.setText(currentdeploy);
        }
    }

    public void exit() {
        this.textChanged();
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
        IServer server = (IServer)this.getTaskModel().getObject("server");
        IServerWorkingCopy serverWC = null;
        serverWC = server instanceof IServerWorkingCopy ? (IServerWorkingCopy)server : server.createWorkingCopy();
        try {
            serverWC.setServerConfiguration(null);
            serverWC.setAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectory", this.deployLoc);
            serverWC.setAttribute("org.jboss.ide.eclipse.as.core.server.tempDeployDirectory", this.tmpDeployLoc);
            this.getTaskModel().putObject("server", (Object)serverWC);
        }
        catch (Exception exception) {}
    }

    public boolean isComplete() {
        return this.checkErrors().isOK();
    }

    public boolean hasComposite() {
        return true;
    }

    private class MySelectionListener
    implements SelectionListener {
        private Text text;

        public MySelectionListener(Text text) {
            this.text = text;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            DirectoryDialog d = new DirectoryDialog(new Shell());
            d.setFilterPath(this.text.getText());
            String x = d.open();
            if (x != null) {
                this.text.setText(x);
            }
        }
    }
}

