/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.archives.scanner.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.jboss.tools.archives.scanner.internal.SelectorUtils;

public class MatchPattern {
    private final String source;
    private final String regexPattern;
    private final String[] tokenized;
    private final char[][] tokenizedChar;

    private MatchPattern(String source, String separator) {
        this.regexPattern = SelectorUtils.isRegexPrefixedPattern(source) ? source.substring("%regex[".length(), source.length() - "]".length()) : null;
        this.source = SelectorUtils.isAntPrefixedPattern(source) ? source.substring("%ant[".length(), source.length() - "]".length()) : source;
        this.tokenized = MatchPattern.tokenizePathToString(this.source, separator);
        this.tokenizedChar = new char[this.tokenized.length][];
        int i = 0;
        while (i < this.tokenized.length) {
            this.tokenizedChar[i] = this.tokenized[i].toCharArray();
            ++i;
        }
    }

    boolean matchPath(String str, char[][] strDirs, boolean isCaseSensitive) {
        if (this.regexPattern != null) {
            return str.matches(this.regexPattern);
        }
        return SelectorUtils.matchAntPathPattern(this.getTokenizedPathChars(), strDirs, isCaseSensitive);
    }

    public boolean matchPatternStart(String str, boolean isCaseSensitive) {
        if (this.regexPattern != null) {
            return true;
        }
        String altStr = this.source.replace('\\', '/');
        return SelectorUtils.matchAntPathPatternStart(this, str, File.separator, isCaseSensitive) || SelectorUtils.matchAntPathPatternStart(this, altStr, "/", isCaseSensitive);
    }

    public String[] getTokenizedPathString() {
        return this.tokenized;
    }

    public char[][] getTokenizedPathChars() {
        return this.tokenizedChar;
    }

    public boolean startsWith(String string) {
        return this.source.startsWith(string);
    }

    public static String[] tokenizePathToString(String path, String separator) {
        ArrayList<String> ret = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(path, separator);
        while (st.hasMoreTokens()) {
            ret.add(st.nextToken());
        }
        return ret.toArray(new String[ret.size()]);
    }

    public static MatchPattern fromString(String source) {
        return new MatchPattern(source, File.separator);
    }
}

