/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.bean;

import java.io.File;
import org.jboss.ide.eclipse.as.core.server.bean.AbstractCondition;
import org.jboss.ide.eclipse.as.core.server.bean.JBossServerType;

public class ServerBeanTypeAS7
extends JBossServerType {
    private static final String JBAS7_RELEASE_VERSION = "JBossAS-Release-Version";

    protected ServerBeanTypeAS7() {
        super("AS", "JBoss Application Server", ServerBeanTypeAS7.asPath("modules", "org", "jboss", "as", "server", "main"), new String[]{"7.0", "7.1"}, new AS7ServerTypeCondition());
    }

    public static class AS7ServerTypeCondition
    extends AbstractCondition {
        @Override
        public boolean isServerRoot(File location) {
            String mainFolder = JBossServerType.AS7.systemJarPath;
            return ServerBeanTypeAS7.scanFolderJarsForManifestProp(location, mainFolder, ServerBeanTypeAS7.JBAS7_RELEASE_VERSION, "7.");
        }

        @Override
        public String getFullVersion(File location, File systemFile) {
            String mainFolder = JBossServerType.AS7.systemJarPath;
            return ServerBeanTypeAS7.getManifestPropFromFolderJars(location, mainFolder, ServerBeanTypeAS7.JBAS7_RELEASE_VERSION);
        }

        @Override
        public String getServerTypeId(String version) {
            if (version.equals("7.0")) {
                return "org.jboss.ide.eclipse.as.70";
            }
            if (version.equals("7.1")) {
                return "org.jboss.ide.eclipse.as.71";
            }
            if (version.equals("7.2")) {
                return "org.jboss.ide.eclipse.as.71";
            }
            return null;
        }
    }
}

