/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.internal.Messages;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.jboss.ide.eclipse.as.core.server.IModulePathFilter;
import org.jboss.ide.eclipse.as.core.server.IPublishCopyCallbackHandler;
import org.jboss.ide.eclipse.as.core.util.ModuleResourceUtil;
import org.jboss.ide.eclipse.as.core.util.ProgressMonitorUtil;

public final class PublishCopyUtil {
    private static final IStatus[] EMPTY_STATUS = new IStatus[0];
    private IPublishCopyCallbackHandler handler;

    public PublishCopyUtil(IPublishCopyCallbackHandler handler) {
        this.handler = handler;
    }

    protected IStatus[] canceledStatus() {
        return new IStatus[]{new Status(8, "org.jboss.ide.eclipse.as.wtp.core", "Publish Canceled")};
    }

    public IStatus[] publishDelta(IModuleResourceDelta[] delta, IProgressMonitor monitor) throws CoreException {
        return this.publishDelta(delta, null, monitor);
    }

    public IStatus[] publishDelta(IModuleResourceDelta[] delta, IModulePathFilter filter, IProgressMonitor monitor) throws CoreException {
        if (delta == null) {
            return EMPTY_STATUS;
        }
        monitor = ProgressMonitorUtil.getMonitorFor(monitor);
        ArrayList<IStatus> status = new ArrayList<IStatus>(2);
        int size2 = delta.length;
        int i = 0;
        while (i < size2) {
            IStatus[] stat = this.publishDelta(delta[i], (IPath)new Path("/"), filter, monitor);
            PublishCopyUtil.addArrayToList(status, stat);
            ++i;
        }
        return status.toArray(new IStatus[status.size()]);
    }

    @Deprecated
    public IStatus[] publishDelta(IModuleResourceDelta delta, IPath path, IProgressMonitor monitor) throws CoreException {
        return this.publishDelta(delta, path, null, monitor);
    }

    public IStatus[] publishDelta(IModuleResourceDelta delta, IPath path, IModulePathFilter filter, IProgressMonitor monitor) throws CoreException {
        IPath path2;
        IStatus[] stat;
        IPath path22;
        IStatus[] s;
        ArrayList<IStatus> status = new ArrayList<IStatus>(2);
        if (monitor.isCanceled()) {
            return this.canceledStatus();
        }
        IModuleResource resource = delta.getModuleResource();
        int kind2 = delta.getKind();
        if (resource instanceof IModuleFile) {
            IModuleFile file = (IModuleFile)resource;
            if (kind2 == 3) {
                IPath path23 = path.append(file.getModuleRelativePath()).append(file.getName());
                this.handler.deleteResource(path23, monitor);
            } else if (filter == null || filter.shouldInclude(resource)) {
                IPath path24 = path.append(file.getModuleRelativePath()).append(file.getName());
                this.handler.makeDirectoryIfRequired(path24.removeLastSegments(1), monitor);
                this.handler.copyFile(file, path24, monitor);
            }
            return status.toArray(new IStatus[status.size()]);
        }
        if (kind2 == 1 && (s = this.handler.makeDirectoryIfRequired(path22 = path.append(resource.getModuleRelativePath()).append(resource.getName()), monitor)) != null && s.length > 0 && !s[0].isOK()) {
            return s;
        }
        IModuleResourceDelta[] childDeltas = delta.getAffectedChildren();
        int size = childDeltas.length;
        int i = 0;
        while (i < size) {
            if (monitor.isCanceled()) {
                return this.canceledStatus();
            }
            stat = this.publishDelta(childDeltas[i], path, filter, monitor);
            PublishCopyUtil.addArrayToList(status, stat);
            ++i;
        }
        if (kind2 == 3 && (stat = this.handler.deleteResource(path2 = path.append(resource.getModuleRelativePath()).append(resource.getName()), monitor)).length > 0 && !stat[0].isOK()) {
            status.add((IStatus)new Status(4, "org.eclipse.wst.server.core", 1644298251, NLS.bind((String)Messages.errorDeleting, (Object)path2), null));
        }
        IStatus[] stat2 = new IStatus[status.size()];
        status.toArray(stat2);
        return stat2;
    }

    public IStatus[] initFullPublish(IModuleResource[] resources, IProgressMonitor monitor) throws CoreException {
        return this.initFullPublish(resources, null, monitor);
    }

    public IStatus[] initFullPublish(IModuleResource[] resources, IModulePathFilter filter, IProgressMonitor monitor) throws CoreException {
        int count = ModuleResourceUtil.countMembers(resources);
        monitor = ProgressMonitorUtil.getMonitorFor(monitor);
        monitor.beginTask("Publishing " + count + " resources", 100 * count + 200);
        this.handler.makeDirectoryIfRequired((IPath)new Path("/"), ProgressMonitorUtil.getSubMon(monitor, 100));
        if (monitor.isCanceled()) {
            return this.canceledStatus();
        }
        IStatus[] results = this.publishFull(resources, (IPath)new Path("/"), filter, monitor);
        monitor.done();
        return results;
    }

    protected IStatus[] publishFull(IModuleResource[] resources, IPath relative, IModulePathFilter filter, IProgressMonitor monitor) throws CoreException {
        if (resources == null) {
            return EMPTY_STATUS;
        }
        ArrayList<IStatus> status = new ArrayList<IStatus>(2);
        int size = resources.length;
        int i = 0;
        while (i < size) {
            if (monitor.isCanceled()) {
                return this.canceledStatus();
            }
            if (filter == null || filter.shouldInclude(resources[i])) {
                IStatus[] stat = this.copy(resources[i], relative, filter, monitor);
                PublishCopyUtil.addArrayToList(status, stat);
            }
            ++i;
        }
        return status.toArray(new IStatus[status.size()]);
    }

    protected IStatus[] publishFull(IModuleResource[] resources, IPath relative, IProgressMonitor monitor) throws CoreException {
        return this.publishFull(resources, relative, null, monitor);
    }

    private IStatus[] copy(IModuleResource resource, IPath path, IModulePathFilter filter, IProgressMonitor monitor) throws CoreException {
        String name = resource.getName();
        ArrayList<IStatus> status = new ArrayList<IStatus>(2);
        if (resource instanceof IModuleFolder) {
            IModuleFolder folder = (IModuleFolder)resource;
            IModuleResource[] children = folder.members();
            if (children.length == 0) {
                this.handler.makeDirectoryIfRequired(folder.getModuleRelativePath().append(folder.getName()), ProgressMonitorUtil.getSubMon(monitor, 5));
            } else {
                IStatus[] stat = this.publishFull(children, path, filter, monitor);
                PublishCopyUtil.addArrayToList(status, stat);
            }
        } else {
            IModuleFile mf = (IModuleFile)resource;
            if (filter == null || filter.shouldInclude(resource)) {
                IStatus[] stats = this.handler.makeDirectoryIfRequired((path = path.append(mf.getModuleRelativePath()).append(name)).removeLastSegments(1), (IProgressMonitor)new NullProgressMonitor());
                if (stats != null && stats.length > 0 && !stats[0].isOK()) {
                    PublishCopyUtil.addArrayToList(status, stats);
                }
                PublishCopyUtil.addArrayToList(status, this.handler.copyFile(mf, path, ProgressMonitorUtil.getSubMon(monitor, 100)));
            }
        }
        return status.toArray(new IStatus[status.size()]);
    }

    public static void addArrayToList(List<IStatus> list, IStatus[] a) {
        if (list == null || a == null || a.length == 0) {
            return;
        }
        int size = a.length;
        int i = 0;
        while (i < size) {
            list.add(a[i]);
            ++i;
        }
    }
}

