/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.actions;

import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.internal.view.servers.StartAction;
import org.jboss.ide.eclipse.as.ui.actions.AbstractServerActionDelegate;
import org.jboss.ide.eclipse.as.ui.actions.ServerActionMessages;
import org.jboss.ide.eclipse.as.ui.actions.ServerManager;

public class RunServerActionDelegate
extends AbstractServerActionDelegate {
    private StartAction delegate;

    @Override
    public void init(IWorkbenchWindow window) {
        super.init(window);
        this.update();
    }

    @Override
    protected void doRun() {
        IServer server = ServerManager.getInstance().getSelectedServer();
        if (server == null) {
            return;
        }
        this.delegate = new StartAction(this.window.getShell(), RunServerActionDelegate.getSelectionProvider(), this.getLaunchMode());
        if (this.delegate.accept(server)) {
            this.delegate.perform(server);
        }
        RunServerActionDelegate.updateAll();
    }

    protected String getLaunchMode() {
        return "run";
    }

    @Override
    protected boolean isActionEnabled() {
        IServer selected = ServerManager.getInstance().getSelectedServer();
        return selected != null && selected.getServerState() != 1;
    }

    @Override
    protected String computeToolTip() {
        String name;
        IServer selected = ServerManager.getInstance().getSelectedServer();
        String string = name = selected == null ? "" : selected.getName();
        if (selected != null && selected.getServerState() == 2) {
            return NLS.bind((String)ServerActionMessages.RESTART_IN_RUN_MODE, (Object)name);
        }
        return NLS.bind((String)ServerActionMessages.START_IN_RUN_MODE, (Object)name);
    }
}

