/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.editor;

import java.util.ArrayList;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledPageBook;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.command.ServerCommand;
import org.eclipse.wst.server.ui.internal.wizard.TaskWizard;
import org.eclipse.wst.server.ui.wizard.WizardFragment;
import org.jboss.ide.eclipse.as.core.Trace;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.JBossExtendedProperties;
import org.jboss.ide.eclipse.as.core.util.JBossServerBehaviorUtils;
import org.jboss.ide.eclipse.as.core.util.LaunchCommandPreferences;
import org.jboss.ide.eclipse.as.ui.FormUtils;
import org.jboss.ide.eclipse.as.ui.Messages;
import org.jboss.ide.eclipse.as.ui.editor.DeploymentTypeUIUtil;
import org.jboss.ide.eclipse.as.ui.editor.EditorExtensionManager;
import org.jboss.ide.eclipse.as.ui.editor.IDeploymentTypeUI;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ServerProfileModel;
import org.jboss.ide.eclipse.as.wtp.ui.util.FormDataUtility;

public class ServerModeSectionComposite
extends Composite {
    private ArrayList<DeployUIAdditions> deployAdditions;
    private Label profileLabel;
    private ScrolledPageBook preferencePageBook;
    private DeploymentTypeUIUtil.ServerEditorUICallback callback;
    private Button listenOnAllHosts;
    private Button exposeManagement;
    private Button executeShellScripts;
    protected Link configureProfileLink;
    private DeployUIAdditions currentUIAddition;
    private IManagedForm form;

    public ServerModeSectionComposite(Composite parent, int style, DeploymentTypeUIUtil.ServerEditorUICallback callback) {
        this(parent, style, callback, null);
    }

    public ServerModeSectionComposite(Composite parent, int style, DeploymentTypeUIUtil.ServerEditorUICallback callback, IManagedForm form) {
        super(parent, style);
        this.callback = callback;
        this.form = form;
        this.loadDeployTypeData();
        FormToolkit toolkit = new FormToolkit(this.getDisplay());
        FormUtils.adaptFormCompositeRecursively(this, toolkit);
        this.setLayout((Layout)new FormLayout());
        Link top = null;
        this.configureProfileLink = new Link((Composite)this, 0);
        FormData fd = FormDataUtility.createFormData2(top, (int)5, null, (int)0, (Object)0, (int)5, null, (int)0);
        this.configureProfileLink.setLayoutData((Object)fd);
        this.profileLabel = new Label((Composite)this, 8);
        fd = FormDataUtility.createFormData2(top, (int)5, null, (int)0, (Object)this.configureProfileLink, (int)5, (Object)0, (int)400);
        this.profileLabel.setLayoutData((Object)fd);
        String profName = this.getCurrentProfileName();
        this.configureProfileLink.setText("<a href=\"\">Behavior Profile:</a>   ");
        this.configureProfileLink.addListener(13, this.createConfigureListener());
        this.profileLabel.setText(profName == null ? "Not Found" : profName);
        top = this.configureProfileLink;
        if (this.showExecuteShellCheckbox()) {
            this.executeShellScripts = new Button((Composite)this, 32);
            this.executeShellScripts.setText(Messages.EditorDoNotLaunch);
            fd = FormDataUtility.createFormData2((Object)top, (int)5, null, (int)0, (Object)0, (int)5, null, (int)0);
            this.executeShellScripts.setLayoutData((Object)fd);
            top = this.executeShellScripts;
            this.executeShellScripts.setSelection(LaunchCommandPreferences.isIgnoreLaunchCommand((IServerAttributes)callback.getServer()));
            this.executeShellScripts.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ServerModeSectionComposite.this.executeShellToggled();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        if (this.showListenOnAllHostsCheckbox()) {
            this.listenOnAllHosts = new Button((Composite)this, 32);
            this.listenOnAllHosts.setText(Messages.EditorListenOnAllHosts);
            fd = FormDataUtility.createFormData2((Object)(top == null ? Integer.valueOf(0) : top), (int)5, null, (int)0, (Object)0, (int)5, null, (int)0);
            this.listenOnAllHosts.setLayoutData((Object)fd);
            top = this.listenOnAllHosts;
            this.listenOnAllHosts.setSelection(LaunchCommandPreferences.listensOnAllHosts((IServerAttributes)callback.getServer()));
            this.listenOnAllHosts.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ServerModeSectionComposite.this.listenOnAllHostsToggled();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        if (this.showExposeManagementCheckbox()) {
            this.exposeManagement = new Button((Composite)this, 32);
            this.exposeManagement.setText(Messages.EditorExposeManagement);
            fd = FormDataUtility.createFormData2((Object)(top == null ? Integer.valueOf(0) : top), (int)5, null, (int)0, (Object)0, (int)5, null, (int)0);
            this.exposeManagement.setLayoutData((Object)fd);
            top = this.exposeManagement;
            this.exposeManagement.setSelection(LaunchCommandPreferences.exposesManagement((IServerAttributes)callback.getServer()));
            this.exposeManagement.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ServerModeSectionComposite.this.exposeManagementToggled();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        this.preferencePageBook = toolkit.createPageBook((Composite)this, 0x800080);
        this.preferencePageBook.setLayoutData((Object)FormDataUtility.createFormData2((Object)top, (int)5, (Object)0, (int)300, (Object)0, (int)5, (Object)100, (int)-5));
        this.updateProfilePagebook();
    }

    protected void executeShellToggled() {
        this.callback.execute((IUndoableOperation)new ChangeServerPropertyCommand(this.callback.getServer(), "org.jboss.ide.eclipse.as.core.server.IGNORE_LAUNCH_COMMANDS", new Boolean(this.executeShellScripts.getSelection()).toString(), Messages.EditorDoNotLaunchCommand));
    }

    protected String getCurrentProfileId() {
        IServer original = this.callback.getServer().getOriginal();
        IControllableServerBehavior ds = original == null ? null : JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)this.callback.getServer().getOriginal());
        String currentProfileId = null;
        if (ds != null) {
            currentProfileId = ServerProfileModel.getProfile((IServerAttributes)this.callback.getServer());
        }
        return currentProfileId;
    }

    protected String getCurrentProfileName() {
        String id;
        String currentProfileName = id = this.getCurrentProfileId();
        if (id != null) {
            ServerProfileModel.ServerProfile sp = ServerProfileModel.getDefault().getProfile(this.callback.getServer().getServerType().getId(), id);
            currentProfileName = sp == null ? id : sp.getVisibleName();
        }
        return currentProfileName;
    }

    protected Listener createConfigureListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                ServerModeSectionComposite.this.configurePressed();
            }
        };
    }

    protected WizardFragment createRootConfigureFragment() {
        return ServerUIPlugin.getWizardFragment((String)this.callback.getServer().getServerType().getId());
    }

    private void configurePressed() {
        block3: {
            TaskModel tm = new TaskModel();
            tm.putObject("server", (Object)this.callback.getServer());
            tm.putObject("editing_server", (Object)Boolean.TRUE);
            final boolean[] closed = new boolean[]{false};
            IServerWorkingCopy s = this.callback.getServer();
            IServer s2 = s.getOriginal();
            final IEditorSite site = this.callback.getPart().getEditorSite();
            TaskWizard tw = new TaskWizard("Configure Server Profile", this.createRootConfigureFragment(), tm){

                public boolean performFinish() {
                    if (site instanceof MultiPageEditorSite) {
                        MultiPageEditorPart mpep = ((MultiPageEditorSite)site).getMultiPageEditor();
                        closed[0] = site.getPage().closeEditor((IEditorPart)mpep, false);
                    }
                    return super.performFinish();
                }
            };
            WizardDialog wd = new WizardDialog(this.profileLabel.getShell(), (IWizard)tw);
            wd.open();
            if (closed[0] && site instanceof MultiPageEditorSite) {
                try {
                    ServerUIPlugin.editServer((IServer)s2);
                }
                catch (Exception e) {
                    if (!Trace.SEVERE) break block3;
                    Trace.trace((String)"/severe", (String)"Error editing element", (Throwable)e);
                }
            }
        }
    }

    public IDeploymentTypeUI getCurrentBehaviourUI() {
        return this.currentUIAddition.getUI();
    }

    protected String getDefaultServerMode() {
        return "local";
    }

    protected String getDefaultLocalServerMode() {
        return this.getDefaultServerMode();
    }

    protected String getDefaultRemoteServerMode() {
        return "rse";
    }

    protected boolean showExecuteShellCheckbox() {
        return true;
    }

    protected boolean showListenOnAllHostsCheckbox() {
        JBossExtendedProperties props = this.getExtendedProperties();
        return props == null ? false : props.runtimeSupportsBindingToAllInterfaces();
    }

    protected boolean showExposeManagementCheckbox() {
        JBossExtendedProperties props = this.getExtendedProperties();
        return props == null ? false : props.runtimeSupportsExposingManagement();
    }

    protected JBossExtendedProperties getExtendedProperties() {
        IServerWorkingCopy wc = this.callback.getServer();
        JBossExtendedProperties props = (JBossExtendedProperties)wc.loadAdapter(JBossExtendedProperties.class, (IProgressMonitor)new NullProgressMonitor());
        return props;
    }

    protected void listenOnAllHostsToggled() {
        this.callback.execute((IUndoableOperation)new ChangeServerPropertyCommand(this.callback.getServer(), "org.jboss.ide.eclipse.as.core.server.LISTEN_ON_ALL_HOSTS", new Boolean(this.listenOnAllHosts.getSelection()).toString(), Messages.EditorListenOnAllHostsCommand));
    }

    protected void exposeManagementToggled() {
        this.callback.execute((IUndoableOperation)new ChangeServerPropertyCommand(this.callback.getServer(), "org.jboss.ide.eclipse.as.core.server.EXPOSE_MANAGEMENT_SERVICE", new Boolean(this.exposeManagement.getSelection()).toString(), Messages.EditorExposeManagementCommand));
    }

    private void loadDeployTypeData() {
        String[] stringArray;
        String currentProfileId = this.getCurrentProfileId();
        this.deployAdditions = new ArrayList();
        if (currentProfileId == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = currentProfileId;
        }
        String[] supported = stringArray;
        String serverType = this.callback.getServer().getServerType().getId();
        int i = 0;
        while (i < supported.length) {
            IDeploymentTypeUI ui = EditorExtensionManager.getDefault().getPublishPreferenceUI(supported[i]);
            ServerProfileModel.ServerProfile sp = ServerProfileModel.getDefault().getProfile(serverType, supported[i]);
            String name = sp == null ? supported[i] : (sp.getVisibleName() == null ? sp.getId() : sp.getVisibleName());
            this.deployAdditions.add(new DeployUIAdditions(name, supported[i], ui));
            ++i;
        }
        this.currentUIAddition = this.deployAdditions.size() > 0 ? this.deployAdditions.get(0) : null;
    }

    private void updateProfilePagebook() {
        if (this.currentUIAddition != null) {
            if (!this.currentUIAddition.isRegistered()) {
                Composite newRoot = this.preferencePageBook.createPage((Object)this.currentUIAddition);
                this.currentUIAddition.createComposite(newRoot);
            }
            this.preferencePageBook.showPage((Object)this.currentUIAddition);
            Control page = this.preferencePageBook.getCurrentPage();
            if (this.form != null) {
                Point point = page.computeSize(-1, -1, true);
                FormData data = (FormData)this.preferencePageBook.getLayoutData();
                data.bottom = new FormAttachment(0, point.x - 50);
                this.form.getForm().layout(true, true);
                this.form.getForm().reflow(true);
            }
        }
    }

    private boolean shouldChangeDefaultDeployType(IServerWorkingCopy server) {
        return !server.getServerType().getId().equals("org.jboss.ide.eclipse.as.systemCopyServer");
    }

    public static class ChangeServerPropertyCommand
    extends ServerCommand {
        private IServerWorkingCopy server;
        private String key;
        private String oldVal;
        private String newVal;

        public ChangeServerPropertyCommand(IServerWorkingCopy server, String key, String val, String commandName) {
            this(server, key, val, "local", commandName);
        }

        public ChangeServerPropertyCommand(IServerWorkingCopy server, String key, String val, String oldDefault, String commandName) {
            super(server, commandName);
            this.server = server;
            this.key = key;
            this.newVal = val;
            this.oldVal = server.getAttribute(key, oldDefault);
        }

        public void execute() {
            this.server.setAttribute(this.key, this.newVal);
        }

        public void undo() {
            this.server.setAttribute(this.key, this.oldVal);
        }
    }

    private class DeployUIAdditions {
        private String behaviourName;
        private String behaviourId;
        private IDeploymentTypeUI ui;
        private boolean registered = false;

        public DeployUIAdditions(String name, String id, IDeploymentTypeUI ui) {
            this.behaviourName = name;
            this.behaviourId = id;
            this.ui = ui;
        }

        public IDeploymentTypeUI getUI() {
            return this.ui;
        }

        public boolean isRegistered() {
            return this.registered;
        }

        public void createComposite(Composite parent) {
            if (this.ui != null) {
                this.ui.fillComposite(parent, ServerModeSectionComposite.this.callback);
                this.registered = true;
            } else {
                parent.setLayout((Layout)new FillLayout());
                Composite child = new Composite(parent, 0);
                child.setLayout((Layout)new FormLayout());
            }
        }
    }
}

