/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.subsystems.internal;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.ide.eclipse.as.core.util.JBossServerBehaviorUtils;
import org.jboss.ide.eclipse.as.core.util.RemotePath;
import org.jboss.ide.eclipse.as.ui.actions.ExploreUtils;
import org.jboss.ide.eclipse.as.ui.subsystems.IExploreBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.AbstractSubsystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IControllableServerBehavior;
import org.jboss.tools.as.core.server.controllable.systems.IDeploymentOptionsController;
import org.jboss.tools.as.core.server.controllable.systems.IModuleDeployPathController;

public class LocalExploreBehavior
extends AbstractSubsystemController
implements IExploreBehavior {
    @Override
    public boolean canExplore(IServer server, IModule[] module) {
        if (module != null) {
            return this.canExploreModule(server, module);
        }
        return this.canExploreServer(server);
    }

    @Override
    public void openExplorer(IServer server, IModule[] module) {
        if (module != null) {
            this.runExploreModuleServer(server, module);
        } else {
            this.runExploreServer(server);
        }
    }

    private void runExploreServer(IServer server) {
        String deployDirectory = this.getDeployDirectory(server);
        if (deployDirectory != null && deployDirectory.length() > 0) {
            ExploreUtils.explore(deployDirectory);
        }
    }

    private void runExploreModuleServer(IServer server, IModule[] module) {
        File file;
        IPath path = this.getPath(server, module);
        if (path != null && (file = path.toFile()).exists()) {
            ExploreUtils.explore(file.getAbsolutePath());
        }
    }

    private String getDeployDirectory(IServer server) {
        IPath serverPath = this.getPath(server, null);
        if (serverPath != null) {
            return serverPath.toOSString();
        }
        String ret = server.getAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectory", null);
        if (ret != null) {
            return ret.trim();
        }
        IRuntime rt = server.getRuntime();
        if (rt != null) {
            return rt.getLocation().toString();
        }
        return null;
    }

    private boolean canExploreServer(IServer server) {
        String deployDirectory = this.getDeployDirectory(server);
        if (deployDirectory == null || deployDirectory.length() <= 0 && new File(deployDirectory).exists()) {
            return false;
        }
        return ExploreUtils.getExploreCommand() != null;
    }

    public boolean canExploreModule(IServer server, IModule[] modules) {
        IPath p = this.getPath(server, modules);
        return p != null && p.toFile().exists() && ExploreUtils.getExploreCommand() != null;
    }

    private IPath getPath(IServer server, IModule[] module) {
        try {
            IPath p = null;
            IControllableServerBehavior cs = JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)server);
            if (module == null) {
                IDeploymentOptionsController controller = (IDeploymentOptionsController)cs.getController("deploymentOptions");
                p = new RemotePath(controller.getDeploymentsRootFolder(true), controller.getPathSeparatorCharacter());
            } else {
                IModuleDeployPathController controller = (IModuleDeployPathController)cs.getController("moduleDeployPath");
                p = controller.getDeployDirectory(module);
            }
            return p;
        }
        catch (CoreException coreException) {
            return null;
        }
    }
}

