/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.modules;

import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.publishers.patterns.ModuleDirectoryScannerPathFilter;
import org.jboss.ide.eclipse.as.core.server.IModulePathFilter;
import org.jboss.ide.eclipse.as.wtp.core.util.ServerModelUtilities;

public class ResourceModuleResourceUtil {
    public static final String COMPONENT_INCLUSIONS_PATTERN = "component.inclusion.patterns";
    public static final String COMPONENT_EXCLUSIONS_PATTERN = "component.exclusion.patterns";
    private static final String ALL_RESOURCES_PATTERN = "**";

    public static IModuleResource[] getFilteredMembers(IModule module, String inc, String exc) throws CoreException {
        ModuleDirectoryScannerPathFilter filter = new ModuleDirectoryScannerPathFilter(module, inc, exc);
        return filter.getFilteredMembers();
    }

    public static IModulePathFilter findDefaultModuleFilter(IModule module) {
        if (ServerModelUtilities.isBinaryModule((IModule)module)) {
            return null;
        }
        String[] incExc = ResourceModuleResourceUtil.getProjectIncludesExcludes(module);
        String inclusionPatterns = incExc[0];
        String exclusionPatterns = incExc[1];
        if (exclusionPatterns == null && (inclusionPatterns == null || ALL_RESOURCES_PATTERN.equals(inclusionPatterns))) {
            return null;
        }
        try {
            ModuleDirectoryScannerPathFilter filter = new ModuleDirectoryScannerPathFilter(module, inclusionPatterns, exclusionPatterns);
            return filter;
        }
        catch (CoreException ce) {
            JBossServerCorePlugin.getDefault().getLog().log(ce.getStatus());
            return null;
        }
    }

    private static String[] getProjectIncludesExcludes(IModule module) {
        IVirtualComponent vc;
        IProject p = module.getProject();
        if (p != null && (vc = ComponentCore.createComponent((IProject)p)) != null) {
            Properties props = vc.getMetaProperties();
            String exclusionPatterns = ResourceModuleResourceUtil.getPatternValue(props, COMPONENT_EXCLUSIONS_PATTERN);
            String inclusionPatterns = ResourceModuleResourceUtil.getPatternValue(props, COMPONENT_INCLUSIONS_PATTERN);
            return new String[]{inclusionPatterns, exclusionPatterns};
        }
        return new String[2];
    }

    private static String getPatternValue(Properties props, String propertyName) {
        String value = props.getProperty(propertyName);
        if (value != null && (value = value.trim()).length() == 0) {
            value = null;
        }
        return value;
    }
}

