/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntryResolver;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;

public class RunJarContainerWrapper {
    public static final String ID = "org.jboss.ide.eclipse.as.core.server.launch.runJarContainer";
    public static final String RESOLVER_ID = "org.jboss.ide.eclipse.as.core.server.launch.runJarContainer.resolver";

    public static class RunJarContainer
    implements IClasspathContainer {
        protected IPath path;

        public RunJarContainer(IPath path) {
            this.path = path;
        }

        public RunJarContainer(String serverName) {
            this(new Path(RunJarContainerWrapper.ID).append(serverName));
        }

        public IClasspathEntry[] getClasspathEntries() {
            String name = this.path.segment(1);
            return RunJarContainer.getClasspathEntries(name);
        }

        public static IClasspathEntry[] getClasspathEntries(String serverName) {
            IServer[] servers = ServerCore.getServers();
            IServer s = null;
            int i = 0;
            while (i < servers.length) {
                if (servers[i].getName().equals(serverName)) {
                    s = servers[i];
                }
                ++i;
            }
            if (s != null) {
                IRuntime rt = s.getRuntime();
                IPath home = rt.getLocation();
                IPath runJar = home.append("bin/run.jar");
                return new IClasspathEntry[]{JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)runJar).getClasspathEntry()};
            }
            return new IClasspathEntry[0];
        }

        public String getDescription() {
            return null;
        }

        public int getKind() {
            return 1;
        }

        public IPath getPath() {
            return this.path;
        }
    }

    public static class RunJarContainerInitializer
    extends ClasspathContainerInitializer {
        public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
            RunJarContainer container = new RunJarContainer(containerPath);
            JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{container}, null);
        }
    }

    public static class RunJarResolver
    implements IRuntimeClasspathEntryResolver {
        public IRuntimeClasspathEntry[] resolveRuntimeClasspathEntry(IRuntimeClasspathEntry entry, ILaunchConfiguration configuration) throws CoreException {
            IPath p = entry.getPath();
            IClasspathEntry[] entries = new RunJarContainer(p).getClasspathEntries();
            IRuntimeClasspathEntry[] rtEntries = new IRuntimeClasspathEntry[entries.length];
            int i = 0;
            while (i < entries.length) {
                rtEntries[i] = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)entries[i].getPath());
                ++i;
            }
            return rtEntries;
        }

        public IRuntimeClasspathEntry[] resolveRuntimeClasspathEntry(IRuntimeClasspathEntry entry, IJavaProject project) throws CoreException {
            return null;
        }

        public IVMInstall resolveVMInstall(IClasspathEntry entry) throws CoreException {
            return null;
        }
    }
}

