/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal.v7;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.Messages;
import org.jboss.ide.eclipse.as.core.server.IServerStatePoller;
import org.jboss.ide.eclipse.as.core.server.IServerStatePoller2;
import org.jboss.ide.eclipse.as.core.server.IServerStatePollerType;
import org.jboss.ide.eclipse.as.core.server.internal.v7.JBoss7Server;
import org.jboss.ide.eclipse.as.core.server.v7.management.AS7ManagementDetails;
import org.jboss.ide.eclipse.as.management.core.IAS7ManagementDetails;
import org.jboss.ide.eclipse.as.management.core.IJBoss7ManagerService;
import org.jboss.ide.eclipse.as.management.core.JBoss7ManagerUtil;
import org.jboss.ide.eclipse.as.management.core.JBoss7ManangerConnectException;
import org.jboss.ide.eclipse.as.management.core.JBoss7ManangerException;
import org.jboss.ide.eclipse.as.management.core.JBoss7ServerState;

public class JBoss7ManagerServicePoller
implements IServerStatePoller2 {
    public static final String POLLER_ID = "org.jboss.ide.eclipse.as.core.server.JBoss7ManagerServicePoller";
    public static final String WILDFLY_POLLER_ID = "org.jboss.ide.eclipse.as.core.server.Wildfly8ManagerServicePoller";
    private static final int SYNCHRONOUS_POLL_FAST_TIMEOUT = 800;
    private IServer server;
    private AS7ManagementDetails managementDetails;
    private IServerStatePollerType type;
    private boolean expectedState;
    private IJBoss7ManagerService service;
    private boolean done = false;
    private boolean canceled = false;
    private IServerStatePoller.PollingException pollingException = null;
    private IServerStatePoller.RequiresInfoException requiresInfoException = null;
    private List<String> requiredProperties = null;
    private Properties requiredPropertiesReturned = null;

    public void beginPolling(IServer server, boolean expectedState) throws IServerStatePoller.PollingException {
        try {
            this.service = JBoss7ManagerUtil.getService((IServer)server);
            this.server = server;
            this.managementDetails = this.createManagementDetails();
            this.expectedState = expectedState;
            this.launchPollingThread();
        }
        catch (JBoss7ManangerException e) {
            throw new IServerStatePoller.PollingException(NLS.bind((String)Messages.CouldNotBeginPolling, (Object)server.getName()), (Throwable)e);
        }
    }

    private AS7ManagementDetails createManagementDetails() {
        return new AS7ManagementDetails(this.server){

            @Override
            public String[] handleCallbacks(String[] prompts) {
                return JBoss7ManagerServicePoller.this.handleAsynchCallbacks(prompts);
            }
        };
    }

    private synchronized void setRequiredProperties(List<String> props) {
        this.requiredProperties = props;
    }

    private synchronized void setRequiredInfoException(IServerStatePoller.RequiresInfoException e) {
        this.requiresInfoException = e;
    }

    private synchronized void setPollingException(IServerStatePoller.PollingException e) {
        this.pollingException = e;
    }

    private synchronized Properties getRequiredPropertiesReturned() {
        return this.requiredPropertiesReturned;
    }

    private synchronized boolean getDone() {
        return this.done;
    }

    private synchronized void setDone(boolean done) {
        this.done = done;
    }

    private synchronized boolean getCanceled() {
        return this.canceled;
    }

    private String[] handleAsynchCallbacks(String[] prompts) {
        if (this.getRequiredPropertiesReturned() == null) {
            ArrayList<String> tmp = new ArrayList<String>();
            tmp.addAll(Arrays.asList(prompts));
            this.setRequiredProperties(tmp);
            IServerStatePoller.RequiresInfoException e2 = new IServerStatePoller.RequiresInfoException("Requires proper credentials");
            this.setRequiredInfoException(e2);
            while (!this.getDone() && !this.getCanceled() && this.getRequiredPropertiesReturned() == null) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.getDone() || this.getCanceled()) {
            return new String[0];
        }
        String[] retPrompts = new String[prompts.length];
        int i = 0;
        while (i < retPrompts.length) {
            retPrompts[i] = (String)this.getRequiredPropertiesReturned().get(prompts[i]);
            ++i;
        }
        this.setRequiredInfoException(null);
        this.setRequiredProperties(null);
        return retPrompts;
    }

    public IServerStatePollerType getPollerType() {
        return this.type;
    }

    public void setPollerType(IServerStatePollerType type) {
        this.type = type;
    }

    public IServer getServer() {
        return this.server;
    }

    public synchronized boolean isComplete() throws IServerStatePoller.PollingException, IServerStatePoller.RequiresInfoException {
        if (this.pollingException != null) {
            throw this.pollingException;
        }
        if (this.requiresInfoException != null) {
            throw this.requiresInfoException;
        }
        return this.done;
    }

    public synchronized boolean getState() throws IServerStatePoller.PollingException, IServerStatePoller.RequiresInfoException {
        if (this.done) {
            return this.expectedState;
        }
        return !this.expectedState;
    }

    public void launchPollingThread() {
        new Thread(){

            @Override
            public void run() {
                JBoss7ManagerServicePoller.this.runLoop();
            }
        }.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runLoop() {
        try {
            while (!this.getDone()) {
                if (this.getCanceled()) {
                    return;
                }
                if (!this.expectedState) {
                    this.setDone(this.checkShutdown(this.service));
                } else {
                    this.setDone(this.checkRunning(this.service));
                }
                if (this.getDone()) continue;
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return;
        }
        catch (Exception e) {
            this.setPollingException(new IServerStatePoller.PollingException(e.getMessage()));
        }
    }

    private boolean checkRunning(IJBoss7ManagerService service) {
        try {
            JBoss7ServerState serverState = null;
            serverState = service.getServerState((IAS7ManagementDetails)this.managementDetails);
            return serverState == JBoss7ServerState.RUNNING;
        }
        catch (Exception e) {
            Throwable root = this.getRootException(e);
            if (root != null && root.getMessage() != null && root.getMessage().startsWith("Authentication failed:")) {
                this.provideCredentials(null);
            }
            return false;
        }
    }

    private Throwable getRootException(Throwable e) {
        Throwable cause = e.getCause();
        if (cause != e && cause != null) {
            return this.getRootException(cause);
        }
        return cause == null ? e : cause;
    }

    private boolean checkShutdown(IJBoss7ManagerService service) {
        try {
            service.getServerState((IAS7ManagementDetails)this.managementDetails);
            return false;
        }
        catch (JBoss7ManangerConnectException jBoss7ManangerConnectException) {
            return true;
        }
        catch (Exception exception) {
            return true;
        }
    }

    public void cleanup() {
        JBoss7ManagerUtil.dispose((IJBoss7ManagerService)this.service);
    }

    public synchronized List<String> getRequiredProperties() {
        return this.requiredProperties == null ? new ArrayList() : this.requiredProperties;
    }

    public synchronized void provideCredentials(Properties properties) {
        this.requiredPropertiesReturned = properties;
    }

    public synchronized void cancel(int type) {
        this.canceled = true;
    }

    public int getTimeoutBehavior() {
        return 2;
    }

    public IStatus getCurrentStateSynchronous(final IServer server) {
        final boolean[] callbacksCalled = new boolean[]{false};
        try {
            Boolean result = (Boolean)JBoss7ManagerUtil.executeWithService((JBoss7ManagerUtil.IServiceAware)new JBoss7ManagerUtil.IServiceAware<Boolean>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Boolean execute(IJBoss7ManagerService service) throws Exception {
                    try {
                        JBoss7ServerState state = service.getServerState((IAS7ManagementDetails)JBoss7ManagerServicePoller.this.createSynchronousManagementDetails(server, callbacksCalled));
                        return state == JBoss7ServerState.RUNNING;
                    }
                    catch (Exception exception) {
                        boolean[] blArray = callbacksCalled;
                        synchronized (callbacksCalled) {
                            // ** MonitorExit[var2_3] (shouldn't be in output)
                            return callbacksCalled[0];
                        }
                    }
                }
            }, (IServer)server);
            if (result.booleanValue()) {
                Status s = new Status(0, "org.jboss.ide.eclipse.as.core", "A JBoss 7 Management Service on " + server.getHost() + ", port " + this.getManagementPort(server) + " has responded that the server is completely started.");
                return s;
            }
            Status s = new Status(1, "org.jboss.ide.eclipse.as.core", "A JBoss 7 Management Service on " + server.getHost() + ", port " + this.getManagementPort(server) + " has responded that the server is not completely started.");
            return s;
        }
        catch (Exception e) {
            Status s = new Status(1, "org.jboss.ide.eclipse.as.core", "An attempt to reach the JBoss 7 Management Service on host " + server.getHost() + " and port " + this.getManagementPort(server) + " has resulted in an exception", (Throwable)e);
            return s;
        }
    }

    private AS7ManagementDetails createSynchronousManagementDetails(IServer server, final boolean[] callbacksCalled) {
        HashMap<String, Integer> props = new HashMap<String, Integer>();
        props.put("PROPERTY_TIMEOUT", new Integer(800));
        return new AS7ManagementDetails(server, props){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] handleCallbacks(String[] prompts) throws UnsupportedOperationException {
                boolean[] blArray = callbacksCalled;
                synchronized (callbacksCalled) {
                    callbacksCalled[0] = true;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    throw new UnsupportedOperationException();
                }
            }
        };
    }

    private int getManagementPort(IServer server) {
        if (server != null) {
            JBoss7Server jbossServer = (JBoss7Server)server.loadAdapter(JBoss7Server.class, (IProgressMonitor)new NullProgressMonitor());
            return jbossServer.getManagementPort();
        }
        return 9999;
    }
}

