/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.core.server.controllable.subsystems.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.Messages;
import org.jboss.ide.eclipse.as.core.Trace;
import org.jboss.ide.eclipse.as.core.extensions.events.ServerLogger;
import org.jboss.ide.eclipse.as.core.modules.ResourceModuleResourceUtil;
import org.jboss.ide.eclipse.as.core.publishers.JSTPublisherXMLToucher;
import org.jboss.ide.eclipse.as.core.publishers.PublishUtil;
import org.jboss.ide.eclipse.as.core.server.IModulePathFilter;
import org.jboss.ide.eclipse.as.core.server.IModulePathFilterProvider;
import org.jboss.ide.eclipse.as.core.server.internal.UpdateModuleStateJob;
import org.jboss.ide.eclipse.as.core.server.internal.v7.DeploymentMarkerUtils;
import org.jboss.ide.eclipse.as.core.util.ModuleResourceUtil;
import org.jboss.ide.eclipse.as.core.util.ProgressMonitorUtil;
import org.jboss.ide.eclipse.as.core.util.RemotePath;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.AbstractSubsystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IFilesystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IModuleStateController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IPrimaryPublishController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IPublishController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IPublishControllerDelegate;
import org.jboss.ide.eclipse.as.wtp.core.server.publish.LocalZippedModulePublishRunner;
import org.jboss.ide.eclipse.as.wtp.core.server.publish.PublishModuleFullRunner;
import org.jboss.ide.eclipse.as.wtp.core.server.publish.PublishModuleIncrementalRunner;
import org.jboss.ide.eclipse.as.wtp.core.util.ServerModelUtilities;
import org.jboss.tools.as.core.server.controllable.systems.IDeploymentOptionsController;
import org.jboss.tools.as.core.server.controllable.systems.IModuleDeployPathController;
import org.jboss.tools.as.core.server.controllable.systems.IModuleRestartBehaviorController;
import org.jboss.tools.as.core.server.controllable.util.PublishControllerUtility;

public class StandardFileSystemPublishController
extends AbstractSubsystemController
implements IPublishController,
IPrimaryPublishController {
    private IModuleStateController moduleStateController;
    private boolean moduleStateControllerLoadFailed = false;
    private IModuleRestartBehaviorController restartController;
    private boolean restartControllerLoadFailed = false;
    private IDeploymentOptionsController deploymentOptions;
    private IModuleDeployPathController deployPathController;
    private IFilesystemController filesystemController;
    private HashMap<IModule[], Integer> publishType = new HashMap();
    private HashMap<IModule[], Boolean> requiresRestart = new HashMap();

    protected IModuleRestartBehaviorController getModuleRestartBehaviorController() throws CoreException {
        if (this.restartController == null && !this.restartControllerLoadFailed) {
            try {
                this.restartController = (IModuleRestartBehaviorController)this.findDependencyFromBehavior("module.restart.behavior");
            }
            catch (CoreException coreException) {
                this.restartControllerLoadFailed = true;
            }
        }
        return this.restartController;
    }

    protected IModuleStateController getModuleStateController() throws CoreException {
        if (this.moduleStateController == null && !this.moduleStateControllerLoadFailed) {
            try {
                this.moduleStateController = (IModuleStateController)this.findDependencyFromBehavior("modules");
            }
            catch (CoreException coreException) {
                this.moduleStateControllerLoadFailed = true;
            }
        }
        return this.moduleStateController;
    }

    protected IDeploymentOptionsController getDeploymentOptions() throws CoreException {
        if (this.deploymentOptions == null) {
            this.deploymentOptions = (IDeploymentOptionsController)this.findDependencyFromBehavior("deploymentOptions");
        }
        return this.deploymentOptions;
    }

    protected IModuleDeployPathController getDeployPathController() throws CoreException {
        if (this.deployPathController == null) {
            HashMap<String, IDeploymentOptionsController> env = this.getEnvironment() == null ? new HashMap<String, IDeploymentOptionsController>() : new HashMap(this.getEnvironment());
            env.put("IModuleDeployPathController.DeploymentOptionsController", this.getDeploymentOptions());
            this.deployPathController = (IModuleDeployPathController)this.findDependency("moduleDeployPath", this.getServer().getServerType().getId(), env);
        }
        return this.deployPathController;
    }

    protected IFilesystemController getFilesystemController() throws CoreException {
        if (this.filesystemController == null) {
            this.filesystemController = (IFilesystemController)this.findDependencyFromBehavior("filesystem");
        }
        return this.filesystemController;
    }

    public IStatus validate() {
        try {
            IStatus sup = super.validate();
            if (!sup.isOK()) {
                return sup;
            }
            this.getDeploymentOptions();
            this.getDeployPathController();
            this.getFilesystemController();
        }
        catch (CoreException ce) {
            return ce.getStatus();
        }
        return Status.OK_STATUS;
    }

    public IStatus canPublish() {
        IStatus s = this.validate();
        if (!s.isOK()) {
            return s;
        }
        return Status.OK_STATUS;
    }

    public boolean canPublishModule(IModule[] module) {
        IStatus s = this.validate();
        return s.isOK();
    }

    public void publishStart(IProgressMonitor monitor) throws CoreException {
        this.validate();
    }

    public void publishFinish(IProgressMonitor monitor) throws CoreException {
        this.validate();
        IServer s = this.getServer();
        this.ensureModulesRestarted();
        ((Server)s).setServerPublishState(this.getUpdatedPublishState(s));
        IModuleStateController c = this.getModuleStateController();
        if (c != null && this.getServer().getServerState() == 2) {
            new UpdateModuleStateJob(c, this.getServer(), true, 15000).schedule(5000L);
        }
    }

    private int getUpdatedPublishState(IServer server) {
        IModule[] modules = server.getModules();
        boolean allpublished = true;
        int i = 0;
        while (i < modules.length) {
            if (server.getModulePublishState(new IModule[]{modules[i]}) != 1) {
                allpublished = false;
            }
            ++i;
        }
        if (allpublished) {
            return 1;
        }
        return 2;
    }

    public int publishModule(int kind, int deltaKind, IModule[] module, IProgressMonitor monitor) throws CoreException {
        PublishModuleFullRunner runner;
        monitor = monitor == null ? new NullProgressMonitor() : monitor;
        this.validate();
        IPublishControllerDelegate delegate = PublishControllerUtility.findDelegatePublishController((IServer)this.getServer(), (IModule[])module, (boolean)true);
        if (delegate != null) {
            return delegate.publishModule(kind, deltaKind, module, monitor);
        }
        boolean isBinaryObject = ServerModelUtilities.isBinaryModule((IModule[])module);
        boolean prefersZipped = this.prefersZipped();
        IPath archiveDestination = this.getModuleDeployRoot(module);
        int publishType = PublishControllerUtility.getPublishType((IServer)this.getServer(), (IModule[])module, (int)kind, (int)deltaKind);
        if (!isBinaryObject && prefersZipped) {
            return this.handleZippedPublish(module, publishType, archiveDestination, false, monitor);
        }
        if (publishType == 3) {
            return this.removeModule(module, archiveDestination, monitor);
        }
        if (ServerModelUtilities.isAnyDeleted((IModule[])module)) {
            Trace.trace("/finer", "Handling a wtp 'deleted module' (aka missing/deleted /closed project). No Action Taken. Returning state=unknown ");
            return 0;
        }
        boolean forceZip = this.forceZipModule(module);
        boolean forzeZipAnyParent = this.parentModuleIsForcedZip(module);
        if (forzeZipAnyParent) {
            return 1;
        }
        if (!isBinaryObject && forceZip) {
            return this.handleZippedPublish(module, publishType, archiveDestination, true, monitor);
        }
        IStatus[] ret = null;
        String msgForFailure = null;
        IModulePathFilter filter = ResourceModuleResourceUtil.findDefaultModuleFilter(module[module.length - 1]);
        if (isBinaryObject) {
            return this.handlePublishBinaryModule(module, archiveDestination, publishType);
        }
        if (publishType == 2) {
            runner = new PublishModuleFullRunner(this.getFilesystemController(), archiveDestination);
            IModuleResource[] filtered = filter == null ? ModuleResourceUtil.getMembers((IModule)module[module.length - 1]) : filter.getFilteredMembers();
            ret = runner.fullPublish(filtered, monitor);
            this.requiresRestart.put(module, true);
            msgForFailure = Messages.FullPublishFail;
        } else if (publishType == 1) {
            runner = new PublishModuleIncrementalRunner(this.getFilesystemController(), archiveDestination);
            IModuleResourceDelta[] cleanDelta = filter != null ? filter.getFilteredDelta(this.getDeltaForModule(module)) : this.getDeltaForModule(module);
            this.requiresRestart.put(module, this.getModuleRestartBehaviorController().moduleRequiresRestart(module, cleanDelta));
            ret = runner.publish(cleanDelta, monitor);
            msgForFailure = Messages.IncrementalPublishFail;
        } else {
            this.requiresRestart.put(module, false);
        }
        monitor.done();
        this.markModulePublished(module, publishType);
        if (ret != null && ret.length > 0) {
            MultiStatus ms = new MultiStatus("org.jboss.ide.eclipse.as.core", 1644298244, NLS.bind((String)msgForFailure, (Object)module[module.length - 1].getName()), null);
            int i = 0;
            while (i < ret.length) {
                if (ret[i] != null && !ret[i].isOK()) {
                    ms.add(ret[i]);
                }
                ++i;
            }
            if (ms.getChildren().length > 0) {
                ServerLogger.getDefault().log(this.getServer(), (IStatus)ms);
                return 0;
            }
        }
        return 1;
    }

    private int handlePublishBinaryModule(IModule[] module, IPath archiveDestination, int publishType) throws CoreException {
        if (publishType == 0) {
            this.markModulePublished(module, 0);
            return 1;
        }
        IModuleResource[] all = ModuleResourceUtil.getMembers((IModule)module[module.length - 1]);
        if (all != null && all.length > 0 && all[0] != null) {
            IStatus s2;
            IModuleResource r = all[0];
            File f = ModuleResourceUtil.getFile((IModuleResource)r);
            IPath folder = archiveDestination.removeLastSegments(1);
            IStatus s1 = this.getFilesystemController().makeDirectoryIfRequired(folder, (IProgressMonitor)new NullProgressMonitor());
            IStatus result = null;
            result = s1 != null && !s1.isOK() ? s1 : (s2 = this.getFilesystemController().copyFile(f, archiveDestination, (IProgressMonitor)new NullProgressMonitor()));
            this.markModulePublished(module, 2);
            if (result != null && !result.isOK()) {
                ServerLogger.getDefault().log(this.getServer(), result);
            }
            return result == null || result.isOK() ? 1 : 3;
        }
        return 0;
    }

    private int removeModule(IModule[] module, IPath remote, IProgressMonitor monitor) throws CoreException {
        if (module.length > 1) {
            return 1;
        }
        Trace.trace("/finer", "Handling an unpublish");
        IStatus results = this.getFilesystemController().deleteResource(remote, monitor);
        if (results != null && !results.isOK()) {
            MultiStatus ms = new MultiStatus("org.jboss.ide.eclipse.as.core", 0x62020006, "Unable to delete module", null);
            ms.add(results);
            ServerLogger.getDefault().log(this.getServer(), (IStatus)ms);
            this.markModulePublished(module, 3);
            return 0;
        }
        this.markModulePublished(module, 3);
        Trace.trace("/finer", "Deleted deployment resource: " + remote.toOSString());
        return 1;
    }

    private int handleZippedPublish(IModule[] module, int publishType, IPath archiveDestination, boolean force, IProgressMonitor monitor) throws CoreException {
        if (!force && module.length > 1) {
            return 1;
        }
        if (publishType == 3) {
            return this.removeModule(module, archiveDestination, monitor);
        }
        if (ServerModelUtilities.isAnyDeleted((IModule[])module)) {
            Trace.trace("/finer", "Handling a wtp 'deleted module' (aka missing/deleted /closed project). No Action Taken. Returning state=unknown ");
            return 0;
        }
        IPath localTempLocation = this.getMetadataTemporaryLocation(this.getServer());
        IPath tmpArchive = localTempLocation.append(archiveDestination.lastSegment());
        LocalZippedModulePublishRunner runner = this.createZippedRunner(module, tmpArchive);
        monitor.beginTask("Packaging Module", 200);
        IStatus result = null;
        boolean rebuiltFull = false;
        boolean rebuiltInc = false;
        if (publishType == 2) {
            rebuiltFull = true;
            result = runner.fullPublishModule(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)100));
        } else {
            int childPublishType = runner.childPublishTypeRequired();
            if (childPublishType == 2) {
                rebuiltFull = true;
                result = runner.fullPublishModule(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)100));
            } else if (publishType == 1 || childPublishType == 1) {
                rebuiltInc = true;
                result = runner.incrementalPublishModule(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)100));
            }
        }
        if ((rebuiltFull || rebuiltInc) && (result == null || result.isOK())) {
            if (tmpArchive.toFile().exists()) {
                this.getFilesystemController().deleteResource(archiveDestination, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)10));
                result = this.getFilesystemController().copyFile(tmpArchive.toFile(), archiveDestination, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)90));
            } else {
                result = new Status(4, "org.jboss.ide.eclipse.as.core", "Zipped archive not found");
            }
        }
        if (rebuiltFull || rebuiltInc && module.length == 1) {
            this.markModulePublished(module, 2);
        } else if (rebuiltInc) {
            IModuleRestartBehaviorController c = this.getModuleRestartBehaviorController();
            if (c != null && c.moduleRequiresRestart(module, new IModuleResource[0])) {
                this.markModulePublished(module, 2);
            }
        } else {
            this.markModulePublished(module, 0);
        }
        if (result != null && !result.isOK()) {
            ServerLogger.getDefault().log(this.getServer(), result);
        }
        return result == null || result.isOK() ? 1 : 0;
    }

    private boolean prefersZipped() throws CoreException {
        return this.getDeploymentOptions().prefersZippedDeployments();
    }

    private IPath getModuleDeployRoot(IModule[] module) throws CoreException {
        IDeploymentOptionsController opts = this.getDeploymentOptions();
        IModuleDeployPathController depPath = this.getDeployPathController();
        return new RemotePath(depPath.getDeployDirectory(module).toOSString(), opts.getPathSeparatorCharacter());
    }

    protected IModulePathFilterProvider getModulePathFilterProvider() {
        return new IModulePathFilterProvider(){

            public IModulePathFilter getFilter(IServer server, IModule[] module) {
                return ResourceModuleResourceUtil.findDefaultModuleFilter(module[module.length - 1]);
            }
        };
    }

    private void markModulePublished(IModule[] module, int type) {
        this.publishType.put(module, type);
    }

    protected boolean forceZipModule(IModule[] moduleTree) {
        return PublishUtil.deployPackaged(moduleTree);
    }

    private boolean parentModuleIsForcedZip(IModule[] moduleTree) {
        ArrayList<IModule> tmp = new ArrayList<IModule>(Arrays.asList(moduleTree));
        tmp.remove(tmp.size() - 1);
        while (tmp.size() > 0) {
            IModule[] tmpArray = tmp.toArray(new IModule[tmp.size()]);
            if (this.forceZipModule(tmpArray)) {
                return true;
            }
            tmp.remove(tmp.size() - 1);
        }
        return false;
    }

    private IPath getMetadataTemporaryLocation(IServer server) {
        IPath deployRoot = JBossServerCorePlugin.getServerStateLocation(server).append("tempRemoteDeploy").makeAbsolute();
        deployRoot.toFile().mkdirs();
        return deployRoot;
    }

    public void publishServer(int kind, IProgressMonitor monitor) throws CoreException {
        this.validate();
    }

    protected void ensureModulesRestarted() {
        List<IModule> top = this.getTopLevelModules();
        for (IModule m : top) {
            if (this.moduleRequiresRestart(m)) {
                this.restartModule(m);
                continue;
            }
            if (!this.moduleRequiresRemovalCompletion(m)) continue;
            this.completeRemoval(m);
        }
    }

    protected boolean moduleRequiresRemovalCompletion(IModule m) {
        for (IModule[] mit : this.publishType.keySet()) {
            if (mit.length != 1 || !mit[0].equals(m) || this.publishType.get(mit) != 3) continue;
            return true;
        }
        return false;
    }

    protected void completeRemoval(IModule m) {
        try {
            IPath archiveDestination = this.getModuleDeployRoot(new IModule[]{m});
            boolean useAS7Behavior = DeploymentMarkerUtils.supportsJBoss7MarkerDeployment(this.getServer());
            if (useAS7Behavior) {
                IFilesystemController controller = this.getFilesystemController();
                DeploymentMarkerUtils.removeDoDeployMarker(archiveDestination, controller);
                DeploymentMarkerUtils.removedDeployedMarker(archiveDestination, controller);
                DeploymentMarkerUtils.removedDeployFailedMarker(archiveDestination, controller);
            }
        }
        catch (CoreException ce) {
            JBossServerCorePlugin.log(ce);
        }
    }

    protected void restartModule(IModule m) {
        try {
            IPath archiveDestination = this.getModuleDeployRoot(new IModule[]{m});
            IFilesystemController controller = this.getFilesystemController();
            boolean useAS7Behavior = DeploymentMarkerUtils.supportsJBoss7MarkerDeployment(this.getServer());
            if (!useAS7Behavior) {
                JSTPublisherXMLToucher.getInstance().touch(archiveDestination, m, controller);
            } else {
                DeploymentMarkerUtils.removedDeployedMarker(archiveDestination, controller);
                DeploymentMarkerUtils.removedDeployFailedMarker(archiveDestination, controller);
                DeploymentMarkerUtils.createDoDeployMarker(archiveDestination, controller);
            }
        }
        catch (CoreException ce) {
            JBossServerCorePlugin.log(ce);
        }
    }

    private List<IModule> getTopLevelModules() {
        ArrayList<IModule> collector = new ArrayList<IModule>();
        for (IModule[] m : this.publishType.keySet()) {
            if (collector.contains(m[0])) continue;
            collector.add(m[0]);
        }
        return collector;
    }

    protected boolean shouldMinimizeRedeployments() {
        boolean debugMode = "debug".equals(this.getServer().getMode());
        Object o = this.getControllableBehavior().getSharedData("AbstractStartJavaServerLaunchDelegate.HotCodeReplaceOverridden");
        return debugMode && o instanceof Boolean && (Boolean)o != false;
    }

    protected boolean moduleRequiresRestart(IModule m) {
        boolean minimizeRedeployments = this.shouldMinimizeRedeployments();
        for (IModule[] fromMap : this.publishType.keySet()) {
            boolean isRemovedChild;
            int type;
            if (minimizeRedeployments) {
                if (fromMap.length != 1 || fromMap[0] != m) continue;
                type = this.publishType.get(fromMap);
                return type == 2;
            }
            if (fromMap.length <= 0 || fromMap[0] != m) continue;
            type = this.publishType.get(fromMap);
            Boolean t = this.requiresRestart.get(fromMap);
            boolean matchesPattern = t != null && t != false;
            boolean bl = isRemovedChild = fromMap.length > 1 && type == 3;
            if (!matchesPattern && type != 2 && !isRemovedChild) continue;
            return true;
        }
        return false;
    }

    protected LocalZippedModulePublishRunner createZippedRunner(IModule m, IPath p) {
        return this.createZippedRunner(new IModule[]{m}, p);
    }

    protected LocalZippedModulePublishRunner createZippedRunner(IModule[] m, IPath p) {
        return new LocalZippedModulePublishRunner(this.getServer(), m, p, this.getModulePathFilterProvider());
    }

    protected IModuleResourceDelta[] getDeltaForModule(IModule[] module) {
        IModuleResourceDelta[] deltas = ((Server)this.getServer()).getPublishedResourceDelta(module);
        return deltas;
    }

    public int transferBuiltModule(IModule[] module, IPath srcFile, IProgressMonitor monitor) throws CoreException {
        IPath archiveDestination = this.getModuleDeployRoot(module);
        IStatus result = this.getFilesystemController().copyFile(srcFile.toFile(), archiveDestination, monitor);
        this.markModulePublished(module, 2);
        if (result != null && !result.isOK()) {
            ServerLogger.getDefault().log(this.getServer(), result);
        }
        return result == null || result.isOK() ? 1 : 0;
    }

    public int removeModule(IModule[] module, IProgressMonitor monitor) throws CoreException {
        IPath archiveDestination = this.getModuleDeployRoot(module);
        return this.removeModule(module, archiveDestination, monitor);
    }
}

