/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.internal.management.as7.tests.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import junit.framework.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.as.core.server.internal.ExtendedServerPropertiesAdapterFactory;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.JBossExtendedProperties;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.ServerExtendedProperties;
import org.jboss.ide.eclipse.as.core.util.ThreadUtils;
import org.jboss.ide.eclipse.as.internal.management.as7.tests.utils.AS7ManagerTestUtils;
import org.jboss.ide.eclipse.as.internal.management.as7.tests.utils.ManagementPortTestUtility;
import org.jboss.ide.eclipse.as.internal.management.as7.tests.utils.ParameterUtils;
import org.jboss.ide.eclipse.as.management.core.IAS7ManagementDetails;
import org.jboss.ide.eclipse.as.management.core.IJBoss7ManagerService;
import org.jboss.ide.eclipse.as.management.core.JBoss7ManangerException;
import org.jboss.ide.eclipse.as.management.core.JBoss7ServerState;

public class StartupUtility
extends Assert {
    private static final String JRE7_SYSPROP = "jbosstools.test.jre.7";
    private String homeDir;
    private String runtimeType;
    private Process process;
    private boolean started = false;
    private int port;

    private static boolean isJava7() {
        return System.getProperty("java.version").startsWith("1.7.");
    }

    private static IExecutionEnvironment getRequiredExecEnv(String runtimeType) {
        IRuntimeType type = ServerCore.findRuntimeType((String)runtimeType);
        System.out.println("getRequiredExecenv for " + type.getId());
        ServerExtendedProperties o = new ExtendedServerPropertiesAdapterFactory().getExtendedProperties((Object)type);
        IExecutionEnvironment env = ((JBossExtendedProperties)o).getDefaultExecutionEnvironment();
        return env;
    }

    private static boolean requiresJava7(String runtimeType) {
        return "JavaSE-1.7".equals(StartupUtility.getRequiredExecEnv(runtimeType).getId());
    }

    private static boolean requiresJava6(String runtimeType) {
        return "JavaSE-1.6".equals(StartupUtility.getRequiredExecEnv(runtimeType).getId());
    }

    public static Process runServer(String homeDir) {
        String rtType = ParameterUtils.serverHomeToRuntimeType.get(homeDir);
        System.out.println("Running server " + homeDir + " with rtType = " + rtType);
        String scriptName = null;
        String cmd = null;
        IPath bin = new Path(homeDir).append("bin");
        if (Platform.getOS().equals("win32")) {
            scriptName = "standalone.bat";
            bin.append(scriptName);
            StartupUtility.fail((String)"These tests cannot run on windows currently");
        } else {
            scriptName = "standalone.sh";
            IPath script = bin.append(scriptName);
            script.toFile().setExecutable(true);
            cmd = script.toFile().getAbsolutePath();
        }
        ArrayList<String> envp = new ArrayList<String>();
        envp.add("JAVA_HOME=" + StartupUtility.getJavaHome(rtType, homeDir));
        String[] envList = envp.toArray(new String[envp.size()]);
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(cmd, envList);
            return p;
        }
        catch (IOException ioe) {
            StartupUtility.fail((String)(String.valueOf(homeDir) + " server failed to start: " + ioe.getMessage()));
            System.out.println("Somehow launch completed without returning a process");
            return null;
        }
    }

    private static String getJavaHome(String rtType, String serverHome) {
        return StartupUtility.getJavaHome(serverHome, JRE7_SYSPROP, "java7 jdk");
    }

    private static String getJavaHome(String serverHome, String sysprop, String javaVersion) {
        String java = System.getProperty(sysprop);
        if (java == null) {
            StartupUtility.fail((String)("Launching " + serverHome + " requires a " + javaVersion + ", which has not been provided via the " + sysprop + " system property"));
        }
        if (!new File(java).exists()) {
            StartupUtility.fail((String)("Java Home " + java + " provided by the " + sysprop + " system property does not exist."));
        }
        return java;
    }

    public void setHomeDir(String homeDir) {
        this.homeDir = homeDir;
        this.setRuntimeType(ParameterUtils.serverHomeToRuntimeType.get(homeDir));
        this.setPort(ManagementPortTestUtility.getManagementPort(homeDir));
        StartupUtility.assertTrue((this.getPort() != -1 ? 1 : 0) != 0);
    }

    protected void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public String getHomeDir() {
        return this.homeDir;
    }

    public void setRuntimeType(String runtimeType) {
        this.runtimeType = runtimeType;
    }

    public String getRuntimeType() {
        return this.runtimeType;
    }

    public void startIfNotStarted(boolean wait) {
        if (!this.started) {
            this.start(wait);
        }
    }

    public void start(boolean wait) {
        this.process = StartupUtility.runServer(this.homeDir);
        if (wait) {
            this.waitForStarted(this.process);
        }
        this.started = true;
    }

    public void dispose() {
        if (this.homeDir != null && this.process != null) {
            try {
                this.process.exitValue();
                System.out.println("Server has already shutdown");
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                System.out.println("Shutting down server");
                this.shutdownServer(this.process);
            }
        }
        this.started = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitForStarted(Process p) {
        System.out.println("Waiting for server to complete startup");
        Throwable ex = null;
        IJBoss7ManagerService service = AS7ManagerTestUtils.findService(this.runtimeType);
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {}
        try {
            try {
                JBoss7ServerState state = null;
                long startTime = System.currentTimeMillis();
                long endTime = startTime + 60000L;
                while (state != JBoss7ServerState.RUNNING) {
                    if (System.currentTimeMillis() >= endTime) {
                        return;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    try {
                        state = service.getServerState(this.createConnectionDetails());
                        ex = null;
                    }
                    catch (JBoss7ManangerException ioe) {
                        ex = ioe;
                    }
                }
                return;
            }
            catch (Exception e) {
                ex = e;
                if (service != null) {
                    service.dispose();
                }
                if (ex == null) return;
                if (p != null) {
                    p.destroy();
                }
                if (ex == null) return;
                StartupUtility.fail((String)("Could not correctly discover if server has started: " + this.homeDir + ": " + ex.getMessage()));
                return;
            }
        }
        finally {
            if (service != null) {
                service.dispose();
            }
            if (ex != null) {
                if (p != null) {
                    p.destroy();
                }
                if (ex != null) {
                    StartupUtility.fail((String)("Could not correctly discover if server has started: " + this.homeDir + ": " + ex.getMessage()));
                }
            }
        }
    }

    private void shutdownServer(Process p) {
        IJBoss7ManagerService service = AS7ManagerTestUtils.findService(this.runtimeType);
        Exception ex = null;
        try {
            try {
                boolean isListening = AS7ManagerTestUtils.isListening("localhost", this.getPort());
                StartupUtility.assertTrue((boolean)isListening);
                service.stop(this.createConnectionDetails());
                ThreadUtils.sleepFor((int)3000);
                isListening = AS7ManagerTestUtils.isListening("localhost", this.getPort());
                StartupUtility.assertFalse((boolean)isListening);
            }
            catch (Exception e) {
                ex = e;
                if (service != null) {
                    service.dispose();
                }
                if (p != null) {
                    p.destroy();
                }
                if (ex != null) {
                    StartupUtility.fail((String)("Could not stop server " + this.homeDir + ": " + ex.getMessage()));
                }
            }
        }
        finally {
            if (service != null) {
                service.dispose();
            }
            if (p != null) {
                p.destroy();
            }
            if (ex != null) {
                StartupUtility.fail((String)("Could not stop server " + this.homeDir + ": " + ex.getMessage()));
            }
        }
    }

    protected IAS7ManagementDetails createConnectionDetails() {
        return new AS7ManagerTestUtils.MockAS7ManagementDetails("localhost", this.getPort());
    }
}

