/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.classpath.modules;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.classpath.core.runtime.CustomRuntimeClasspathModel;
import org.jboss.ide.eclipse.as.classpath.core.runtime.IRuntimePathProvider;
import org.jboss.ide.eclipse.as.classpath.core.runtime.internal.ProjectRuntimeClasspathProvider;
import org.jboss.ide.eclipse.as.classpath.core.runtime.path.internal.LayeredProductPathProvider;
import org.jboss.tools.as.test.core.ASMatrixTests;
import org.jboss.tools.as.test.core.classpath.modules.MockJBossModulesUtil;
import org.jboss.tools.as.test.core.internal.utils.ResourceUtils;
import org.jboss.tools.as.test.core.internal.utils.wtp.CreateProjectOperationsUtility;
import org.jboss.tools.as.test.core.internal.utils.wtp.JavaEEFacetConstants;
import org.jboss.tools.as.test.core.internal.utils.wtp.OperationTestCase;
import org.jboss.tools.test.util.JobUtils;
import org.junit.After;

public class JBossModulesClasspathTest
extends TestCase {
    @After
    public void tearDown() throws Exception {
        ASMatrixTests.getDefault();
        ASMatrixTests.cleanup();
    }

    public void testBasicModuleSlot() throws Exception {
        IServer s2 = MockJBossModulesUtil.createMockServerWithRuntime("org.jboss.ide.eclipse.as.eap.61", "TestOne");
        IRuntime rt = s2.getRuntime();
        CustomRuntimeClasspathModel.getInstance().savePathProviders(rt.getRuntimeType(), new IRuntimePathProvider[0]);
        IDataModel dm = CreateProjectOperationsUtility.getWebDataModel("WebProject1", null, null, null, null, JavaEEFacetConstants.WEB_24, false);
        IProject p = this.createSingleProject(dm, "WebProject1");
        ProjectRuntimeClasspathProvider provider = new ProjectRuntimeClasspathProvider();
        IClasspathEntry[] entries = provider.resolveClasspathContainer(p, rt);
        JBossModulesClasspathTest.assertEquals((int)entries.length, (int)0);
        LayeredProductPathProvider pathPro = new LayeredProductPathProvider("org.jboss.as.server", null);
        CustomRuntimeClasspathModel.getInstance().savePathProviders(rt.getRuntimeType(), new IRuntimePathProvider[]{pathPro});
        entries = provider.resolveClasspathContainer(p, rt);
        JBossModulesClasspathTest.assertEquals((int)entries.length, (int)1);
        IPath modules = rt.getLocation().append("modules");
        IPath base = modules.append("system").append("layers").append("base");
        MockJBossModulesUtil.cloneModule(base, "org.jboss.as.server", base, "org.max.wonka");
        LayeredProductPathProvider wonkaProvider = new LayeredProductPathProvider("org.max.wonka", null);
        CustomRuntimeClasspathModel.getInstance().savePathProviders(rt.getRuntimeType(), new IRuntimePathProvider[]{pathPro, wonkaProvider});
        entries = provider.resolveClasspathContainer(p, rt);
        JBossModulesClasspathTest.assertEquals((int)entries.length, (int)2);
    }

    public void testManifestAdditions() throws Exception {
        IServer s2 = MockJBossModulesUtil.createMockServerWithRuntime("org.jboss.ide.eclipse.as.eap.61", "TestOne");
        IRuntime rt = s2.getRuntime();
        CustomRuntimeClasspathModel.getInstance().savePathProviders(rt.getRuntimeType(), new IRuntimePathProvider[0]);
        IDataModel dm = CreateProjectOperationsUtility.getWebDataModel("WebProject1", null, null, null, null, JavaEEFacetConstants.WEB_24, false);
        IProject p = this.createSingleProject(dm, "WebProject1");
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)p);
        IFacetedProjectWorkingCopy workingCopy = facetedProject.createWorkingCopy();
        workingCopy.addTargetedRuntime(RuntimeManager.getRuntime((String)rt.getName()));
        workingCopy.commitChanges(null);
        IFile manifest = p.getFile("MANIFEST.MF");
        String contents = "Dependencies: org.jboss.as.server\n";
        this.setContentsAndWaitForPropagation(manifest, contents);
        ProjectRuntimeClasspathProvider provider = new ProjectRuntimeClasspathProvider();
        IClasspathEntry[] entries = provider.resolveClasspathContainer(p, rt);
        JBossModulesClasspathTest.assertEquals((int)entries.length, (int)1);
        IPath modules = rt.getLocation().append("modules");
        IPath base = modules.append("system").append("layers").append("base");
        MockJBossModulesUtil.cloneModule(base, "org.jboss.as.server", base, "org.max.wonka");
        contents = "Dependencies: org.jboss.as.server, org.max.wonka\n";
        this.setContentsAndWaitForPropagation(manifest, contents);
        JobUtils.waitForIdle();
        System.out.println("Idle over");
        provider = new ProjectRuntimeClasspathProvider();
        entries = provider.resolveClasspathContainer(p, rt);
        System.out.println("Asserting");
        JBossModulesClasspathTest.assertEquals((int)entries.length, (int)2);
        contents = "Dependencies: org.jboss.as.server\n";
        this.setContentsAndWaitForPropagation(manifest, contents);
        provider = new ProjectRuntimeClasspathProvider();
        entries = provider.resolveClasspathContainer(p, rt);
        JBossModulesClasspathTest.assertEquals((int)entries.length, (int)1);
    }

    private void setContentsAndWaitForPropagation(IFile file, String contents) throws Exception {
        if (file.exists()) {
            file.setContents((InputStream)new ByteArrayInputStream(contents.getBytes()), 1, (IProgressMonitor)new NullProgressMonitor());
        } else {
            file.create((InputStream)new ByteArrayInputStream(contents.getBytes()), true, (IProgressMonitor)new NullProgressMonitor());
        }
        JobUtils.waitForIdle((long)1500L);
    }

    public void testManifestVersionAdditions() throws Exception {
        IServer s2 = MockJBossModulesUtil.createMockServerWithRuntime("org.jboss.ide.eclipse.as.eap.61", "TestOne");
        IRuntime rt = s2.getRuntime();
        CustomRuntimeClasspathModel.getInstance().savePathProviders(rt.getRuntimeType(), new IRuntimePathProvider[0]);
        IDataModel dm = CreateProjectOperationsUtility.getWebDataModel("WebProject1", null, null, null, null, JavaEEFacetConstants.WEB_24, false);
        IProject p = this.createSingleProject(dm, "WebProject1");
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)p);
        IFacetedProjectWorkingCopy workingCopy = facetedProject.createWorkingCopy();
        workingCopy.addTargetedRuntime(RuntimeManager.getRuntime((String)rt.getName()));
        workingCopy.commitChanges(null);
        IFile manifest = p.getFile("MANIFEST.MF");
        String contents = "Dependencies: org.jboss.as.server\n";
        this.setContentsAndWaitForPropagation(manifest, contents);
        ProjectRuntimeClasspathProvider provider = new ProjectRuntimeClasspathProvider();
        IClasspathEntry[] entries = provider.resolveClasspathContainer(p, rt);
        JBossModulesClasspathTest.assertEquals((int)entries.length, (int)1);
        contents = "Dependencies: org.jboss.as.server:main\n";
        this.setContentsAndWaitForPropagation(manifest, contents);
        provider = new ProjectRuntimeClasspathProvider();
        entries = provider.resolveClasspathContainer(p, rt);
        JBossModulesClasspathTest.assertEquals((int)entries.length, (int)1);
        contents = "Dependencies: org.jboss.as.server:1.0\n";
        this.setContentsAndWaitForPropagation(manifest, contents);
        provider = new ProjectRuntimeClasspathProvider();
        entries = provider.resolveClasspathContainer(p, rt);
        JBossModulesClasspathTest.assertEquals((int)entries.length, (int)0);
        IPath modules = rt.getLocation().append("modules");
        IPath base = modules.append("system").append("layers").append("base");
        MockJBossModulesUtil.duplicateToSlot(base, "org.jboss.as.server", "1.0");
        contents = "Dependencies: org.jboss.as.server:1.0\n";
        this.setContentsAndWaitForPropagation(manifest, contents);
        provider = new ProjectRuntimeClasspathProvider();
        entries = provider.resolveClasspathContainer(p, rt);
        JBossModulesClasspathTest.assertEquals((int)entries.length, (int)1);
        IPath path = entries[0].getPath();
        JBossModulesClasspathTest.assertTrue((boolean)path.toOSString().contains("1.0"));
    }

    protected IProject createSingleProject(IDataModel dm, String name) throws Exception {
        OperationTestCase.runAndVerify(dm);
        IProject p = ResourceUtils.findProject(name);
        if (!p.exists()) {
            JBossModulesClasspathTest.fail();
        }
        return p;
    }
}

