/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.parametized.server;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.ide.eclipse.archives.webtools.filesets.Fileset;
import org.jboss.ide.eclipse.archives.webtools.filesets.FilesetUtil;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathCategory;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathModel;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathQuery;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.ide.eclipse.as.core.server.internal.ExtendedServerPropertiesAdapterFactory;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.ServerExtendedProperties;
import org.jboss.ide.eclipse.as.core.server.internal.v7.LocalJBoss7ServerRuntime;
import org.jboss.ide.eclipse.as.core.util.RuntimeUtils;
import org.jboss.tools.as.test.core.internal.utils.ServerCreationTestUtils;
import org.jboss.tools.as.test.core.parametized.server.ServerParameterUtils;
import org.jboss.tools.test.util.JobUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CreateServerCheckDefaultsTest
extends TestCase {
    private String serverType;
    private IServer server;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return ServerParameterUtils.asCollection(ServerParameterUtils.getAllJBossServerTypeParamterers());
    }

    public CreateServerCheckDefaultsTest(String serverType) {
        this.serverType = serverType;
    }

    @Before
    public void setUp() {
        try {
            this.server = ServerCreationTestUtils.createServerWithRuntime(this.serverType, String.valueOf(((Object)((Object)this)).getClass().getName()) + this.serverType);
        }
        catch (CoreException ce) {
            ce.printStackTrace();
            CreateServerCheckDefaultsTest.fail();
        }
    }

    @After
    public void tearDown() throws Exception {
        ServerCreationTestUtils.deleteAllServersAndRuntimes();
    }

    @Test
    public void testServerDefaults() {
        CreateServerCheckDefaultsTest.assertNotNull((String)"Test setup failed to create a server", (Object)this.server);
        CreateServerCheckDefaultsTest.assertNotNull((String)("Created server of type " + this.server.getServerType().getId() + " has no runtime"), (Object)this.server.getRuntime());
        CreateServerCheckDefaultsTest.assertFalse((String)"Server name should not be empty", (this.server.getName() == null || "".equals(this.server.getName()) ? 1 : 0) != 0);
        CreateServerCheckDefaultsTest.assertFalse((String)"Runtime name should not be empty", (this.server.getRuntime().getName() == null || "".equals(this.server.getRuntime().getName()) ? 1 : 0) != 0);
        String typeId = this.server.getServerType().getId();
        if (typeId.equals("org.jboss.ide.eclipse.as.systemCopyServer")) {
            return;
        }
        IJBossServerRuntime rt = this.getJBossRuntime(this.server);
        CreateServerCheckDefaultsTest.assertNotNull((String)("Created server of type " + this.server.getServerType().getId() + " does not adapt to IJBossServerRuntime"), (Object)rt);
        CreateServerCheckDefaultsTest.assertNotNull((Object)rt.getVM());
        CreateServerCheckDefaultsTest.assertNotNull((Object)rt.getExecutionEnvironment());
        LocalJBoss7ServerRuntime jb7rt = (LocalJBoss7ServerRuntime)this.server.getRuntime().loadAdapter(LocalJBoss7ServerRuntime.class, null);
        if (jb7rt != null) {
            CreateServerCheckDefaultsTest.assertEquals((String)"standalone.xml", (String)jb7rt.getConfigurationFile());
        } else {
            CreateServerCheckDefaultsTest.assertEquals((String)"default", (String)rt.getJBossConfiguration());
        }
        ServerExtendedProperties props = ExtendedServerPropertiesAdapterFactory.getServerExtendedProperties((IServerAttributes)this.server);
        CreateServerCheckDefaultsTest.assertNotNull((Object)props);
        CreateServerCheckDefaultsTest.assertTrue((String)("Server creation structure fails a verify call for server type " + this.serverType), (boolean)props.verifyServerStructure().isOK());
        if (props.canVerifyRemoteModuleState()) {
            CreateServerCheckDefaultsTest.assertNotNull((Object)props.getModuleStateVerifier());
        }
        if (props.hasWelcomePage()) {
            String s = props.getWelcomePageUrl();
            try {
                new URL(s);
            }
            catch (MalformedURLException murle) {
                CreateServerCheckDefaultsTest.fail((String)(String.valueOf(this.serverType) + " has an invalid welcome page url: " + murle.getMessage()));
            }
        }
    }

    @Test
    public void testXPathsAdded() {
        JobUtils.waitForIdle();
        IServer s = this.server;
        XPathCategory[] cats = XPathModel.getDefault().getCategories(s);
        String typeId = this.server.getServerType().getId();
        if (typeId.equals("org.jboss.ide.eclipse.as.systemCopyServer")) {
            CreateServerCheckDefaultsTest.assertTrue((String)"Deploy-only Servers should have no default xpaths.", (cats == null || cats.length == 0 ? 1 : 0) != 0);
            return;
        }
        CreateServerCheckDefaultsTest.assertFalse((String)"Server has no xpath categories automatically added", (cats == null || cats.length == 0 ? 1 : 0) != 0);
        CreateServerCheckDefaultsTest.assertNotNull((String)"Server has no 'ports' xpath category. ", (Object)XPathModel.getDefault().getCategory(s, XPathModel.PORTS_CATEGORY_NAME));
        File xpathFile = JBossServerCorePlugin.getServerStateLocation((IServer)s).append("xpaths.xml").toFile();
        try {
            CreateServerCheckDefaultsTest.assertTrue((String)("The XPath File has not been created. Xpaths will be lost on workspace restart. " + xpathFile.getAbsolutePath()), (boolean)xpathFile.exists());
        }
        catch (Error t) {
            t.printStackTrace();
            throw t;
        }
        CreateServerCheckDefaultsTest.assertNull((Object)XPathModel.getDefault().getQuery(null, null));
        CreateServerCheckDefaultsTest.assertNull((Object)XPathModel.getDefault().getQuery(s, null));
        CreateServerCheckDefaultsTest.assertNull((Object)XPathModel.getDefault().getQuery(s, (IPath)new Path(XPathModel.PORTS_CATEGORY_NAME)));
        XPathCategory cat = XPathModel.getDefault().getCategory(s, XPathModel.PORTS_CATEGORY_NAME);
        XPathQuery[] qs = cat.getQueries();
        CreateServerCheckDefaultsTest.assertFalse((qs == null || qs.length == 0 ? 1 : 0) != 0);
        String name = qs[0].getName();
        CreateServerCheckDefaultsTest.assertNotNull((Object)name);
        XPathQuery q = XPathModel.getDefault().getQuery(s, new Path(XPathModel.PORTS_CATEGORY_NAME).append(name));
        CreateServerCheckDefaultsTest.assertNotNull((Object)q);
        q = XPathModel.getDefault().getQuery(s, new Path("GaRbAgE").append(name));
        CreateServerCheckDefaultsTest.assertNull((Object)q);
        CreateServerCheckDefaultsTest.assertTrue((boolean)XPathModel.getDefault().containsCategory(s, XPathModel.PORTS_CATEGORY_NAME));
        CreateServerCheckDefaultsTest.assertFalse((boolean)XPathModel.getDefault().containsCategory(s, "GaRbAgE"));
    }

    @Test
    public void testDefaultFilesetsAdded() {
        Fileset[] fs = FilesetUtil.loadFilesets((IServer)this.server);
        String typeId = this.server.getServerType().getId();
        if (typeId.equals("org.jboss.ide.eclipse.as.systemCopyServer")) {
            CreateServerCheckDefaultsTest.assertTrue((String)"Deploy-only Servers should have no default filesets.", (fs == null || fs.length == 0 ? 1 : 0) != 0);
            return;
        }
        CreateServerCheckDefaultsTest.assertNotNull((String)"No filesets created", (Object)fs);
        CreateServerCheckDefaultsTest.assertTrue((String)("0 filesets added for server type " + this.serverType), (fs.length > 0 ? 1 : 0) != 0);
    }

    private IJBossServerRuntime getJBossRuntime(IServer s) {
        return RuntimeUtils.getJBossServerRuntime((IRuntime)s.getRuntime());
    }
}

