/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.parametized.server.publishing;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.server.core.IModule;
import org.jboss.ide.eclipse.archives.core.util.internal.TrueZipUtil;
import org.jboss.ide.eclipse.as.core.modules.SingleDeployableFactory;
import org.jboss.tools.as.test.core.internal.MockPublishMethodFilesystemController;
import org.jboss.tools.as.test.core.internal.utils.MatrixUtils;
import org.jboss.tools.as.test.core.internal.utils.ResourceUtils;
import org.jboss.tools.as.test.core.internal.utils.wtp.CreateProjectOperationsUtility;
import org.jboss.tools.as.test.core.internal.utils.wtp.JavaEEFacetConstants;
import org.jboss.tools.as.test.core.internal.utils.wtp.OperationTestCase;
import org.jboss.tools.as.test.core.parametized.server.ServerParameterUtils;
import org.jboss.tools.as.test.core.parametized.server.publishing.AbstractPublishingTest;
import org.jboss.tools.test.util.JobUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SingleDeployableFolderTest
extends AbstractPublishingTest {
    public static final String PROJECT_ROOT_NAME = "SingleDeployableFolderTest";
    public static int count = 0;
    private String projectName;

    @Parameterized.Parameters
    public static Collection<Object[]> params() {
        String[] servers = ServerParameterUtils.getPublishServerTypes();
        String[] zipOption = ServerParameterUtils.getServerZipOptions();
        Object[][] allOptions = new Object[][]{servers, zipOption, {"metadata"}, {"permod_default"}};
        return MatrixUtils.toMatrix(allOptions);
    }

    public SingleDeployableFolderTest(String serverType, String zip, String deployLoc, String perMod) {
        super(serverType, zip, deployLoc, perMod);
    }

    @Override
    protected void createProjects() throws Exception {
        this.projectName = PROJECT_ROOT_NAME + count;
        ++count;
        IDataModel dm = CreateProjectOperationsUtility.getEARDataModel(this.projectName, "earContent", null, null, JavaEEFacetConstants.EAR_5, false);
        OperationTestCase.runAndVerify(dm);
        IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName);
        SingleDeployableFolderTest.assertTrue((boolean)p.exists());
        IFolder folder1 = p.getFolder("folder1");
        folder1.create(false, true, (IProgressMonitor)new NullProgressMonitor());
        ResourceUtils.createFile(p, "folder1/file1.txt", "file1 edit1");
        ResourceUtils.createFile(p, "folder1/file2.txt", "file2 edit1");
        IModule[] mods = SingleDeployableFactory.getFactory().getModules();
        SingleDeployableFolderTest.assertEquals((int)mods.length, (int)0);
        SingleDeployableFactory.makeDeployable((IResource)folder1);
        mods = SingleDeployableFactory.getFactory().getModules();
        SingleDeployableFolderTest.assertEquals((int)mods.length, (int)1);
        this.addModuleToServer(mods[0]);
    }

    @Test
    public void testSingleDeployableFolder() throws IOException, CoreException {
        IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName);
        String file1Path = "folder1/file1.txt";
        String file2Path = "folder1/file2.txt";
        Path f1Path = new Path(file1Path);
        Path f2Path = new Path(file2Path);
        this.fullPublishAndVerify1("file1 edit1", "file2 edit1");
        ResourceUtils.setContents(p, (IPath)f1Path, "file1 edit2");
        JobUtils.waitForIdle();
        this.incrementalOneFileChangedPublishAndVerify1((IPath)f1Path, "file1 edit2");
        ResourceUtils.setContents(p, (IPath)f2Path, "file2 edit2");
        JobUtils.waitForIdle();
        this.incrementalOneFileChangedPublishAndVerify1((IPath)f2Path, "file2 edit2");
        String f1e3Cont = "file1 edit3";
        String f2e3Cont = "file2 edit3";
        ResourceUtils.setContents(p, (IPath)f1Path, f1e3Cont);
        ResourceUtils.setContents(p, (IPath)f2Path, f2e3Cont);
        this.incrementalFilesChangedPublishAndVerify1(new IPath[]{f1Path, f2Path}, new String[]{f1e3Cont, f2e3Cont});
        String f3Loc = "folder1/file3.txt";
        Path f3Path = new Path(f3Loc);
        ResourceUtils.createFile(p, f3Loc, "file3 added");
        this.incrementalFilesChangedPublishAndVerify1(new IPath[]{f3Path}, new String[]{"file3 added"});
        ResourceUtils.createFile(p, f3Loc, "file3 added");
        this.incrementalFilesChangedPublishAndVerify1(new IPath[]{f3Path}, new String[]{"file3 added"});
        IFile f3 = p.getFile((IPath)f3Path);
        f3.delete(false, null);
        this.incrementalFilesRemovedPublishAndVerify1((IPath)f3Path);
    }

    private void incrementalOneFileChangedPublishAndVerify1(IPath filePath, String fileContents) throws CoreException, IOException {
        this.incrementalFilesChangedPublishAndVerify1(new IPath[]{filePath}, new String[]{fileContents});
    }

    private void fullPublishAndVerify1(String file1Contents, String file2Contents) throws CoreException, IOException {
        int[] nArray;
        SingleDeployableFolderTest.publishAndCheckError(this.server, 2);
        if (this.isZipped()) {
            int[] nArray2 = new int[2];
            nArray2[0] = 1;
            nArray = nArray2;
            nArray2[1] = 1;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = 3;
            nArray = nArray3;
            nArray3[1] = 1;
        }
        int[] vals = nArray;
        vals[0] = vals[0] + this.getFullPublishChangedResourceCountModifier();
        vals[1] = vals[1] + this.getFullPublishRemovedResourceCountModifier();
        this.verifyPublishMethodFilesystemResults(vals[0], vals[1]);
    }

    private void incrementalFilesChangedPublishAndVerify1(IPath[] filePath, String[] fileContents) throws CoreException, IOException {
        int[] nArray;
        SingleDeployableFolderTest.publishAndCheckError(this.server, 1);
        if (this.isZipped()) {
            int[] nArray2 = new int[2];
            nArray2[0] = 1;
            nArray = nArray2;
            nArray2[1] = 1;
        } else {
            int[] nArray3 = new int[2];
            nArray = nArray3;
            nArray3[0] = filePath.length;
        }
        int[] vals = nArray;
        vals[0] = vals[0] + (this.isZipped() ? this.getFullPublishChangedResourceCountModifier() : 1);
        vals[1] = vals[1] + (this.isZipped() ? this.getFullPublishRemovedResourceCountModifier() : 0);
        this.verifyPublishMethodFilesystemResults(vals[0], vals[1]);
        File[] changed = MockPublishMethodFilesystemController.StaticModel.getChangedFiles();
        if (this.isZipped()) {
            this.verifyZipContents(changed, filePath, fileContents);
        }
    }

    private void incrementalFilesRemovedPublishAndVerify1(IPath filePath) throws CoreException, IOException {
        SingleDeployableFolderTest.publishAndCheckError(this.server, 1);
        IPath[] removed = MockPublishMethodFilesystemController.StaticModel.getRemoved();
        if (!this.isZipped()) {
            boolean foundRemoved = false;
            int i = 0;
            while (i < removed.length) {
                if (removed[i].lastSegment().equals(filePath.lastSegment())) {
                    foundRemoved = true;
                }
                ++i;
            }
            SingleDeployableFolderTest.assertTrue((String)"Incremental removal has failed", (boolean)foundRemoved);
        } else {
            File foundZip = this.findZip(MockPublishMethodFilesystemController.StaticModel.getChangedFiles());
            de.schlichtherle.io.File zipRoot = new de.schlichtherle.io.File(foundZip, TrueZipUtil.getJarArchiveDetector());
            de.schlichtherle.io.File removed2 = new de.schlichtherle.io.File((File)zipRoot, filePath.removeFirstSegments(1).toString());
            SingleDeployableFolderTest.assertFalse((boolean)removed2.exists());
        }
    }
}

