/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.parametized.server.publishing.defect;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.jboss.ide.eclipse.archives.core.util.internal.TrueZipUtil;
import org.jboss.tools.as.test.core.ASMatrixTests;
import org.jboss.tools.as.test.core.internal.utils.IOUtil;
import org.jboss.tools.as.test.core.internal.utils.MatrixUtils;
import org.jboss.tools.as.test.core.internal.utils.MockModule;
import org.jboss.tools.as.test.core.internal.utils.MockModuleUtil;
import org.jboss.tools.as.test.core.parametized.server.publishing.AbstractPublishingTest;
import org.jboss.tools.as.test.core.subsystems.impl.CustomPublishController;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class UtilInWebPathDefectTest
extends AbstractPublishingTest {
    private IModule[] module;

    @Parameterized.Parameters
    public static Collection<Object[]> params() {
        String[] servers = new String[]{"org.jboss.ide.eclipse.as.71"};
        String[] zipOption = new String[]{"unzipped"};
        String[] defaultDeployLoc = new String[]{"metadata"};
        String[] perModOverrides = new String[]{"permod_default"};
        Object[][] allOptions = new Object[][]{servers, zipOption, defaultDeployLoc, perModOverrides};
        return MatrixUtils.toMatrix(allOptions);
    }

    public UtilInWebPathDefectTest(String serverType, String zip, String deployLoc, String perMod) {
        super(serverType, zip, deployLoc, perMod);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp(false);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    protected void createProjects() throws Exception {
        this.module = this.createUtilInWebInEarModule();
        this.addModuleToServer(this.module[0]);
    }

    @Test
    public void testPublish() throws Exception {
        CustomPublishController controller = new CustomPublishController();
        controller.initialize((IServerAttributes)this.server, null, null);
        IModule[] web = new IModule[]{this.module[0]};
        IModule[] utilInWeb = new IModule[]{this.module[0], this.module[1]};
        controller.publishStart((IProgressMonitor)new NullProgressMonitor());
        controller.publishServer(1, (IProgressMonitor)new NullProgressMonitor());
        int resultWeb = controller.publishModule(2, 1, web, (IProgressMonitor)new NullProgressMonitor());
        int resultUtil = controller.publishModule(2, 1, utilInWeb, (IProgressMonitor)new NullProgressMonitor());
        controller.publishFinish((IProgressMonitor)new NullProgressMonitor());
        UtilInWebPathDefectTest.assertEquals((int)resultWeb, (int)1);
        UtilInWebPathDefectTest.assertEquals((int)resultUtil, (int)1);
        IPath depPath = controller.getDeployPathController().getDeployDirectory(utilInWeb);
        de.schlichtherle.io.File f = new de.schlichtherle.io.File(depPath.toFile(), TrueZipUtil.getJarArchiveDetector());
        de.schlichtherle.io.File clazz1 = new de.schlichtherle.io.File((File)f, "Clazz1.class");
        UtilInWebPathDefectTest.assertTrue((boolean)clazz1.exists());
    }

    private boolean testIsZip() {
        return this.param_zip.equals("zipped");
    }

    private IPath getUnderlying() {
        IPath underlying = ASMatrixTests.getDefault().getStateLocation().append("underlying.txt");
        return underlying;
    }

    private IPath setUnderlyingVersion(int v) throws Exception {
        IPath underlying = this.getUnderlying();
        underlying.toFile().getParentFile().mkdirs();
        IOUtil.setContents(underlying.toFile(), "version" + v);
        return underlying;
    }

    private IPath[] getUtilLeafPaths() {
        return new IPath[]{new Path("Clazz1.class"), new Path("Clazz2.class"), new Path("Clazz3.class"), new Path("Clazz4.class")};
    }

    private IPath[] getWebLeafPaths() {
        IPath[] leafs = new IPath[]{new Path("w"), new Path("x"), new Path("y"), new Path("z"), new Path("a/a1"), new Path("a/a2"), new Path("a/q1"), new Path("a/q2"), new Path("b/b1"), new Path("b/b2"), new Path("b/b3"), new Path("b/b4"), new Path("c/y1"), new Path("c/y2.png"), new Path("c/y3.jpg"), new Path("c/y4.pdf"), new Path("d/F/f1.jar"), new Path("d/F/f2.txt"), new Path("d/F/f3.txt"), new Path("d/F/f4.txt")};
        return leafs;
    }

    private MockModule[] createUtilInWebInEarModule() throws Exception {
        IPath underlying = this.setUnderlyingVersion(1);
        MockModule web = MockModuleUtil.createMockWebModule();
        MockModule util = MockModuleUtil.createMockUtilModule();
        web.addChildModule(util, "WEB-INF/lib/util.jar");
        IPath[] webLeafs = this.getWebLeafPaths();
        IModuleResource[] webR = MockModuleUtil.createMockResources(webLeafs, new IPath[0], underlying.toFile());
        web.setMembers(webR);
        web.setExists(true);
        IPath[] utilLeafs = this.getUtilLeafPaths();
        IModuleResource[] utilR = MockModuleUtil.createMockResources(utilLeafs, new IPath[0], underlying.toFile());
        util.setMembers(utilR);
        util.setExists(true);
        return new MockModule[]{web, util};
    }

    protected void verifyListRelativePath(IPath root, List<IPath> list, boolean exists) {
        ArrayList<IPath> list2 = new ArrayList<IPath>();
        Iterator<IPath> i = list.iterator();
        while (i.hasNext()) {
            list2.add(root.append(i.next()));
        }
        super.verifyList(root, list2, exists);
    }
}

