/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.internal.management.wildfly8;

import java.text.MessageFormat;
import java.util.concurrent.Future;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.jboss.as.controller.client.helpers.standalone.DeploymentAction;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentActionResult;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentPlanResult;
import org.jboss.ide.eclipse.as.internal.management.wildfly8.Messages;
import org.jboss.ide.eclipse.as.management.core.IJBoss7DeploymentResult;
import org.jboss.ide.eclipse.as.management.core.JBoss7ManangerException;

public class DeploymentOperationResult
implements IJBoss7DeploymentResult {
    private Future<ServerDeploymentPlanResult> planResult;
    private DeploymentAction action;

    DeploymentOperationResult(DeploymentAction action, Future<ServerDeploymentPlanResult> planResult) {
        Assert.isNotNull((Object)action);
        this.action = action;
        Assert.isNotNull(planResult);
        this.planResult = planResult;
    }

    public IStatus getStatus() throws JBoss7ManangerException {
        try {
            ServerDeploymentActionResult actionResult = this.planResult.get().getDeploymentActionResult(this.action.getId());
            return this.createStatus(this.action.getDeploymentUnitUniqueName(), this.action.getType().name(), actionResult);
        }
        catch (Exception e) {
            throw new JBoss7ManangerException((Throwable)e);
        }
    }

    private IStatus createStatus(String deploymentName, String actionName, ServerDeploymentActionResult actionResult) {
        if (actionResult == null) {
            return null;
        }
        IStatus status = null;
        switch (actionResult.getResult()) {
            case NOT_EXECUTED: {
                status = this.createStatus(4, NLS.bind((String)Messages.OperationOnUnitNotExecuted, (Object)actionName, (Object)deploymentName), new Object[0]);
                break;
            }
            case EXECUTED: {
                status = Status.OK_STATUS;
                break;
            }
            case FAILED: {
                status = this.createStatus(4, NLS.bind((String)Messages.OperationOnUnitFailed, (Object)actionName, (Object)deploymentName), new Object[0]);
                break;
            }
            case ROLLED_BACK: {
                status = this.createStatus(4, NLS.bind((String)Messages.OperationOnUnitRolledBack, (Object)actionName, (Object)deploymentName), new Object[0]);
                break;
            }
            case CONFIGURATION_MODIFIED_REQUIRES_RESTART: {
                status = this.createStatus(2, NLS.bind((String)Messages.OperationNotExecConfigRequiresRestart, (Object)actionName, (Object)deploymentName), new Object[0]);
            }
        }
        return status;
    }

    private IStatus createStatus(int severity, String messagePattern, Object ... messageArguments) {
        return new Status(severity, "org.jboss.ide.eclipse.as.management.wildfly8", MessageFormat.format(messagePattern, messageArguments));
    }
}

