/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.local.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.jmx.local.internal.Activator;
import org.jboss.tools.jmx.local.ui.JVMLabelProviderDelegate;

public class JmxLocalExtensionManager {
    private static JmxLocalExtensionManager instance;
    private ArrayList<WeightedLabelProvider> weightedLabelProviders = null;

    public static synchronized JmxLocalExtensionManager getDefault() {
        if (instance == null) {
            instance = new JmxLocalExtensionManager();
        }
        return instance;
    }

    public JmxLocalExtensionManager() {
        this.loadLabelProviders();
    }

    public void loadLabelProviders() {
        this.weightedLabelProviders = new ArrayList();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor(Activator.PLUGIN_ID, "jvmConnectionLabelProvider");
        int i = 0;
        while (i < cf.length) {
            WeightedLabelProvider sspt = new WeightedLabelProvider(cf[i]);
            this.weightedLabelProviders.add(sspt);
            ++i;
        }
        Collections.sort(this.weightedLabelProviders, new Comparator<WeightedLabelProvider>(){

            @Override
            public int compare(WeightedLabelProvider o1, WeightedLabelProvider o2) {
                return o1.getWeight() - o2.getWeight();
            }
        });
    }

    public JVMLabelProviderDelegate[] getJvmConnectionLabelProviders() {
        ArrayList<JVMLabelProviderDelegate> ret = new ArrayList<JVMLabelProviderDelegate>();
        Iterator<WeightedLabelProvider> i = this.weightedLabelProviders.iterator();
        while (i.hasNext()) {
            JVMLabelProviderDelegate h = i.next().getLabelProvider();
            if (h == null) continue;
            ret.add(h);
        }
        return ret.toArray(new JVMLabelProviderDelegate[ret.size()]);
    }

    private static class WeightedLabelProvider {
        private IConfigurationElement el;
        private JVMLabelProviderDelegate handler;
        private int weight = Integer.MIN_VALUE;
        private boolean loadFailed = false;

        public WeightedLabelProvider(IConfigurationElement el) {
            this.el = el;
        }

        public int getWeight() {
            if (this.weight == Integer.MIN_VALUE) {
                String s = this.el.getAttribute("weight");
                try {
                    if (s != null) {
                        int i;
                        this.weight = i = Integer.parseInt(s);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.weight = -1;
                }
            }
            return this.weight;
        }

        public JVMLabelProviderDelegate getLabelProvider() {
            if (this.handler == null && !this.loadFailed) {
                try {
                    this.handler = (JVMLabelProviderDelegate)this.el.createExecutableExtension("class");
                }
                catch (CoreException coreException) {
                    this.loadFailed = true;
                }
            }
            return this.handler;
        }
    }
}

