/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.launch;

import java.util.Collection;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.JBossExtendedProperties;
import org.jboss.ide.eclipse.as.core.util.ServerAttributeHelper;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ControllableServerBehavior;
import org.jboss.tools.as.test.core.ASMatrixTests;
import org.jboss.tools.as.test.core.internal.utils.ServerCreationTestUtils;
import org.jboss.tools.as.test.core.internal.utils.ServerParameterUtils;
import org.junit.After;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MockArgsTests
extends TestCase {
    private String serverType;
    private IServer server;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return ServerParameterUtils.asCollection(ServerParameterUtils.getJBossServerTypeParameters());
    }

    public MockArgsTests(String serverType) {
        this.serverType = serverType;
    }

    @After
    public void tearDown() throws Exception {
        ASMatrixTests.cleanup();
    }

    protected IServer runAndVerifyArgs() {
        IServer server = ServerCreationTestUtils.createMockServerWithRuntime(this.serverType, this.serverType);
        IServer fixed = this.setMockDetails(server);
        IProcess p = this.runAndGetProcess(server);
        MockArgsTests.assertNotNull((String)"Process must not be null", (Object)p);
        String command = p == null ? null : p.getAttribute(IProcess.ATTR_CMDLINE);
        MockArgsTests.assertFalse((String)("No args found from process for server type " + server.getServerType().getId()), (command == null || command.trim().length() == 0 ? 1 : 0) != 0);
        try {
            JBossExtendedProperties props = (JBossExtendedProperties)server.loadAdapter(JBossExtendedProperties.class, (IProgressMonitor)new NullProgressMonitor());
            String defaultArgs = props.getDefaultLaunchArguments().getStartDefaultProgramArgs().replace("\"", "");
            String defaultVMArgs = props.getDefaultLaunchArguments().getStartDefaultProgramArgs().replace("\"", "");
            String safeQuotes = command.replace("\"", "").replaceAll("[ ]+", " ");
            defaultArgs = defaultArgs.trim().replaceAll("[ ]+", " ");
            MockArgsTests.assertTrue((String)(String.valueOf(safeQuotes) + " should contain " + defaultArgs), (boolean)safeQuotes.contains(defaultArgs));
            defaultVMArgs = defaultVMArgs.replace(server.getRuntime().getRuntimeType().getId(), this.serverType);
            defaultVMArgs = defaultVMArgs.trim().replaceAll("[ ]+", " ");
            MockArgsTests.assertTrue((boolean)safeQuotes.contains(defaultVMArgs));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fixed;
    }

    @Test
    public void testRemoveCriticalVMArgs() {
        IServer server = this.runAndVerifyArgs();
        try {
            ILaunchConfiguration config = server.getLaunchConfiguration(true, (IProgressMonitor)new NullProgressMonitor());
            ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "hello");
            wc.doSave();
            ILaunchConfiguration launchConfig = server.getLaunchConfiguration(false, null);
            String vmArgs = launchConfig.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, null);
            MockArgsTests.assertFalse((vmArgs == null ? 1 : 0) != 0);
            JBossExtendedProperties props = (JBossExtendedProperties)server.loadAdapter(JBossExtendedProperties.class, (IProgressMonitor)new NullProgressMonitor());
            String defaultVMArgs = props.getDefaultLaunchArguments().getStartDefaultProgramArgs().replace("\"", "");
            MockArgsTests.assertFalse((boolean)vmArgs.equals(defaultVMArgs));
            MockArgsTests.assertTrue((vmArgs.trim().length() > "hello".length() ? 1 : 0) != 0);
        }
        catch (CoreException ce) {
            MockArgsTests.fail((String)ce.getMessage());
        }
    }

    protected IProcess runAndGetProcess(IServer server) {
        try {
            server.start("run", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {}
        int loops = 0;
        ControllableServerBehavior behavior = (ControllableServerBehavior)server.loadAdapter(ControllableServerBehavior.class, null);
        while (loops < 500) {
            Object p = behavior.getSharedData("AbstractStartJavaServerLaunchDelegate.Process");
            if (p != null) {
                MockArgsTests.assertTrue((boolean)(p instanceof IProcess));
                return (IProcess)p;
            }
            try {
                ++loops;
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        return null;
    }

    protected String runAndGetCommand(IServer server) {
        IProcess p = this.runAndGetProcess(server);
        return p == null ? null : p.getAttribute(IProcess.ATTR_CMDLINE);
    }

    private IServer setMockDetails(IServer server) {
        IServerWorkingCopy copy = server.createWorkingCopy();
        ServerAttributeHelper helper = new ServerAttributeHelper(server, copy);
        helper.setAttribute("start-timeout", "2");
        helper.setAttribute("org.jboss.ide.eclipse.as.core.server.attributes.startupPollerKey", "org.jboss.ide.eclipse.as.core.runtime.server.timeoutpoller");
        try {
            return copy.save(true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            return null;
        }
    }
}

