/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.parametized.server.publishing;

import de.schlichtherle.io.ArchiveDetector;
import de.schlichtherle.io.FileInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.ServerPreferences;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.validation.ValidationFramework;
import org.jboss.ide.eclipse.archives.core.util.TrueZipUtil;
import org.jboss.ide.eclipse.as.core.server.IDeployableServer;
import org.jboss.ide.eclipse.as.core.server.internal.DeployableServer;
import org.jboss.ide.eclipse.as.core.server.internal.ExtendedServerPropertiesAdapterFactory;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.ServerExtendedProperties;
import org.jboss.ide.eclipse.as.core.server.internal.v7.DeploymentMarkerUtils;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ServerProfileModel;
import org.jboss.tools.as.core.internal.modules.DeploymentModulePrefs;
import org.jboss.tools.as.core.internal.modules.DeploymentPreferences;
import org.jboss.tools.as.core.internal.modules.DeploymentPreferencesLoader;
import org.jboss.tools.as.test.core.ASMatrixTests;
import org.jboss.tools.as.test.core.internal.MockPublishMethodFilesystemController;
import org.jboss.tools.as.test.core.internal.utils.IOUtil;
import org.jboss.tools.as.test.core.internal.utils.MatrixUtils;
import org.jboss.tools.as.test.core.internal.utils.ResourceUtils;
import org.jboss.tools.as.test.core.internal.utils.ServerCreationTestUtils;
import org.jboss.tools.as.test.core.parametized.server.ServerParameterUtils;
import org.jboss.tools.test.util.JobUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class AbstractPublishingTest
extends TestCase {
    protected String param_serverType;
    protected String param_zip;
    protected String param_deployLoc;
    protected String param_perModOverride;
    protected IServer server;
    protected IServerWorkingCopy wc;
    protected String serverDeployPath;
    protected String serverTempDeployPath;
    protected IModule primaryModule;

    public static ArrayList<Object[]> defaultData() {
        String[] servers = ServerParameterUtils.getPublishServerTypes();
        String[] zipOption = ServerParameterUtils.getServerZipOptions();
        String[] defaultDeployLoc = ServerParameterUtils.getDefaultDeployOptions();
        String[] perModOverrides = ServerParameterUtils.getPerModuleOverrideOptions();
        Object[][] allOptions = new Object[][]{servers, zipOption, defaultDeployLoc, perModOverrides};
        return MatrixUtils.toMatrix(allOptions);
    }

    public static ArrayList<Object[]> minimalData() {
        String[] servers = ServerParameterUtils.getPublishServerTypes();
        String[] zipOption = ServerParameterUtils.getServerZipOptions();
        Object[] defaultDeployLoc = new Object[]{"metadata"};
        Object[] perModOverrides = new Object[]{"permod_default"};
        Object[][] allOptions = new Object[][]{servers, zipOption, defaultDeployLoc, perModOverrides};
        return MatrixUtils.toMatrix(allOptions);
    }

    public AbstractPublishingTest(String serverType, String zip, String deployLoc, String perMod) {
        this.param_serverType = serverType;
        this.param_zip = zip;
        this.param_deployLoc = deployLoc;
        this.param_perModOverride = perMod;
    }

    protected void printConstructor() {
        System.out.println(String.valueOf(((Object)((Object)this)).getClass().getName()) + ":  " + this.param_serverType + ", " + this.param_zip + ", " + this.param_deployLoc + ", " + this.param_perModOverride);
    }

    @Before
    public void setUp() throws Exception {
        this.setUp(true);
    }

    protected void setUp(boolean setMock4) throws Exception {
        this.printConstructor();
        ServerPreferences.getInstance().setAutoPublishing(false);
        ValidationFramework.getDefault().suspendAllValidation(true);
        JobUtils.waitForIdle();
        this.server = ServerCreationTestUtils.createMockServerWithRuntime(this.param_serverType, String.valueOf(((Object)((Object)this)).getClass().getName()) + this.param_serverType);
        this.wc = this.server.createWorkingCopy();
        if (setMock4) {
            this.setMockPublishMethod4(this.wc);
        }
        this.setupZipParam(this.wc);
        this.setupDeployTypeParam(this.wc);
        this.createProjects();
        this.completeSetUp();
        this.server = this.wc.save(false, (IProgressMonitor)new NullProgressMonitor());
    }

    protected void completeSetUp() {
    }

    @BeforeClass
    public static void beforeClass() {
        ValidationFramework.getDefault().suspendAllValidation(true);
    }

    @AfterClass
    public static void afterClass() {
        ValidationFramework.getDefault().suspendAllValidation(false);
    }

    @After
    public void tearDown() throws Exception {
        try {
            ASMatrixTests.cleanup();
        }
        finally {
            ValidationFramework.getDefault().suspendAllValidation(false);
        }
    }

    protected void setMockPublishMethod4(IServerWorkingCopy wc) {
        ServerProfileModel.setProfile((IServerWorkingCopy)wc, (String)"mock4");
    }

    protected void createProjects() throws Exception {
    }

    public void addModuleToServer(IModule module) throws CoreException {
        AbstractPublishingTest.assertNotNull((Object)module);
        this.primaryModule = module;
        this.wc.modifyModules(new IModule[]{module}, new IModule[0], (IProgressMonitor)new NullProgressMonitor());
        this.setCustomDeployOverride(module);
    }

    protected void setCustomDeployOverride(IModule module) {
        if (this.param_perModOverride.equals("permod_default")) {
            return;
        }
        String overrideFolder = null;
        String overrideTemp = null;
        if (this.param_perModOverride.equals("permod_absolute")) {
            overrideFolder = this.getAbsoluteOverrideFolder();
            overrideTemp = this.getAbsoluteTempOverrideFolder();
        } else if (this.param_perModOverride.equals("permod_relative")) {
            overrideFolder = this.getRelativeOverrideFolder();
            overrideTemp = this.getRelativeTempOverrideFolder();
        }
        this.setCustomDeployOverride(module, null, overrideFolder, overrideTemp);
    }

    protected void setCustomDeployOverride(IModule rootModule, String outputName, String outputDir, String temporaryDir) {
        AbstractPublishingTest.setCustomDeployOverride(this.wc, rootModule, outputName, outputDir, temporaryDir);
    }

    public static void setCustomDeployOverride(IServerWorkingCopy wc, IModule rootModule, String outputName, String outputDir, String temporaryDir) {
        DeploymentPreferences prefs = DeploymentPreferencesLoader.loadPreferencesFromServer((IServerAttributes)wc);
        DeploymentModulePrefs modPrefs = prefs.getOrCreatePreferences().getOrCreateModulePrefs(rootModule);
        modPrefs.setProperty("tempLocation", temporaryDir);
        modPrefs.setProperty("location", outputDir);
        modPrefs.setProperty("outputName", outputName);
        DeploymentPreferencesLoader.savePreferencesToServerWorkingCopy((IServerWorkingCopy)wc, (DeploymentPreferences)prefs);
    }

    protected void setupZipParam(IServerWorkingCopy wc) {
        if (this.isZipped()) {
            ServerConverter.getDeployableServer((IServerAttributes)wc).setZipWTPDeployments(true);
        }
    }

    protected boolean isZipped() {
        return this.param_zip.equals("zipped");
    }

    protected void setupDeployTypeParam(IServerWorkingCopy wc) {
        IDeployableServer ds = ServerConverter.getDeployableServer((IServerAttributes)wc);
        if (!this.server.getServerType().getId().equals("org.jboss.ide.eclipse.as.systemCopyServer")) {
            if (this.param_deployLoc.equals("metadata")) {
                ds.setDeployLocationType("metadata");
            }
            if (this.param_deployLoc.equals("server")) {
                ds.setDeployLocationType("server");
            }
            if (this.param_deployLoc.equals("customNull") || this.param_deployLoc.equals("customAbsolute") || this.param_deployLoc.equals("customRelative")) {
                ds.setDeployLocationType("custom");
            }
            if (this.param_deployLoc.equals("customAbsolute")) {
                String f = this.getCustomAbsoluteFolder();
                new File(f).mkdirs();
                ds.setDeployFolder(f);
                String f2 = this.getCustomAbsoluteTempFolder();
                new File(f2).mkdirs();
                ds.setTempDeployFolder(f2);
            } else if (this.param_deployLoc.equals("customRelative")) {
                String f = this.getCustomRelativeFolder();
                this.server.getRuntime().getLocation().append(f).toFile().mkdirs();
                ds.setDeployFolder(f);
                String f2 = this.getCustomRelativeTempFolder();
                this.server.getRuntime().getLocation().append(f2).toFile().mkdirs();
                ds.setTempDeployFolder(f2);
            }
        }
        this.serverDeployPath = ds.getDeployFolder();
        this.serverTempDeployPath = ds.getTempDeployFolder();
    }

    private String getCustomAbsoluteFolder() {
        return ServerCreationTestUtils.getRandomAbsoluteFolder().append("final").toOSString();
    }

    private String getCustomAbsoluteTempFolder() {
        return ServerCreationTestUtils.getRandomAbsoluteFolder().append("tmp").toOSString();
    }

    private String getAbsoluteOverrideFolder() {
        return ServerCreationTestUtils.getRandomAbsoluteFolder().append("finalOverride").toOSString();
    }

    private String getAbsoluteTempOverrideFolder() {
        return ServerCreationTestUtils.getRandomAbsoluteFolder().append("tmpOverride").toOSString();
    }

    private String getRelativeOverrideFolder() {
        return ServerCreationTestUtils.getRandomAbsoluteFolder().append("finalOverride").toOSString();
    }

    private String getRelativeTempOverrideFolder() {
        return ServerCreationTestUtils.getRandomAbsoluteFolder().append("tmpOverride").toOSString();
    }

    private static boolean isJBoss7Style(IServer server) {
        ServerExtendedProperties sep = ExtendedServerPropertiesAdapterFactory.getServerExtendedProperties((IServerAttributes)server);
        boolean as7Style = sep.getFileStructure() == 2;
        return as7Style;
    }

    private String getCustomRelativeFolder() {
        if (AbstractPublishingTest.isJBoss7Style(this.server)) {
            return "myDeploy/final";
        }
        return "server/myDeploy/final";
    }

    private String getCustomRelativeTempFolder() {
        if (AbstractPublishingTest.isJBoss7Style(this.server)) {
            return "myDeploy/temp";
        }
        return "server/myDeploy/temp";
    }

    protected int getFullPublishChangedResourceCountModifier() {
        if (DeploymentMarkerUtils.supportsJBoss7MarkerDeployment((IServer)this.server)) {
            return 1;
        }
        return 0;
    }

    protected int getFullPublishRemovedResourceCountModifier() {
        if (DeploymentMarkerUtils.supportsJBoss7MarkerDeployment((IServer)this.server)) {
            return 2;
        }
        return 0;
    }

    protected static void publishAndCheckError(IServer server, int pubType) {
        MockPublishMethodFilesystemController.StaticModel.clearAll();
        server.publish(pubType, (IProgressMonitor)new NullProgressMonitor());
        JobUtils.waitForIdle();
    }

    protected void verifyPublishMethodResults(int changed, int removed) {
        IPath[] changed2 = MockPublishMethodFilesystemController.StaticModel.getChanged();
        IPath[] removed2 = MockPublishMethodFilesystemController.StaticModel.getRemoved();
        AbstractPublishingTest.assertEquals((int)changed2.length, (int)changed);
        AbstractPublishingTest.assertEquals((int)removed2.length, (int)removed);
    }

    protected void verifyPublishMethodFilesystemResults(int changed, int removed) {
        IPath[] changed2 = MockPublishMethodFilesystemController.StaticModel.getChanged();
        IPath[] removed2 = MockPublishMethodFilesystemController.StaticModel.getRemoved();
        AbstractPublishingTest.assertEquals((int)changed2.length, (int)changed);
        AbstractPublishingTest.assertEquals((int)removed2.length, (int)removed);
    }

    protected IModuleFile findModuleFile(IModuleFile[] files, IPath path) {
        int j = 0;
        while (j < files.length) {
            IPath p1 = files[j].getModuleRelativePath().append(files[j].getName());
            if (p1.makeRelative().equals((Object)path.makeRelative())) {
                return files[j];
            }
            ++j;
        }
        return null;
    }

    protected void verifyZipContents(IModuleFile[] files, IPath[] paths, String[] contents) throws CoreException, IOException {
        this.verifyZipContents(this.findZip(files), paths, contents);
    }

    protected void verifyZipContents(File[] files, IPath[] paths, String[] contents) throws CoreException, IOException {
        this.verifyZipContents(this.findZip(files), paths, contents);
    }

    protected void verifyZipContents(File foundZip, IPath[] paths, String[] contents) throws CoreException, IOException {
        int i = 0;
        while (i < paths.length) {
            IPath relative = paths[i].removeFirstSegments(1);
            de.schlichtherle.io.File zipRoot = new de.schlichtherle.io.File(foundZip, TrueZipUtil.getJarArchiveDetector());
            de.schlichtherle.io.File truezipFile = new de.schlichtherle.io.File((File)zipRoot, relative.toString(), (ArchiveDetector)ArchiveDetector.ALL);
            FileInputStream fis = new FileInputStream((File)truezipFile);
            byte[] b = IOUtil.getBytesFromInputStream((InputStream)fis);
            String b2 = new String(b);
            AbstractPublishingTest.assertEquals((String)b2, (String)contents[i]);
            ++i;
        }
    }

    protected void verifyWorkspaceContents(IModuleFile[] files, IPath[] paths, String[] contents) throws CoreException, IOException {
        int i = 0;
        while (i < paths.length) {
            IModuleFile mf = this.findModuleFile(files, paths[i].removeFirstSegments(1));
            AbstractPublishingTest.assertNotNull((String)("File not found: " + paths[i]), (Object)mf);
            String s = ResourceUtils.getContents(mf);
            AbstractPublishingTest.assertNotNull((String)"File contents are null", (Object)s);
            AbstractPublishingTest.assertEquals((String)"File contents does not match expected contents", (String)s, (String)contents[i]);
            ++i;
        }
    }

    protected File findZip(IModuleFile[] files) {
        File foundZip = null;
        int i = 0;
        while (i < files.length) {
            File f = (File)files[i].getAdapter(File.class);
            AbstractPublishingTest.assertNotNull((Object)f);
            boolean isZip = IOUtil.isZip(f);
            if (isZip && foundZip == null) {
                foundZip = f;
            } else if (isZip) {
                AbstractPublishingTest.fail((String)"Multiple top level zips found in zipped deployment");
            }
            ++i;
        }
        AbstractPublishingTest.assertNotNull((String)"Could not find a zipped file in the deployment", foundZip);
        return foundZip;
    }

    protected File findZip(File[] files) {
        File foundZip = null;
        int i = 0;
        while (i < files.length) {
            File f = files[i];
            AbstractPublishingTest.assertNotNull((Object)f);
            boolean isZip = IOUtil.isZip(f);
            if (isZip && foundZip == null) {
                foundZip = f;
            } else if (isZip) {
                AbstractPublishingTest.fail((String)"Multiple top level zips found in zipped deployment");
            }
            ++i;
        }
        AbstractPublishingTest.assertNotNull((String)"Could not find a zipped file in the deployment", foundZip);
        return foundZip;
    }

    protected IModule[] getModule(IProject p) {
        return new IModule[]{ServerUtil.getModule((IProject)p)};
    }

    protected IProject findProject(String name) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(name);
    }

    protected IPath getLocalPublishMethodDeployRoot() {
        DeployableServer ds = (DeployableServer)this.server.loadAdapter(DeployableServer.class, (IProgressMonitor)new NullProgressMonitor());
        IPath path = ds.getDeploymentLocation(new IModule[]{this.primaryModule}, true);
        return path;
    }

    protected void verifyList(IPath root, List<IPath> list, boolean exists) {
        Iterator<IPath> iterator = list.iterator();
        ArchiveDetector detector = this.isZipped() ? TrueZipUtil.getJarArchiveDetector() : TrueZipUtil.getDefaultArchiveDetector();
        while (iterator.hasNext()) {
            de.schlichtherle.io.File f = TrueZipUtil.getFile((File)root.toFile(), (ArchiveDetector)detector);
            IPath next = iterator.next();
            AbstractPublishingTest.assertTrue((String)(String.valueOf(next.toOSString()) + " must be a folder beneath " + root.toOSString()), (boolean)root.isPrefixOf(next));
            IPath nextTrimmed = next.removeFirstSegments(root.segmentCount()).setDevice(null);
            de.schlichtherle.io.File toCheck = TrueZipUtil.getFile((File)f, (String)nextTrimmed.toString(), (ArchiveDetector)TrueZipUtil.getDefaultArchiveDetector());
            AbstractPublishingTest.assertEquals((String)("File " + next.toOSString() + (exists ? " should " : " should not ") + "exist"), (boolean)toCheck.exists(), (boolean)exists);
        }
        TrueZipUtil.umount();
    }
}

