/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.catalog.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyReleasedSchemaToJBossOrg {
    private static File dumpingGround;

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage:  java CopyReleasedSchemaToJBossOrg /home/user/apps/wildfly10/docs/schema /home/user/code/jboss.org.schema [relativePathForUnMatched]");
            return;
        }
        File releaseSchemaHome = new File(args[0]);
        File jbossOrgHome = new File(args[1]);
        if (args.length == 3) {
            dumpingGround = new File(jbossOrgHome, args[2]);
        }
        File[] releasedSchemas = releaseSchemaHome.listFiles();
        int i = 0;
        while (i < releasedSchemas.length) {
            File f = releasedSchemas[i];
            File[] matching = CopyReleasedSchemaToJBossOrg.findMatchingFile(f, jbossOrgHome);
            if (matching != null && matching.length > 0) {
                int j = 0;
                while (j < matching.length) {
                    System.out.println("File " + f.getAbsolutePath() + " matches " + matching[j].getAbsolutePath());
                    CopyReleasedSchemaToJBossOrg.copy(f, matching[j]);
                    ++j;
                }
            } else {
                System.out.println("No matching file for " + f.getAbsolutePath());
                String fName = f.getName();
                Pattern r = Pattern.compile("(.*)[-_](\\d+[-_]\\d+).xsd");
                Matcher m = r.matcher(fName);
                if (m.find()) {
                    String prefix = m.group(1);
                    File[] possibleFolders = CopyReleasedSchemaToJBossOrg.findFolderContaining(jbossOrgHome, prefix);
                    System.out.println(possibleFolders.length);
                    if (possibleFolders.length > 0) {
                        int k = 0;
                        while (k < possibleFolders.length) {
                            CopyReleasedSchemaToJBossOrg.copy(f, new File(possibleFolders[k], f.getName()));
                            ++k;
                        }
                    } else if (dumpingGround != null) {
                        CopyReleasedSchemaToJBossOrg.copy(f, new File(dumpingGround, f.getName()));
                    }
                }
            }
            ++i;
        }
    }

    private static File[] findFolderContaining(File root, String prefix) {
        return CopyReleasedSchemaToJBossOrg.findPossibleMatchingFolder(root, prefix);
    }

    public static void copy(File source, File dest) {
        if (!dest.getParentFile().exists()) {
            dest.getParentFile().mkdirs();
        }
        try {
            Files.copy(Paths.get(source.getAbsolutePath(), new String[0]), Paths.get(dest.getAbsolutePath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException iOException) {
            System.err.println("Copy of " + source.getAbsolutePath() + " to " + dest.getAbsolutePath() + " has failed");
        }
    }

    public static File[] findMatchingFile(File f, File jbossOrgHome) {
        ArrayList<File> collector = new ArrayList<File>();
        CopyReleasedSchemaToJBossOrg.findMatchingFile(f, jbossOrgHome, collector);
        return collector.toArray(new File[collector.size()]);
    }

    public static void findMatchingFile(File f, File folder, ArrayList<File> collector) {
        String[] list = folder.list();
        if (Arrays.asList(list).contains(f.getName())) {
            collector.add(new File(folder, f.getName()));
        }
        int i = 0;
        while (i < list.length) {
            if (new File(folder, list[i]).isDirectory()) {
                CopyReleasedSchemaToJBossOrg.findMatchingFile(f, new File(folder, list[i]), collector);
            }
            ++i;
        }
    }

    public static File[] findPossibleMatchingFolder(File jbossOrgHome, String prefix) {
        ArrayList<File> collector = new ArrayList<File>();
        CopyReleasedSchemaToJBossOrg.findPossibleMatchingFolder(jbossOrgHome, prefix, collector);
        return collector.toArray(new File[collector.size()]);
    }

    public static void findPossibleMatchingFolder(File folder, String prefix, ArrayList<File> collector) {
        String[] list = folder.list();
        int i = 0;
        while (i < list.length) {
            if (list[i].startsWith(prefix) && !collector.contains(folder)) {
                collector.add(folder);
            }
            if (new File(folder, list[i]).isDirectory()) {
                CopyReleasedSchemaToJBossOrg.findPossibleMatchingFolder(new File(folder, list[i]), prefix, collector);
            }
            ++i;
        }
    }
}

